/*
 * Decompiled with CFR 0.152.
 */
package horst;

import de.netcomputing.util.Tracer;
import horst.Element;
import horst.ElementViewInfo;
import horst.HTMLDocument;
import horst.HTMLPane;
import horst.LayoutInfo;
import horst.TextAttributes;
import horst.Utilities;
import horst.View;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;

public class TextView
extends View {
    boolean m_bSplittable = true;
    Color m_color;
    int m_maxTokenLength = -1;
    Font m_SubSuperScriptFont;
    char[] debug;

    public TextView(View parent, Element e, HTMLPane container) {
        super(parent, e, container);
    }

    protected boolean canSplit(int width) {
        if (!this.m_bSplittable) {
            return false;
        }
        char[] data = this.m_elem.getCharData();
        FontMetrics fm = this.getFontMetrics();
        int delim = -1;
        int len = data.length;
        if (len < 2) {
            return false;
        }
        int last = -1;
        int currLen = 0;
        int i = 0;
        while (i < len) {
            if ((currLen += fm.charWidth(data[i])) > width) break;
            if (Character.isWhitespace(data[i])) {
                last = i;
            }
            ++i;
        }
        if (i == len) {
            return false;
        }
        return last != -1;
    }

    protected Color getColor() {
        if (this.isLink() && this.m_elem.getHasFocus()) {
            return this.m_elem.getFocusColor();
        }
        return this.m_color;
    }

    protected int getDescent() {
        return this.getFontMetrics().getDescent();
    }

    protected int getMaximumTokenLength() {
        if (this.m_maxTokenLength > -1) {
            return this.m_maxTokenLength;
        }
        this.m_maxTokenLength = 0;
        FontMetrics fm = this.getFontMetrics();
        char[] data = this.m_elem.getCharData();
        int p1 = data.length;
        int i = p1 - 1;
        while (i >= 0) {
            if (Character.isWhitespace(data[i])) {
                int offset = Math.min(i + 1, data.length);
                if (offset < data.length) {
                    int nChars = p1 - i - 1;
                    int strlen = fm.charsWidth(data, offset, nChars);
                    this.m_maxTokenLength = Math.max(strlen, this.m_maxTokenLength);
                }
                p1 = i;
            }
            --i;
        }
        if (p1 == data.length) {
            this.m_maxTokenLength = fm.charsWidth(data, 0, data.length);
        } else if (p1 > 0) {
            this.m_maxTokenLength = Math.max(this.m_maxTokenLength, fm.charsWidth(data, 0, p1));
        }
        return this.m_maxTokenLength;
    }

    protected int getMinimumSpan(int axis) {
        return this.getPreferredSpan(axis);
    }

    protected int getPreferredSpan(int axis) {
        if (axis == 1 && this.m_prefWidth != -1) {
            return this.m_prefWidth;
        }
        if (axis == 0 && this.m_prefHeight != -1) {
            return this.m_prefHeight;
        }
        if (this.m_elem.m_p0 > this.m_elem.m_p1) {
            Tracer.This.println("Element pointer corruption!!");
            this.m_prefWidth = 0;
            this.m_prefHeight = 0;
            return 0;
        }
        FontMetrics fm = axis == 1 && this.m_SubSuperScriptFont != null && (this.m_elem.isAttributeDefined("superscript") || this.m_elem.isAttributeDefined("subscript")) ? Toolkit.getDefaultToolkit().getFontMetrics(this.m_SubSuperScriptFont) : this.getFontMetrics();
        switch (axis) {
            case 1: {
                char[] data = this.m_elem.getCharData();
                this.m_prefWidth = fm.charsWidth(data, 0, data.length);
                return this.m_prefWidth;
            }
            case 0: {
                this.m_prefHeight = fm.getAscent();
                return this.m_prefHeight;
            }
        }
        return 0;
    }

    protected void init() {
        this.setInsets(0, 0, 0, 0);
        this.m_color = Utilities.setColorProperty(this.m_elem.getDocument().getTextColor(), "color", this.m_elem.getAttributes());
        if (this.m_elem.isAttributeDefined("superscript") || this.m_elem.isAttributeDefined("subscript")) {
            this.m_SubSuperScriptFont = TextAttributes.createFont(this.getFont(), "-2");
        }
        this.debug = this.m_elem.getCharData();
    }

    protected boolean isContainerView() {
        return false;
    }

    protected boolean isSplittable() {
        return true;
    }

    protected boolean isUnderlined() {
        boolean bLink = this.isLink();
        if (bLink && this.m_elem.m_relatedElements.size() == 0 && Utilities.isBlank(this.m_elem.getCharData())) {
            return false;
        }
        if (bLink) {
            return this.m_container.m_props.bUnderLineLinks;
        }
        boolean bUnderLine = false;
        String src = (String)this.m_elem.getAttribute("underline");
        if (src != null) {
            bUnderLine = src.equals("true");
        }
        return bUnderLine;
    }

    protected Rectangle layout(int x, int y, int width, LayoutInfo info) {
        width = this.getPreferredSpan(1);
        this.m_bounds = new Rectangle(x, y, width, this.getPreferredSpan(0));
        return this.m_bounds;
    }

    public void paint(Graphics g, Shape alloc) {
        Rectangle clip = alloc.getBounds();
        char[] data = this.m_elem.getCharData();
        if (this.m_bounds.intersects(clip) && data != null && data.length > 0) {
            Font oldFont = g.getFont();
            Color oldColor = g.getColor();
            Font f = this.getFont();
            g.setFont(f);
            FontMetrics fm = g.getFontMetrics();
            if (this.m_container.isTextSelected()) {
                int start = this.m_container.m_props.selectStartPosition;
                int end = this.m_container.m_props.selectEndPosition;
                if (start > end) {
                    int save = start;
                    start = end;
                    end = save;
                }
                boolean bSelection = true;
                int xStart = 0;
                int xEnd = 0;
                if (this.m_elem.m_p0 <= start && this.m_elem.m_p1 >= start && this.m_elem.m_p1 <= end) {
                    xStart = start;
                    xEnd = this.m_elem.m_p1;
                } else if (this.m_elem.m_p0 >= start && this.m_elem.m_p1 <= end) {
                    xStart = this.m_elem.m_p0;
                    xEnd = this.m_elem.m_p1;
                } else if (this.m_elem.m_p0 >= start && this.m_elem.m_p0 <= end && this.m_elem.m_p1 >= end) {
                    xStart = this.m_elem.m_p0;
                    xEnd = end;
                } else if (this.m_elem.m_p0 <= start && this.m_elem.m_p1 >= end) {
                    xStart = start;
                    xEnd = end;
                } else {
                    bSelection = false;
                }
                if (bSelection) {
                    int len = xEnd - xStart + 1;
                    char[] chardata = new char[len];
                    StringBuffer buffer = this.getDocument().getTextBuffer();
                    int i = 0;
                    int j = xStart;
                    while (i < len) {
                        chardata[i] = buffer.charAt(j);
                        ++i;
                        ++j;
                    }
                    int strWidth = fm.charsWidth(chardata, 0, chardata.length);
                    int offset = 0;
                    if (xStart > this.m_elem.m_p0) {
                        int slen = xStart - this.m_elem.m_p0;
                        char[] cdata = new char[slen];
                        int ii = 0;
                        int j2 = this.m_elem.m_p0;
                        while (ii < slen) {
                            cdata[ii] = buffer.charAt(j2);
                            ++ii;
                            ++j2;
                        }
                        offset = fm.stringWidth(new String(cdata));
                    }
                    g.setColor(Color.magenta);
                    g.fillRect(this.m_bounds.x + offset, this.m_bounds.y, strWidth, this.m_bounds.height + this.getDescent());
                }
            }
            g.setColor(this.getColor());
            if (this.m_elem.isAttributeDefined("superscript") && this.m_SubSuperScriptFont != null) {
                g.setFont(this.m_SubSuperScriptFont);
                FontMetrics fmetrics = g.getFontMetrics();
                fmetrics = g.getFontMetrics();
                g.drawChars(data, 0, data.length, this.m_bounds.x, this.m_bounds.y + fmetrics.getAscent() - fmetrics.getLeading() - fm.getDescent());
            } else if (this.m_elem.isAttributeDefined("subscript") && this.m_SubSuperScriptFont != null) {
                g.setFont(this.m_SubSuperScriptFont);
                FontMetrics fmetrics = g.getFontMetrics();
                g.drawChars(data, 0, data.length, this.m_bounds.x, this.m_bounds.y + this.m_bounds.height + this.getDescent());
            } else {
                g.drawChars(data, 0, data.length, this.m_bounds.x, this.m_bounds.y + this.m_bounds.height);
            }
            if (this.isUnderlined()) {
                int y = this.m_bounds.y + this.m_bounds.height + this.getDescent() / 2;
                g.drawLine(this.m_bounds.x, y, this.m_bounds.x + fm.charsWidth(data, 0, data.length), y);
            }
            this.drawDebugBox(g, Color.black);
            g.setFont(oldFont);
            g.setColor(oldColor);
        }
    }

    protected void reset() {
        this.m_elem.reset();
        this.m_maxTokenLength = -1;
    }

    protected void setCanWrap(boolean bSplittable) {
        this.m_bSplittable = bSplittable;
    }

    protected boolean setToLineStarter() {
        if (this.m_elem.m_bInPreformat) {
            return true;
        }
        char[] data = this.m_elem.getCharData();
        boolean isBlank = true;
        int i = 0;
        int trimPos = -1;
        while (i < data.length) {
            if (!Character.isWhitespace(data[i++])) {
                isBlank = false;
                break;
            }
            trimPos = i;
        }
        if (isBlank) {
            return false;
        }
        if (trimPos >= 0) {
            this.m_elem.m_p0 += trimPos;
        }
        return this.m_elem.m_p0 <= this.m_elem.m_p1;
    }

    protected View[] split(int width) {
        char[] data = this.m_elem.getCharData();
        FontMetrics fm = this.getFontMetrics();
        int lastWhiteSpace = -1;
        int currentLen = 0;
        int len = data.length;
        int delim = -1;
        int lenminus1 = len - 1;
        int i = 0;
        while (i < len) {
            if ((currentLen += fm.charWidth(data[i])) > width && delim > -1) break;
            if (Character.isWhitespace(data[i])) {
                delim = i;
            }
            ++i;
        }
        int lastPos = delim != -1 ? delim : Math.max(0, len - 1);
        Element e1 = new Element(this.m_elem);
        e1.m_p0 = this.m_elem.m_p0;
        e1.m_p1 = e1.m_p0 + lastPos;
        e1.m_anchor = this.m_elem.m_anchor;
        boolean bIsLink = this.m_elem.isLink();
        if (bIsLink) {
            Element[] relatedElems = this.m_elem.getRelatedElements();
            int j = 0;
            while (j < relatedElems.length) {
                e1.addRelatedElement(relatedElems[j]);
                ++j;
            }
        }
        View v1 = this.m_container.m_viewFactory.createView(null, e1, this.m_container);
        if (e1.m_p1 == this.m_elem.m_p1 || delim == -1) {
            if (this.m_elem.m_anchor != null) {
                Element[] newElems = new Element[]{e1};
                this.m_elem.m_anchor.replaceRelatedElement(this.m_elem, newElems);
            }
            View[] vws = new View[]{v1, null};
            return vws;
        }
        Element e2 = new Element(this.m_elem);
        e2.m_p0 = Math.min(this.m_elem.m_p1, e1.m_p1 + 1);
        e2.m_p1 = this.m_elem.m_p1;
        e2.m_anchor = this.m_elem.m_anchor;
        if (bIsLink) {
            Element[] relatedElems = this.m_elem.getRelatedElements();
            int j = 0;
            while (j < relatedElems.length) {
                e2.addRelatedElement(relatedElems[j]);
                ++j;
            }
        }
        View v2 = this.m_container.m_viewFactory.createView(null, e2, this.m_container);
        Element[] relates = this.m_elem.getRelatedElements();
        int j = 0;
        while (j < relates.length) {
            relates[j].addRelatedElement(e1);
            relates[j].addRelatedElement(e2);
            ++j;
        }
        e1.addRelatedElement(e2);
        e2.addRelatedElement(e1);
        if (this.m_elem.m_anchor != null) {
            Element[] newElems = new Element[]{e1, e2};
            this.m_elem.m_anchor.replaceRelatedElement(this.m_elem, newElems);
        }
        View[] vws = new View[]{v1, v2};
        return vws;
    }

    protected ElementViewInfo viewToModel(int x, int y) {
        ElementViewInfo info = null;
        Rectangle bounds = this.getBounds();
        if (bounds.contains(x, y)) {
            Element elem = this.m_elem;
            elem.m_textbufferPosition = 0;
            int nMaxChars = this.m_elem.m_p1 - this.m_elem.m_p0 + 1;
            HTMLDocument doc = this.getDocument();
            if (doc != null) {
                int nChars = 1;
                FontMetrics fm = this.getFontMetrics();
                StringBuffer buffer = doc.getTextBuffer();
                int strWidth = 0;
                if (buffer.length() > 0) {
                    char[] ary;
                    String testStr;
                    do {
                        ary = new char[nChars];
                        buffer.getChars(0, nChars, ary, 0);
                    } while (bounds.x + (strWidth = fm.stringWidth(testStr = new String(ary))) < x && ++nChars < nMaxChars);
                    elem.m_textbufferPosition = this.m_elem.m_p0 + nChars;
                }
            }
            info = new ElementViewInfo(elem, this);
        }
        return info;
    }
}

