/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import koala.dynamicjava.classfile.AttributeInfo;
import koala.dynamicjava.classfile.ClassIdentifier;
import koala.dynamicjava.classfile.ConstantPool;
import koala.dynamicjava.classfile.JVMUtilities;

public class ExceptionsAttribute
extends AttributeInfo {
    private List exceptionIndexTable;

    public ExceptionsAttribute(ConstantPool constantPool) {
        super(constantPool, "Exceptions");
        this.length = 2;
        this.exceptionIndexTable = new LinkedList();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.nameIndex);
        dataOutputStream.writeInt(this.length);
        dataOutputStream.writeShort(this.exceptionIndexTable.size());
        Iterator iterator = this.exceptionIndexTable.iterator();
        while (iterator.hasNext()) {
            dataOutputStream.writeShort(((Short)iterator.next()).shortValue());
        }
    }

    public void addException(String string) {
        String string2 = JVMUtilities.getName(string);
        this.exceptionIndexTable.add(new Short(this.constantPool.put(new ClassIdentifier(string2))));
        this.length += 2;
    }
}

