/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import koala.dynamicjava.gui.Main;
import koala.dynamicjava.gui.StringList;
import koala.dynamicjava.gui.URLChooser;
import koala.dynamicjava.gui.resource.ActionMap;
import koala.dynamicjava.gui.resource.ButtonFactory;
import koala.dynamicjava.gui.resource.MissingListenerException;
import koala.dynamicjava.gui.resource.ResourceManager;

public class OptionsDialog
extends JDialog
implements ActionMap {
    protected static final String RESOURCE = "koala.dynamicjava.gui.resources.options";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("koala.dynamicjava.gui.resources.options", Locale.getDefault());
    protected static ResourceManager rManager = new ResourceManager(bundle);
    protected StringList classPathList;
    protected StringList libraryPathList;
    protected URLChooser urlChooser;
    protected String[] classes;
    protected String[] libraries;
    protected Main mainFrame;
    protected InterpreterPanel interpreterPanel;
    protected GUIPanel guiPanel;
    protected Map listeners = new HashMap();

    public OptionsDialog(Main main) {
        super(main);
        this.mainFrame = main;
        this.urlChooser = new URLChooser(this, (Action)new UCOKButtonAction());
        this.listeners.put("OKButtonAction", new OKButtonAction());
        this.listeners.put("CancelButtonAction", new CancelButtonAction());
        this.setTitle(rManager.getString("Dialog.title"));
        ((Component)this).setSize(rManager.getInteger("Dialog.width"), rManager.getInteger("Dialog.height"));
        this.setModal(true);
        this.getContentPane().add(this.createTabbedPane());
        this.getContentPane().add("South", this.createButtonsPanel());
    }

    public Action getAction(String string) throws MissingListenerException {
        return (Action)this.listeners.get(string);
    }

    public String[] getClassPath() {
        return this.classPathList.getStrings();
    }

    public String[] getLibraryPath() {
        return this.libraryPathList.getStrings();
    }

    public String getInterpreterName() {
        return this.interpreterPanel.getName();
    }

    public boolean isInterpreterDefined() {
        return this.interpreterPanel.isExportationSelected();
    }

    public boolean isInitializationSelected() {
        return this.interpreterPanel.isInitializationSelected();
    }

    public String getInitializationFilename() {
        return this.interpreterPanel.getFilename();
    }

    public String getGUIName() {
        return this.guiPanel.getName();
    }

    public boolean isGUIDefined() {
        return this.guiPanel.isSelected();
    }

    public boolean isOutputSelected() {
        return this.guiPanel.isOutputSelected();
    }

    public boolean isErrorSelected() {
        return this.guiPanel.isErrorSelected();
    }

    public boolean isStartupInitializationSelected() {
        return this.guiPanel.isInitializationSelected();
    }

    public String getStartupInitializationFilename() {
        return this.guiPanel.getFilename();
    }

    public OptionSet getOptions() {
        return new OptionSet(this);
    }

    public void setOptions(OptionSet optionSet) {
        this.classPathList.setStrings(optionSet.classPath);
        this.libraryPathList.setStrings(optionSet.libraryPath);
        this.interpreterPanel.setExportationSelected(optionSet.isInterpreterSelected);
        this.interpreterPanel.setName(optionSet.interpreterName);
        this.interpreterPanel.setInitializationSelected(optionSet.interpreterFileSelected);
        this.interpreterPanel.setFilename(optionSet.interpreterFilename);
        this.guiPanel.setSelected(optionSet.isGUISelected);
        this.guiPanel.setName(optionSet.guiName);
        this.guiPanel.setOutputSelected(optionSet.isOutputSelected);
        this.guiPanel.setErrorSelected(optionSet.isErrorSelected);
        this.guiPanel.setInitializationSelected(optionSet.guiFileSelected);
        this.guiPanel.setFilename(optionSet.guiFilename);
    }

    protected JTabbedPane createTabbedPane() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(rManager.getString("General.title"), this.createGeneralPanel());
        jTabbedPane.addTab(rManager.getString("PathPanel.title"), this.createPathPanel());
        return jTabbedPane;
    }

    protected JPanel createGeneralPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel.add("North", jPanel2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        OptionsDialog.setConstraintsCoords(gridBagConstraints, 0, 0, 1, 1);
        this.interpreterPanel = new InterpreterPanel();
        jPanel2.add((Component)this.interpreterPanel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        OptionsDialog.setConstraintsCoords(gridBagConstraints, 0, 1, 1, 1);
        this.guiPanel = new GUIPanel();
        jPanel2.add((Component)this.guiPanel, gridBagConstraints);
        return jPanel;
    }

    protected JPanel createPathPanel() {
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        jPanel.add(this.createClassPathPanel());
        jPanel.add(this.createLibraryPathPanel());
        return jPanel;
    }

    protected JPanel createClassPathPanel() {
        this.classPathList = new StringList(new CPLAddButtonAction());
        this.classPathList.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), rManager.getString("ClassPathPanel.title")));
        return this.classPathList;
    }

    protected JPanel createLibraryPathPanel() {
        this.libraryPathList = new StringList(new LPLAddButtonAction());
        this.libraryPathList.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), rManager.getString("LibraryPathPanel.title")));
        return this.libraryPathList;
    }

    protected JPanel createButtonsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        ButtonFactory buttonFactory = new ButtonFactory(bundle, this);
        jPanel.add(buttonFactory.createJButton("OKButton"));
        jPanel.add(buttonFactory.createJButton("CancelButton"));
        return jPanel;
    }

    protected static void setConstraintsCoords(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
    }

    protected class UCOKButtonAction
    extends AbstractAction {
        protected UCOKButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OptionsDialog.this.classPathList.add(OptionsDialog.this.urlChooser.getText());
        }
    }

    protected class CancelButtonAction
    extends AbstractAction {
        protected CancelButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OptionsDialog.this.mainFrame.restoreOptions();
            OptionsDialog.this.dispose();
        }
    }

    protected class OKButtonAction
    extends AbstractAction {
        protected OKButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (OptionsDialog.this.isInterpreterDefined() && OptionsDialog.this.getInterpreterName().equals("")) {
                JOptionPane.showMessageDialog(OptionsDialog.this, rManager.getString("InterpreterError.text"), rManager.getString("InterpreterError.title"), 0);
                return;
            }
            if (OptionsDialog.this.isInitializationSelected() && OptionsDialog.this.getInitializationFilename().equals("")) {
                JOptionPane.showMessageDialog(OptionsDialog.this, rManager.getString("InterpreterFilenameError.text"), rManager.getString("InterpreterFilenameError.title"), 0);
                return;
            }
            if (OptionsDialog.this.isGUIDefined() && OptionsDialog.this.getGUIName().equals("")) {
                JOptionPane.showMessageDialog(OptionsDialog.this, rManager.getString("GUIError.text"), rManager.getString("GUIError.title"), 0);
                return;
            }
            OptionsDialog.this.dispose();
            int n = JOptionPane.showConfirmDialog(OptionsDialog.this.mainFrame, rManager.getString("ConfirmDialog.text"), rManager.getString("ConfirmDialog.title"), 0, 1);
            if (n == 0) {
                OptionsDialog.this.mainFrame.reinitializeInterpreter();
                OptionsDialog.this.mainFrame.applyOptions();
            }
            try {
                OptionsDialog.this.mainFrame.saveOptions();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(OptionsDialog.this.mainFrame, rManager.getString("SaveOptionsError.text") + iOException.getMessage(), rManager.getString("SaveOptionsError.title"), 0);
            }
        }
    }

    protected class LPLAddButtonAction
    extends AbstractAction {
        protected LPLAddButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileHidingEnabled(false);
            jFileChooser.setFileSelectionMode(1);
            int n = jFileChooser.showOpenDialog(OptionsDialog.this);
            if (n == 0) {
                File file2 = jFileChooser.getSelectedFile();
                try {
                    OptionsDialog.this.libraryPathList.add(file2.getCanonicalPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    protected class CPLAddButtonAction
    extends AbstractAction {
        protected CPLAddButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OptionsDialog.this.urlChooser.pack();
            Rectangle rectangle = OptionsDialog.this.getBounds();
            Dimension dimension = OptionsDialog.this.urlChooser.getSize();
            ((Component)OptionsDialog.this.urlChooser).setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
            OptionsDialog.this.urlChooser.show();
        }
    }

    protected class GUIPanel
    extends JPanel {
        protected JTextField textField;
        protected JCheckBox checkBox;
        protected JLabel label;
        protected JCheckBox outputCheckBox;
        protected JCheckBox errorCheckBox;
        protected JCheckBox fileCheckBox;
        protected JLabel fileLabel;
        protected JTextField fileTextField;
        protected JButton browseButton;

        public GUIPanel() {
            super(new GridBagLayout());
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), rManager.getString("GUIPanel.title")));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.checkBox = new JCheckBox(rManager.getString("GUICheckBox.text"));
            this.checkBox.addChangeListener(new CheckBoxChangeListener());
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            OptionsDialog.setConstraintsCoords(gridBagConstraints, 0, 0, 3, 1);
            this.add((Component)this.checkBox, gridBagConstraints);
            this.label = new JLabel(rManager.getString("GUILabel.text"));
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            OptionsDialog.setConstraintsCoords(gridBagConstraints, 0, 1, 1, 1);
            this.add((Component)this.label, gridBagConstraints);
            this.textField = new JTextField();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            OptionsDialog.setConstraintsCoords(gridBagConstraints, 1, 1, 2, 1);
            this.add((Component)this.textField, gridBagConstraints);
            this.label.setEnabled(false);
            this.textField.setEnabled(false);
            this.fileCheckBox = new JCheckBox(rManager.getString("GUIInitFileCheckBox.text"));
            this.fileCheckBox.addChangeListener(new FileCheckBoxChangeListener());
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            OptionsDialog.setConstraintsCoords(gridBagConstraints, 0, 2, 3, 1);
            this.add((Component)this.fileCheckBox, gridBagConstraints);
            this.fileLabel = new JLabel(rManager.getString("GUIInitFileLabel.text"));
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            OptionsDialog.setConstraintsCoords(gridBagConstraints, 0, 3, 3, 1);
            this.add((Component)this.fileLabel, gridBagConstraints);
            this.fileTextField = new JTextField();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            OptionsDialog.setConstraintsCoords(gridBagConstraints, 0, 4, 2, 1);
            this.add((Component)this.fileTextField, gridBagConstraints);
            ButtonFactory buttonFactory = new ButtonFactory(bundle, OptionsDialog.this);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            OptionsDialog.setConstraintsCoords(gridBagConstraints, 2, 4, 1, 1);
            this.browseButton = buttonFactory.createJButton("GUIInitFileBrowseButton");
            this.add((Component)this.browseButton, gridBagConstraints);
            this.browseButton.addActionListener(new InitFileBrowseButtonAction());
            this.fileLabel.setEnabled(false);
            this.fileTextField.setEnabled(false);
            this.browseButton.setEnabled(false);
            this.outputCheckBox = new JCheckBox(rManager.getString("GUIOutputCheckBox.text"));
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            OptionsDialog.setConstraintsCoords(gridBagConstraints, 0, 5, 3, 1);
            this.add((Component)this.outputCheckBox, gridBagConstraints);
            this.errorCheckBox = new JCheckBox(rManager.getString("GUIErrorCheckBox.text"));
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            OptionsDialog.setConstraintsCoords(gridBagConstraints, 0, 6, 3, 1);
            this.add((Component)this.errorCheckBox, gridBagConstraints);
        }

        public boolean isSelected() {
            return this.checkBox.isSelected();
        }

        public void setSelected(boolean bl) {
            this.checkBox.setSelected(bl);
        }

        public String getName() {
            return this.textField.getText();
        }

        public void setName(String string) {
            this.textField.setText(string);
        }

        public boolean isOutputSelected() {
            return this.outputCheckBox.isSelected();
        }

        public void setOutputSelected(boolean bl) {
            this.outputCheckBox.setSelected(bl);
        }

        public boolean isErrorSelected() {
            return this.errorCheckBox.isSelected();
        }

        public void setErrorSelected(boolean bl) {
            this.errorCheckBox.setSelected(bl);
        }

        public boolean isInitializationSelected() {
            return this.fileCheckBox.isSelected();
        }

        public void setInitializationSelected(boolean bl) {
            this.fileCheckBox.setSelected(bl);
        }

        public String getFilename() {
            return this.fileTextField.getText();
        }

        public void setFilename(String string) {
            this.fileTextField.setText(string);
        }

        protected class InitFileBrowseButtonAction
        extends AbstractAction {
            protected InitFileBrowseButtonAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileHidingEnabled(false);
                int n = jFileChooser.showOpenDialog(OptionsDialog.this);
                if (n == 0) {
                    File file2 = jFileChooser.getSelectedFile();
                    try {
                        GUIPanel.this.fileTextField.setText(file2.getCanonicalPath());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        protected class FileCheckBoxChangeListener
        implements ChangeListener {
            protected FileCheckBoxChangeListener() {
            }

            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = GUIPanel.this.fileCheckBox.isSelected();
                GUIPanel.this.fileLabel.setEnabled(bl);
                GUIPanel.this.fileTextField.setEnabled(bl);
                GUIPanel.this.browseButton.setEnabled(bl);
            }
        }

        protected class CheckBoxChangeListener
        implements ChangeListener {
            protected CheckBoxChangeListener() {
            }

            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = GUIPanel.this.checkBox.isSelected();
                GUIPanel.this.label.setEnabled(bl);
                GUIPanel.this.textField.setEnabled(bl);
            }
        }
    }

    protected class InterpreterPanel
    extends JPanel {
        protected JTextField textField;
        protected JCheckBox checkBox;
        protected JLabel label;
        protected JCheckBox fileCheckBox;
        protected JLabel fileLabel;
        protected JTextField fileTextField;
        protected JButton browseButton;

        public InterpreterPanel() {
            super(new GridBagLayout());
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), rManager.getString("InterpreterPanel.title")));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.checkBox = new JCheckBox(rManager.getString("InterpreterCheckBox.text"));
            this.checkBox.addChangeListener(new CheckBoxChangeListener());
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            OptionsDialog.setConstraintsCoords(gridBagConstraints, 0, 0, 3, 1);
            this.add((Component)this.checkBox, gridBagConstraints);
            this.label = new JLabel(rManager.getString("InterpreterLabel.text"));
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            OptionsDialog.setConstraintsCoords(gridBagConstraints, 0, 1, 1, 1);
            this.add((Component)this.label, gridBagConstraints);
            this.textField = new JTextField();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            OptionsDialog.setConstraintsCoords(gridBagConstraints, 1, 1, 2, 1);
            this.add((Component)this.textField, gridBagConstraints);
            this.label.setEnabled(false);
            this.textField.setEnabled(false);
            this.fileCheckBox = new JCheckBox(rManager.getString("InitFileCheckBox.text"));
            this.fileCheckBox.addChangeListener(new FileCheckBoxChangeListener());
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            OptionsDialog.setConstraintsCoords(gridBagConstraints, 0, 2, 3, 1);
            this.add((Component)this.fileCheckBox, gridBagConstraints);
            this.fileLabel = new JLabel(rManager.getString("InitFileLabel.text"));
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            OptionsDialog.setConstraintsCoords(gridBagConstraints, 0, 3, 3, 1);
            this.add((Component)this.fileLabel, gridBagConstraints);
            this.fileTextField = new JTextField();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            OptionsDialog.setConstraintsCoords(gridBagConstraints, 0, 4, 2, 1);
            this.add((Component)this.fileTextField, gridBagConstraints);
            ButtonFactory buttonFactory = new ButtonFactory(bundle, OptionsDialog.this);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            OptionsDialog.setConstraintsCoords(gridBagConstraints, 2, 4, 1, 1);
            this.browseButton = buttonFactory.createJButton("InitFileBrowseButton");
            this.add((Component)this.browseButton, gridBagConstraints);
            this.browseButton.addActionListener(new InitFileBrowseButtonAction());
            this.fileLabel.setEnabled(false);
            this.fileTextField.setEnabled(false);
            this.browseButton.setEnabled(false);
        }

        public boolean isExportationSelected() {
            return this.checkBox.isSelected();
        }

        public void setExportationSelected(boolean bl) {
            this.checkBox.setSelected(bl);
        }

        public String getName() {
            return this.textField.getText();
        }

        public void setName(String string) {
            this.textField.setText(string);
        }

        public boolean isInitializationSelected() {
            return this.fileCheckBox.isSelected();
        }

        public void setInitializationSelected(boolean bl) {
            this.fileCheckBox.setSelected(bl);
        }

        public String getFilename() {
            return this.fileTextField.getText();
        }

        public void setFilename(String string) {
            this.fileTextField.setText(string);
        }

        protected class InitFileBrowseButtonAction
        extends AbstractAction {
            protected InitFileBrowseButtonAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileHidingEnabled(false);
                int n = jFileChooser.showOpenDialog(OptionsDialog.this);
                if (n == 0) {
                    File file2 = jFileChooser.getSelectedFile();
                    try {
                        InterpreterPanel.this.fileTextField.setText(file2.getCanonicalPath());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        protected class FileCheckBoxChangeListener
        implements ChangeListener {
            protected FileCheckBoxChangeListener() {
            }

            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = InterpreterPanel.this.fileCheckBox.isSelected();
                InterpreterPanel.this.fileLabel.setEnabled(bl);
                InterpreterPanel.this.fileTextField.setEnabled(bl);
                InterpreterPanel.this.browseButton.setEnabled(bl);
            }
        }

        protected class CheckBoxChangeListener
        implements ChangeListener {
            protected CheckBoxChangeListener() {
            }

            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = InterpreterPanel.this.checkBox.isSelected();
                InterpreterPanel.this.label.setEnabled(bl);
                InterpreterPanel.this.textField.setEnabled(bl);
            }
        }
    }

    public static class OptionSet {
        public String[] classPath;
        public String[] libraryPath;
        public boolean isInterpreterSelected;
        public String interpreterName;
        public boolean interpreterFileSelected;
        public String interpreterFilename;
        public boolean isGUISelected;
        public String guiName;
        public boolean isOutputSelected;
        public boolean isErrorSelected;
        public boolean guiFileSelected;
        public String guiFilename;

        public OptionSet() {
            this.classPath = new String[0];
            this.libraryPath = new String[0];
            this.isInterpreterSelected = false;
            this.interpreterName = "";
            this.interpreterFileSelected = false;
            this.interpreterFilename = "";
            this.isGUISelected = false;
            this.guiName = "";
            this.isOutputSelected = false;
            this.isErrorSelected = false;
            this.guiFileSelected = false;
            this.guiFilename = "";
        }

        public OptionSet(OptionsDialog optionsDialog) {
            this.classPath = optionsDialog.classPathList.getStrings();
            this.libraryPath = optionsDialog.libraryPathList.getStrings();
            this.isInterpreterSelected = optionsDialog.interpreterPanel.isExportationSelected();
            this.interpreterName = optionsDialog.interpreterPanel.getName();
            this.interpreterFileSelected = optionsDialog.interpreterPanel.isInitializationSelected();
            this.interpreterFilename = optionsDialog.interpreterPanel.getFilename();
            this.isGUISelected = optionsDialog.guiPanel.isSelected();
            this.guiName = optionsDialog.guiPanel.getName();
            this.isOutputSelected = optionsDialog.guiPanel.isOutputSelected();
            this.isErrorSelected = optionsDialog.guiPanel.isErrorSelected();
            this.guiFileSelected = optionsDialog.guiPanel.isInitializationSelected();
            this.guiFilename = optionsDialog.guiPanel.getFilename();
        }
    }
}

