/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import koala.dynamicjava.gui.MessageHandler;
import koala.dynamicjava.gui.resource.ResourceManager;

public class StatusBar
extends JPanel
implements MessageHandler {
    protected JLabel line;
    protected JLabel message;
    protected ResourceManager resources;
    protected String mainMessage;
    protected String lineSymbol;

    public StatusBar(ResourceManager resourceManager) {
        super(new BorderLayout(0, 0));
        this.resources = resourceManager;
        this.lineSymbol = resourceManager.getString("Status.lineSymbol");
        this.line = new JLabel(this.lineSymbol + 1);
        this.line.setBorder(BorderFactory.createBevelBorder(1));
        this.line.setPreferredSize(new Dimension(70, 18));
        this.add("West", this.line);
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        this.message = new JLabel();
        this.message.setBorder(BorderFactory.createBevelBorder(1));
        jPanel.add(this.message);
        this.add(jPanel);
    }

    public void setLine(int n) {
        this.line.setText(this.lineSymbol + n);
    }

    public void setMessage(String string) {
        this.message.setText(this.resources.getString(string));
        new DisplayThread().start();
    }

    public void setMessage(String string, String string2) {
        this.message.setText(this.resources.getString(string) + " " + string2);
        new DisplayThread().start();
    }

    public void setMainMessage(String string) {
        this.mainMessage = this.resources.getString(string);
        this.message.setText(this.mainMessage);
    }

    public void setMainMessage(String string, String string2) {
        this.mainMessage = this.resources.getString(string) + " " + string2;
        this.message.setText(this.mainMessage);
    }

    protected class DisplayThread
    extends Thread {
        public DisplayThread() {
            this.setPriority(1);
        }

        public void run() {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            StatusBar.this.message.setText(StatusBar.this.mainMessage);
        }
    }
}

