/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import koala.dynamicjava.classfile.ClassFile;
import koala.dynamicjava.classfile.ClassIdentifier;
import koala.dynamicjava.classfile.CodeAttribute;
import koala.dynamicjava.classfile.ConstantPool;
import koala.dynamicjava.classfile.ConstantString;
import koala.dynamicjava.classfile.ExceptionsAttribute;
import koala.dynamicjava.classfile.FieldInfo;
import koala.dynamicjava.classfile.InnerClassesAttribute;
import koala.dynamicjava.classfile.InnerClassesEntry;
import koala.dynamicjava.classfile.JVMUtilities;
import koala.dynamicjava.classfile.MethodIdentifier;
import koala.dynamicjava.classfile.MethodInfo;

public class ClassFactory
extends ClassFile {
    private static final String VOID_NAME = JVMUtilities.getName("void");
    private static final String BOOLEAN_NAME = JVMUtilities.getName("boolean");
    private static final String CHAR_NAME = JVMUtilities.getName("char");
    private static final String INT_NAME = JVMUtilities.getName("int");
    private static final String LONG_NAME = JVMUtilities.getName("long");
    private static final String FLOAT_NAME = JVMUtilities.getName("float");
    private static final String DOUBLE_NAME = JVMUtilities.getName("double");
    private static final String BYTE_NAME = JVMUtilities.getName("byte");
    private static final String SHORT_NAME = JVMUtilities.getName("short");
    private static final String OBJECT_NAME = JVMUtilities.getName("java.lang.Object");
    private static final String BOOLEAN_WRAPPER_NAME = JVMUtilities.getName("java.lang.Boolean");
    private static final String CHAR_WRAPPER_NAME = JVMUtilities.getName("java.lang.Character");
    private static final String INT_WRAPPER_NAME = JVMUtilities.getName("java.lang.Integer");
    private static final String LONG_WRAPPER_NAME = JVMUtilities.getName("java.lang.Long");
    private static final String FLOAT_WRAPPER_NAME = JVMUtilities.getName("java.lang.Float");
    private static final String DOUBLE_WRAPPER_NAME = JVMUtilities.getName("java.lang.Double");
    private static final String BYTE_WRAPPER_NAME = JVMUtilities.getName("java.lang.Byte");
    private static final String SHORT_WRAPPER_NAME = JVMUtilities.getName("java.lang.Short");
    private static final String NUMBER_NAME = JVMUtilities.getName("java.lang.Number");
    private static final ClassIdentifier BOOLEAN_IDENTIFIER = new ClassIdentifier(BOOLEAN_WRAPPER_NAME);
    private static final MethodIdentifier BOOLEAN_CONSTRUCTOR = new MethodIdentifier(BOOLEAN_WRAPPER_NAME, "<init>", VOID_NAME, new String[]{BOOLEAN_NAME});
    private static final ClassIdentifier CHARACTER_IDENTIFIER = new ClassIdentifier(CHAR_WRAPPER_NAME);
    private static final MethodIdentifier CHARACTER_CONSTRUCTOR = new MethodIdentifier(CHAR_WRAPPER_NAME, "<init>", VOID_NAME, new String[]{CHAR_NAME});
    private static final ClassIdentifier INTEGER_IDENTIFIER = new ClassIdentifier(INT_WRAPPER_NAME);
    private static final MethodIdentifier INTEGER_CONSTRUCTOR = new MethodIdentifier(INT_WRAPPER_NAME, "<init>", VOID_NAME, new String[]{INT_NAME});
    private static final ClassIdentifier LONG_IDENTIFIER = new ClassIdentifier(LONG_WRAPPER_NAME);
    private static final MethodIdentifier LONG_CONSTRUCTOR = new MethodIdentifier(LONG_WRAPPER_NAME, "<init>", VOID_NAME, new String[]{LONG_NAME});
    private static final ClassIdentifier FLOAT_IDENTIFIER = new ClassIdentifier(FLOAT_WRAPPER_NAME);
    private static final MethodIdentifier FLOAT_CONSTRUCTOR = new MethodIdentifier(FLOAT_WRAPPER_NAME, "<init>", VOID_NAME, new String[]{FLOAT_NAME});
    private static final ClassIdentifier DOUBLE_IDENTIFIER = new ClassIdentifier(DOUBLE_WRAPPER_NAME);
    private static final MethodIdentifier DOUBLE_CONSTRUCTOR = new MethodIdentifier(DOUBLE_WRAPPER_NAME, "<init>", VOID_NAME, new String[]{DOUBLE_NAME});
    private static final ClassIdentifier BYTE_IDENTIFIER = new ClassIdentifier(BYTE_WRAPPER_NAME);
    private static final MethodIdentifier BYTE_CONSTRUCTOR = new MethodIdentifier(BYTE_WRAPPER_NAME, "<init>", VOID_NAME, new String[]{BYTE_NAME});
    private static final ClassIdentifier SHORT_IDENTIFIER = new ClassIdentifier(SHORT_WRAPPER_NAME);
    private static final MethodIdentifier SHORT_CONSTRUCTOR = new MethodIdentifier(SHORT_WRAPPER_NAME, "<init>", VOID_NAME, new String[]{SHORT_NAME});
    private static final ClassIdentifier OBJECT_IDENTIFIER = new ClassIdentifier(OBJECT_NAME);
    private static final ClassIdentifier NUMBER_IDENTIFIER = new ClassIdentifier(NUMBER_NAME);
    private static final MethodIdentifier BOOLEAN_BOOLEAN_VALUE_METHOD = new MethodIdentifier(BOOLEAN_WRAPPER_NAME, "booleanValue", BOOLEAN_NAME, new String[0]);
    private static final MethodIdentifier CHARACTER_CHAR_VALUE_METHOD = new MethodIdentifier(CHAR_WRAPPER_NAME, "charValue", CHAR_NAME, new String[0]);
    private static final MethodIdentifier NUMBER_INT_VALUE_METHOD = new MethodIdentifier(NUMBER_NAME, "intValue", INT_NAME, new String[0]);
    private static final MethodIdentifier NUMBER_LONG_VALUE_METHOD = new MethodIdentifier(NUMBER_NAME, "longValue", LONG_NAME, new String[0]);
    private static final MethodIdentifier NUMBER_FLOAT_VALUE_METHOD = new MethodIdentifier(NUMBER_NAME, "floatValue", FLOAT_NAME, new String[0]);
    private static final MethodIdentifier NUMBER_DOUBLE_VALUE_METHOD = new MethodIdentifier(NUMBER_NAME, "doubleValue", DOUBLE_NAME, new String[0]);
    private static final MethodIdentifier NUMBER_BYTE_VALUE_METHOD = new MethodIdentifier(NUMBER_NAME, "byteValue", BYTE_NAME, new String[0]);
    private static final MethodIdentifier NUMBER_SHORT_VALUE_METHOD = new MethodIdentifier(NUMBER_NAME, "shortValue", SHORT_NAME, new String[0]);
    private String name;
    private String superName;
    private boolean isStaticClass;
    private MethodIdentifier interpreterMethod;
    private MethodIdentifier interpretArgumentsMethod;
    private MethodIdentifier thrownExceptionMethod;
    private String thrownExceptionName;
    private InnerClassesAttribute innerClassesAttribute;
    private String classLoaderId;

    public ClassFactory(int n, String string, String string2, Class clazz, Class clazz2, String string3) {
        super(string, string2);
        this.name = string;
        this.superName = string2;
        this.classLoaderId = string3;
        this.isStaticClass = (n & 8) != 0;
        int n2 = n & 0xFFFFFFFD & 0xFFFFFFFB & 0xFFFFFFF7;
        this.setAccessFlags(n2 | 0x20 | (this.isStaticClass ? 1 : 0));
        String string4 = clazz.getName();
        this.interpreterMethod = new MethodIdentifier(JVMUtilities.getName(string4), "invokeMethod", JVMUtilities.getReturnTypeName("java.lang.Object"), new String[]{JVMUtilities.getParameterTypeName("java.lang.String"), JVMUtilities.getParameterTypeName("java.lang.Object"), JVMUtilities.getParameterTypeName("java.lang.Object[]")});
        this.interpretArgumentsMethod = new MethodIdentifier(JVMUtilities.getName(string4), "interpretArguments", JVMUtilities.getReturnTypeName("java.lang.Object[]"), new String[]{JVMUtilities.getParameterTypeName("java.lang.String"), JVMUtilities.getParameterTypeName("java.lang.Object[]")});
        this.thrownExceptionName = clazz2.getName();
        this.thrownExceptionMethod = new MethodIdentifier(JVMUtilities.getName(this.thrownExceptionName), "getException", JVMUtilities.getReturnTypeName("java.lang.Exception"), new String[0]);
    }

    public static String getMethodIdentifier(String string, String string2, String[] stringArray, String string3) {
        String string4 = string + "#" + string2 + "(";
        if (stringArray.length > 0) {
            string4 = string4 + stringArray[0];
        }
        int n = 1;
        while (n < stringArray.length) {
            string4 = string4 + "," + stringArray[n];
            ++n;
        }
        return string4 + ")" + string3;
    }

    public String createClassInitializer() {
        try {
            MethodInfo methodInfo = this.createMethod("void", "<clinit>", new String[0]);
            String string = ClassFactory.getMethodIdentifier(this.name, "<clinit>", new String[0], this.classLoaderId);
            methodInfo.setAccessFlags(8);
            ConstantPool constantPool = this.getConstantPool();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            this.bipush(0, dataOutputStream);
            dataOutputStream.writeByte(189);
            short s = constantPool.put(OBJECT_IDENTIFIER);
            dataOutputStream.writeShort(s);
            this.astore(0, dataOutputStream);
            s = constantPool.put(new ConstantString(string));
            if (s > 256) {
                dataOutputStream.writeByte(19);
                dataOutputStream.writeShort(s);
            } else {
                dataOutputStream.writeByte(18);
                dataOutputStream.writeByte(s);
            }
            dataOutputStream.writeByte(1);
            this.aload(0, dataOutputStream);
            dataOutputStream.writeByte(184);
            dataOutputStream.writeShort(constantPool.put(this.interpreterMethod));
            dataOutputStream.writeByte(177);
            CodeAttribute codeAttribute = methodInfo.createCodeAttribute();
            codeAttribute.setCode(byteArrayOutputStream.toByteArray(), (short)1, (short)6);
            return string;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public String addConstructor(int n, String[] stringArray, String[] stringArray2, String string, String[] stringArray3) {
        try {
            String string2 = ClassFactory.getMethodIdentifier(this.name, "<init>", stringArray, this.classLoaderId);
            MethodInfo methodInfo = this.createMethod("void", "<init>", stringArray);
            methodInfo.setAccessFlags(n);
            ConstantPool constantPool = this.getConstantPool();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            short s = 6;
            short s2 = 3;
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string3 = stringArray[n2];
                s2 = string3.equals("long") || string3.equals("double") ? (short)((short)(s2 + 2)) : (short)((short)(s2 + 1));
                ++n2;
            }
            short s3 = s2;
            int n3 = 0;
            while (n3 < stringArray3.length) {
                String string4 = stringArray3[n3];
                if (string4.equals("long") || string4.equals("double")) {
                    s2 = (short)(s2 + 2);
                    s = (short)(s + 2);
                } else {
                    s2 = (short)(s2 + 1);
                    s = (short)(s + 1);
                }
                ++n3;
            }
            this.bipush(stringArray.length, dataOutputStream);
            dataOutputStream.writeByte(189);
            short s4 = constantPool.put(OBJECT_IDENTIFIER);
            dataOutputStream.writeShort(s4);
            if (s3 < 5) {
                dataOutputStream.writeByte(75 + s3 - 1);
            } else {
                dataOutputStream.writeByte(58);
                dataOutputStream.writeByte(s3 - 1);
            }
            short s5 = 1;
            int n4 = 0;
            while (n4 < stringArray.length) {
                String string5 = stringArray[n4];
                this.aload(s3 - 1, dataOutputStream);
                this.bipush(n4, dataOutputStream);
                if (string5.equals("int")) {
                    this.loadInt(s5, dataOutputStream, constantPool);
                } else if (string5.equals("long")) {
                    this.loadLong(s5, dataOutputStream, constantPool);
                    ++s5;
                } else if (string5.equals("float")) {
                    this.loadFloat(s5, dataOutputStream, constantPool);
                } else if (string5.equals("double")) {
                    this.loadDouble(s5, dataOutputStream, constantPool);
                    ++s5;
                } else if (string5.equals("byte")) {
                    this.loadByte(s5, dataOutputStream, constantPool);
                } else if (string5.equals("short")) {
                    this.loadShort(s5, dataOutputStream, constantPool);
                } else if (string5.equals("boolean")) {
                    this.loadBoolean(s5, dataOutputStream, constantPool);
                } else if (string5.equals("char")) {
                    this.loadChar(s5, dataOutputStream, constantPool);
                } else {
                    this.aload(s5, dataOutputStream);
                }
                dataOutputStream.writeByte(83);
                ++s5;
                ++n4;
            }
            short s6 = (short)dataOutputStream.size();
            s4 = constantPool.put(new ConstantString(string2));
            if (s4 > 256) {
                dataOutputStream.writeByte(19);
                dataOutputStream.writeShort(s4);
            } else {
                dataOutputStream.writeByte(18);
                dataOutputStream.writeByte(s4);
            }
            this.aload(s3 - 1, dataOutputStream);
            dataOutputStream.writeByte(184);
            dataOutputStream.writeShort(constantPool.put(this.interpretArgumentsMethod));
            this.astore(s3 - 2, dataOutputStream);
            s5 = s3;
            int n5 = 0;
            while (n5 < stringArray3.length) {
                String string6 = stringArray3[n5];
                this.aload(s3 - 2, dataOutputStream);
                this.bipush(n5, dataOutputStream);
                dataOutputStream.writeByte(50);
                if (string6.equals("int")) {
                    dataOutputStream.writeByte(192);
                    dataOutputStream.writeShort(constantPool.put(NUMBER_IDENTIFIER));
                    dataOutputStream.writeByte(182);
                    dataOutputStream.writeShort(constantPool.put(NUMBER_INT_VALUE_METHOD));
                    if (s5 < 4) {
                        dataOutputStream.writeByte(59 + s5);
                    } else {
                        dataOutputStream.writeByte(54);
                        dataOutputStream.writeByte(s5);
                    }
                } else if (string6.equals("long")) {
                    dataOutputStream.writeByte(192);
                    dataOutputStream.writeShort(constantPool.put(NUMBER_IDENTIFIER));
                    dataOutputStream.writeByte(182);
                    dataOutputStream.writeShort(constantPool.put(NUMBER_LONG_VALUE_METHOD));
                    if (s5 < 4) {
                        dataOutputStream.writeByte(63 + s5);
                    } else {
                        dataOutputStream.writeByte(55);
                        dataOutputStream.writeByte(s5);
                    }
                    ++s5;
                } else if (string6.equals("float")) {
                    dataOutputStream.writeByte(192);
                    dataOutputStream.writeShort(constantPool.put(NUMBER_IDENTIFIER));
                    dataOutputStream.writeByte(182);
                    dataOutputStream.writeShort(constantPool.put(NUMBER_FLOAT_VALUE_METHOD));
                    if (s5 < 4) {
                        dataOutputStream.writeByte(67 + s5);
                    } else {
                        dataOutputStream.writeByte(56);
                        dataOutputStream.writeByte(s5);
                    }
                } else if (string6.equals("double")) {
                    dataOutputStream.writeByte(192);
                    dataOutputStream.writeShort(constantPool.put(NUMBER_IDENTIFIER));
                    dataOutputStream.writeByte(182);
                    dataOutputStream.writeShort(constantPool.put(NUMBER_DOUBLE_VALUE_METHOD));
                    if (s5 < 4) {
                        dataOutputStream.writeByte(71 + s5);
                    } else {
                        dataOutputStream.writeByte(57);
                        dataOutputStream.writeByte(s5);
                    }
                    ++s5;
                } else if (string6.equals("byte")) {
                    dataOutputStream.writeByte(192);
                    dataOutputStream.writeShort(constantPool.put(NUMBER_IDENTIFIER));
                    dataOutputStream.writeByte(182);
                    dataOutputStream.writeShort(constantPool.put(NUMBER_BYTE_VALUE_METHOD));
                    if (s5 < 4) {
                        dataOutputStream.writeByte(59 + s5);
                    } else {
                        dataOutputStream.writeByte(54);
                        dataOutputStream.writeByte(s5);
                    }
                } else if (string6.equals("short")) {
                    dataOutputStream.writeByte(192);
                    dataOutputStream.writeShort(constantPool.put(NUMBER_IDENTIFIER));
                    dataOutputStream.writeByte(182);
                    dataOutputStream.writeShort(constantPool.put(NUMBER_SHORT_VALUE_METHOD));
                    if (s5 < 4) {
                        dataOutputStream.writeByte(59 + s5);
                    } else {
                        dataOutputStream.writeByte(54);
                        dataOutputStream.writeByte(s5);
                    }
                } else if (string6.equals("boolean")) {
                    dataOutputStream.writeByte(192);
                    dataOutputStream.writeShort(constantPool.put(BOOLEAN_IDENTIFIER));
                    dataOutputStream.writeByte(182);
                    dataOutputStream.writeShort(constantPool.put(BOOLEAN_BOOLEAN_VALUE_METHOD));
                    if (s5 < 4) {
                        dataOutputStream.writeByte(59 + s5);
                    } else {
                        dataOutputStream.writeByte(54);
                        dataOutputStream.writeByte(s5);
                    }
                } else if (string6.equals("char")) {
                    dataOutputStream.writeByte(192);
                    dataOutputStream.writeShort(constantPool.put(CHARACTER_IDENTIFIER));
                    dataOutputStream.writeByte(182);
                    dataOutputStream.writeShort(constantPool.put(CHARACTER_CHAR_VALUE_METHOD));
                    if (s5 < 4) {
                        dataOutputStream.writeByte(59 + s5);
                    } else {
                        dataOutputStream.writeByte(54);
                        dataOutputStream.writeByte(s5);
                    }
                } else {
                    this.astore(s5, dataOutputStream);
                }
                ++s5;
                ++n5;
            }
            dataOutputStream.writeByte(42);
            s5 = s3;
            int n6 = 0;
            while (n6 < stringArray3.length) {
                String string7 = stringArray3[n6];
                if (string7.equals("int")) {
                    this.iload(s5, dataOutputStream);
                } else if (string7.equals("long")) {
                    if (s5 < 4) {
                        dataOutputStream.writeByte(30 + s5);
                    } else {
                        dataOutputStream.writeByte(22);
                        dataOutputStream.writeByte(s5);
                    }
                    ++s5;
                } else if (string7.equals("float")) {
                    if (s5 < 4) {
                        dataOutputStream.writeByte(34 + s5);
                    } else {
                        dataOutputStream.writeByte(23);
                        dataOutputStream.writeByte(s5);
                    }
                } else if (string7.equals("double")) {
                    if (s5 < 4) {
                        dataOutputStream.writeByte(38 + s5);
                    } else {
                        dataOutputStream.writeByte(24);
                        dataOutputStream.writeByte(s5);
                    }
                    ++s5;
                } else if (string7.equals("byte")) {
                    this.iload(s5, dataOutputStream);
                } else if (string7.equals("short")) {
                    this.iload(s5, dataOutputStream);
                } else if (string7.equals("boolean")) {
                    this.iload(s5, dataOutputStream);
                } else if (string7.equals("char")) {
                    this.iload(s5, dataOutputStream);
                } else {
                    this.aload(s5, dataOutputStream);
                    dataOutputStream.writeByte(192);
                    dataOutputStream.writeShort(constantPool.put(new ClassIdentifier(JVMUtilities.getName(stringArray3[n6]))));
                }
                ++s5;
                ++n6;
            }
            dataOutputStream.writeByte(183);
            int n7 = 0;
            while (n7 < stringArray3.length) {
                stringArray3[n7] = JVMUtilities.getParameterTypeName(stringArray3[n7]);
                ++n7;
            }
            MethodIdentifier methodIdentifier = new MethodIdentifier(JVMUtilities.getName(string), "<init>", JVMUtilities.getName("void"), stringArray3);
            dataOutputStream.writeShort(constantPool.put(methodIdentifier));
            s4 = constantPool.put(new ConstantString(string2));
            if (s4 > 256) {
                dataOutputStream.writeByte(19);
                dataOutputStream.writeShort(s4);
            } else {
                dataOutputStream.writeByte(18);
                dataOutputStream.writeByte(s4);
            }
            dataOutputStream.writeByte(42);
            this.aload(s3 - 1, dataOutputStream);
            dataOutputStream.writeByte(184);
            dataOutputStream.writeShort(constantPool.put(this.interpreterMethod));
            dataOutputStream.writeByte(177);
            short s7 = (short)dataOutputStream.size();
            if (stringArray2.length > 0) {
                s2 = (short)(s2 + 2);
                this.astore(s2 - 2, dataOutputStream);
                this.aload(s2 - 2, dataOutputStream);
                dataOutputStream.writeByte(182);
                dataOutputStream.writeShort(constantPool.put(this.thrownExceptionMethod));
                this.astore(s2 - 1, dataOutputStream);
                int n8 = 0;
                while (n8 < stringArray2.length) {
                    this.aload(s2 - 1, dataOutputStream);
                    dataOutputStream.writeByte(193);
                    s4 = constantPool.put(new ClassIdentifier(JVMUtilities.getName(stringArray2[n8])));
                    dataOutputStream.writeShort(s4);
                    dataOutputStream.writeByte(153);
                    if (s2 < 5) {
                        dataOutputStream.writeShort(8);
                    } else {
                        dataOutputStream.writeShort(9);
                    }
                    this.aload(s2 - 1, dataOutputStream);
                    dataOutputStream.writeByte(192);
                    dataOutputStream.writeShort(s4);
                    dataOutputStream.writeByte(191);
                    ++n8;
                }
                this.aload(s2 - 2, dataOutputStream);
                dataOutputStream.writeByte(191);
            }
            CodeAttribute codeAttribute = methodInfo.createCodeAttribute();
            codeAttribute.setCode(byteArrayOutputStream.toByteArray(), s2, s);
            if (stringArray2.length > 0) {
                codeAttribute.addExceptionTableEntry(s6, s7, s7, this.thrownExceptionName);
            }
            if (stringArray2.length > 0) {
                ExceptionsAttribute exceptionsAttribute = methodInfo.createExceptionsAttribute();
                int n9 = 0;
                while (n9 < stringArray2.length) {
                    exceptionsAttribute.addException(stringArray2[n9]);
                    ++n9;
                }
            }
            return string2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public void addField(int n, String string, String string2) {
        FieldInfo fieldInfo = this.createField(string, string2);
        fieldInfo.setAccessFlags(n);
    }

    public void addConstantIntField(int n, String string, String string2, Integer n2) {
        FieldInfo fieldInfo = this.createField(string, string2);
        fieldInfo.setAccessFlags(n);
        fieldInfo.setConstantValueAttribute(n2);
    }

    public void addConstantLongField(int n, String string, String string2, Long l) {
        FieldInfo fieldInfo = this.createField(string, string2);
        fieldInfo.setAccessFlags(n);
        fieldInfo.setConstantValueAttribute(l);
    }

    public void addConstantFloatField(int n, String string, String string2, Float f) {
        FieldInfo fieldInfo = this.createField(string, string2);
        fieldInfo.setAccessFlags(n);
        fieldInfo.setConstantValueAttribute(f);
    }

    public void addConstantDoubleField(int n, String string, String string2, Double d) {
        FieldInfo fieldInfo = this.createField(string, string2);
        fieldInfo.setAccessFlags(n);
        fieldInfo.setConstantValueAttribute(d);
    }

    public void addConstantBooleanField(int n, String string, String string2, Boolean bl) {
        FieldInfo fieldInfo = this.createField(string, string2);
        fieldInfo.setAccessFlags(n);
        fieldInfo.setConstantValueAttribute(new Integer(bl != false ? 1 : 0));
    }

    public void addConstantStringField(int n, String string, String string2, String string3) {
        FieldInfo fieldInfo = this.createField(string, string2);
        fieldInfo.setAccessFlags(n);
        fieldInfo.setConstantValueAttribute(string3);
    }

    public InnerClassesEntry addInnerClassesEntry() {
        if (this.innerClassesAttribute == null) {
            this.innerClassesAttribute = new InnerClassesAttribute(this.getConstantPool());
            this.setInnerClassesAttribute(this.innerClassesAttribute);
        }
        return this.innerClassesAttribute.addInnerClassesEntry();
    }

    public void addSuperMethodAccessor(int n, String string, String string2, String[] stringArray, String[] stringArray2) {
        try {
            Object object;
            MethodInfo methodInfo = this.createMethod(string, "super$" + string2, stringArray);
            methodInfo.setAccessFlags(1);
            ConstantPool constantPool = this.getConstantPool();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            boolean bl = Modifier.isStatic(n);
            short s = bl ? (short)1 : 2;
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string3 = stringArray[n2];
                s = string3.equals("long") || string3.equals("double") ? (short)((short)(s + 2)) : (short)((short)(s + 1));
                ++n2;
            }
            short s2 = s;
            int n3 = 0;
            if (!bl) {
                dataOutputStream.writeByte(42);
                n3 = 1;
            }
            int n4 = 0;
            while (n4 < stringArray.length) {
                object = stringArray[n4];
                if (((String)object).equals("int")) {
                    this.iload(n3, dataOutputStream);
                } else if (((String)object).equals("long")) {
                    if (n3 < 4) {
                        dataOutputStream.writeByte(30 + n3);
                    } else {
                        dataOutputStream.writeByte(22);
                        dataOutputStream.writeByte(n3);
                    }
                    ++n3;
                } else if (((String)object).equals("float")) {
                    if (n3 < 4) {
                        dataOutputStream.writeByte(34 + n3);
                    } else {
                        dataOutputStream.writeByte(23);
                        dataOutputStream.writeByte(n3);
                    }
                } else if (((String)object).equals("double")) {
                    if (n3 < 4) {
                        dataOutputStream.writeByte(38 + n3);
                    } else {
                        dataOutputStream.writeByte(24);
                        dataOutputStream.writeByte(n3);
                    }
                    ++n3;
                } else if (((String)object).equals("byte")) {
                    this.iload(n3, dataOutputStream);
                } else if (((String)object).equals("short")) {
                    this.iload(n3, dataOutputStream);
                } else if (((String)object).equals("boolean")) {
                    this.iload(n3, dataOutputStream);
                } else if (((String)object).equals("char")) {
                    this.iload(n3, dataOutputStream);
                } else {
                    this.aload(n3, dataOutputStream);
                    dataOutputStream.writeByte(192);
                    dataOutputStream.writeShort(constantPool.put(new ClassIdentifier(JVMUtilities.getName(stringArray[n4]))));
                }
                ++n3;
                ++n4;
            }
            object = new String[stringArray.length];
            int n5 = 0;
            while (n5 < stringArray.length) {
                object[n5] = JVMUtilities.getParameterTypeName(stringArray[n5]);
                ++n5;
            }
            MethodIdentifier methodIdentifier = new MethodIdentifier(JVMUtilities.getName(this.superName), string2, JVMUtilities.getReturnTypeName(string), (String[])object);
            if (bl) {
                dataOutputStream.writeByte(184);
            } else {
                dataOutputStream.writeByte(183);
            }
            dataOutputStream.writeShort(constantPool.put(methodIdentifier));
            if (string.equals("void")) {
                dataOutputStream.writeByte(177);
            } else if (string.equals("int")) {
                dataOutputStream.writeByte(172);
            } else if (string.equals("long")) {
                dataOutputStream.writeByte(173);
            } else if (string.equals("float")) {
                dataOutputStream.writeByte(174);
            } else if (string.equals("double")) {
                dataOutputStream.writeByte(175);
            } else if (string.equals("byte")) {
                dataOutputStream.writeByte(172);
            } else if (string.equals("short")) {
                dataOutputStream.writeByte(172);
            } else if (string.equals("boolean")) {
                dataOutputStream.writeByte(172);
            } else if (string.equals("char")) {
                dataOutputStream.writeByte(172);
            } else {
                dataOutputStream.writeByte(176);
            }
            CodeAttribute codeAttribute = methodInfo.createCodeAttribute();
            codeAttribute.setCode(byteArrayOutputStream.toByteArray(), s, s2);
            if (stringArray2.length > 0) {
                ExceptionsAttribute exceptionsAttribute = methodInfo.createExceptionsAttribute();
                int n6 = 0;
                while (n6 < stringArray2.length) {
                    exceptionsAttribute.addException(stringArray2[n6]);
                    ++n6;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String addMethod(int n, String string, String string2, String[] stringArray, String[] stringArray2) {
        try {
            Object object;
            MethodInfo methodInfo = this.createMethod(string, string2, stringArray);
            String string3 = ClassFactory.getMethodIdentifier(this.name, string2, stringArray, this.classLoaderId);
            methodInfo.setAccessFlags(n);
            if (!methodInfo.isAbstract()) {
                object = this.getConstantPool();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                short s = 6;
                short s2 = methodInfo.isStatic() ? (short)1 : 2;
                int n2 = 0;
                while (n2 < stringArray.length) {
                    String string4 = stringArray[n2];
                    s2 = string4.equals("long") || string4.equals("double") ? (short)((short)(s2 + 2)) : (short)((short)(s2 + 1));
                    ++n2;
                }
                this.bipush(stringArray.length, dataOutputStream);
                dataOutputStream.writeByte(189);
                short s3 = ((ConstantPool)object).put(OBJECT_IDENTIFIER);
                dataOutputStream.writeShort(s3);
                this.astore(s2 - 1, dataOutputStream);
                int n3 = methodInfo.isStatic() ? 0 : 1;
                int n4 = 0;
                while (n4 < stringArray.length) {
                    String string5 = stringArray[n4];
                    this.aload(s2 - 1, dataOutputStream);
                    this.bipush(n4, dataOutputStream);
                    if (string5.equals("int")) {
                        this.loadInt(n3, dataOutputStream, (ConstantPool)object);
                    } else if (string5.equals("long")) {
                        this.loadLong(n3, dataOutputStream, (ConstantPool)object);
                        ++n3;
                    } else if (string5.equals("float")) {
                        this.loadFloat(n3, dataOutputStream, (ConstantPool)object);
                    } else if (string5.equals("double")) {
                        this.loadDouble(n3, dataOutputStream, (ConstantPool)object);
                        ++n3;
                    } else if (string5.equals("byte")) {
                        this.loadByte(n3, dataOutputStream, (ConstantPool)object);
                    } else if (string5.equals("short")) {
                        this.loadShort(n3, dataOutputStream, (ConstantPool)object);
                    } else if (string5.equals("boolean")) {
                        this.loadBoolean(n3, dataOutputStream, (ConstantPool)object);
                    } else if (string5.equals("char")) {
                        this.loadChar(n3, dataOutputStream, (ConstantPool)object);
                    } else {
                        this.aload(n3, dataOutputStream);
                    }
                    dataOutputStream.writeByte(83);
                    ++n3;
                    ++n4;
                }
                short s4 = (short)dataOutputStream.size();
                s3 = ((ConstantPool)object).put(new ConstantString(string3));
                if (s3 > 256) {
                    dataOutputStream.writeByte(19);
                    dataOutputStream.writeShort(s3);
                } else {
                    dataOutputStream.writeByte(18);
                    dataOutputStream.writeByte(s3);
                }
                if (methodInfo.isStatic()) {
                    dataOutputStream.writeByte(1);
                } else {
                    dataOutputStream.writeByte(42);
                }
                this.aload(s2 - 1, dataOutputStream);
                dataOutputStream.writeByte(184);
                dataOutputStream.writeShort(((ConstantPool)object).put(this.interpreterMethod));
                if (string.equals("void")) {
                    dataOutputStream.writeByte(177);
                } else if (string.equals("int")) {
                    dataOutputStream.writeByte(192);
                    dataOutputStream.writeShort(((ConstantPool)object).put(NUMBER_IDENTIFIER));
                    dataOutputStream.writeByte(182);
                    dataOutputStream.writeShort(((ConstantPool)object).put(NUMBER_INT_VALUE_METHOD));
                    dataOutputStream.writeByte(172);
                } else if (string.equals("long")) {
                    dataOutputStream.writeByte(192);
                    dataOutputStream.writeShort(((ConstantPool)object).put(NUMBER_IDENTIFIER));
                    dataOutputStream.writeByte(182);
                    dataOutputStream.writeShort(((ConstantPool)object).put(NUMBER_LONG_VALUE_METHOD));
                    dataOutputStream.writeByte(173);
                } else if (string.equals("float")) {
                    dataOutputStream.writeByte(192);
                    dataOutputStream.writeShort(((ConstantPool)object).put(NUMBER_IDENTIFIER));
                    dataOutputStream.writeByte(182);
                    dataOutputStream.writeShort(((ConstantPool)object).put(NUMBER_FLOAT_VALUE_METHOD));
                    dataOutputStream.writeByte(174);
                } else if (string.equals("double")) {
                    dataOutputStream.writeByte(192);
                    dataOutputStream.writeShort(((ConstantPool)object).put(NUMBER_IDENTIFIER));
                    dataOutputStream.writeByte(182);
                    dataOutputStream.writeShort(((ConstantPool)object).put(NUMBER_DOUBLE_VALUE_METHOD));
                    dataOutputStream.writeByte(175);
                } else if (string.equals("byte")) {
                    dataOutputStream.writeByte(192);
                    dataOutputStream.writeShort(((ConstantPool)object).put(NUMBER_IDENTIFIER));
                    dataOutputStream.writeByte(182);
                    dataOutputStream.writeShort(((ConstantPool)object).put(NUMBER_BYTE_VALUE_METHOD));
                    dataOutputStream.writeByte(172);
                } else if (string.equals("short")) {
                    dataOutputStream.writeByte(192);
                    dataOutputStream.writeShort(((ConstantPool)object).put(NUMBER_IDENTIFIER));
                    dataOutputStream.writeByte(182);
                    dataOutputStream.writeShort(((ConstantPool)object).put(NUMBER_SHORT_VALUE_METHOD));
                    dataOutputStream.writeByte(172);
                } else if (string.equals("boolean")) {
                    dataOutputStream.writeByte(192);
                    dataOutputStream.writeShort(((ConstantPool)object).put(BOOLEAN_IDENTIFIER));
                    dataOutputStream.writeByte(182);
                    dataOutputStream.writeShort(((ConstantPool)object).put(BOOLEAN_BOOLEAN_VALUE_METHOD));
                    dataOutputStream.writeByte(172);
                } else if (string.equals("char")) {
                    dataOutputStream.writeByte(192);
                    dataOutputStream.writeShort(((ConstantPool)object).put(CHARACTER_IDENTIFIER));
                    dataOutputStream.writeByte(182);
                    dataOutputStream.writeShort(((ConstantPool)object).put(CHARACTER_CHAR_VALUE_METHOD));
                    dataOutputStream.writeByte(172);
                } else {
                    dataOutputStream.writeByte(192);
                    dataOutputStream.writeShort(((ConstantPool)object).put(new ClassIdentifier(JVMUtilities.getName(string))));
                    dataOutputStream.writeByte(176);
                }
                short s5 = (short)dataOutputStream.size();
                if (stringArray2.length > 0) {
                    s2 = (short)(s2 + 2);
                    this.astore(s2 - 2, dataOutputStream);
                    this.aload(s2 - 2, dataOutputStream);
                    dataOutputStream.writeByte(182);
                    dataOutputStream.writeShort(((ConstantPool)object).put(this.thrownExceptionMethod));
                    this.astore(s2 - 1, dataOutputStream);
                    int n5 = 0;
                    while (n5 < stringArray2.length) {
                        this.aload(s2 - 1, dataOutputStream);
                        dataOutputStream.writeByte(193);
                        s3 = ((ConstantPool)object).put(new ClassIdentifier(JVMUtilities.getName(stringArray2[n5])));
                        dataOutputStream.writeShort(s3);
                        dataOutputStream.writeByte(153);
                        if (s2 < 5) {
                            dataOutputStream.writeShort(8);
                        } else {
                            dataOutputStream.writeShort(9);
                        }
                        this.aload(s2 - 1, dataOutputStream);
                        dataOutputStream.writeByte(192);
                        dataOutputStream.writeShort(s3);
                        dataOutputStream.writeByte(191);
                        ++n5;
                    }
                    this.aload(s2 - 2, dataOutputStream);
                    dataOutputStream.writeByte(191);
                }
                CodeAttribute codeAttribute = methodInfo.createCodeAttribute();
                codeAttribute.setCode(byteArrayOutputStream.toByteArray(), s2, s);
                if (stringArray2.length > 0) {
                    codeAttribute.addExceptionTableEntry(s4, s5, s5, this.thrownExceptionName);
                }
            }
            if (stringArray2.length > 0) {
                object = methodInfo.createExceptionsAttribute();
                int n6 = 0;
                while (n6 < stringArray2.length) {
                    ((ExceptionsAttribute)object).addException(stringArray2[n6]);
                    ++n6;
                }
            }
            return string3;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public byte[] getByteCode() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.write(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void iload(int n, DataOutputStream dataOutputStream) throws IOException {
        if (n < 4) {
            dataOutputStream.writeByte(26 + n);
        } else {
            dataOutputStream.writeByte(21);
            dataOutputStream.writeByte(n);
        }
    }

    private void aload(int n, DataOutputStream dataOutputStream) throws IOException {
        if (n < 4) {
            dataOutputStream.writeByte(42 + n);
        } else {
            dataOutputStream.writeByte(25);
            dataOutputStream.writeByte(n);
        }
    }

    private void astore(int n, DataOutputStream dataOutputStream) throws IOException {
        if (n < 4) {
            dataOutputStream.writeByte(75 + n);
        } else {
            dataOutputStream.writeByte(58);
            dataOutputStream.writeByte(n);
        }
    }

    private void bipush(int n, DataOutputStream dataOutputStream) throws IOException {
        if (n < 6) {
            dataOutputStream.writeByte(3 + n);
        } else {
            dataOutputStream.writeByte(16);
            dataOutputStream.writeByte(n);
        }
    }

    private void loadInt(int n, DataOutputStream dataOutputStream, ConstantPool constantPool) throws IOException {
        dataOutputStream.writeByte(187);
        dataOutputStream.writeShort(constantPool.put(INTEGER_IDENTIFIER));
        dataOutputStream.writeByte(89);
        if (n < 4) {
            dataOutputStream.writeByte(26 + n);
        } else {
            dataOutputStream.writeByte(21);
            dataOutputStream.writeByte(n);
        }
        dataOutputStream.writeByte(183);
        dataOutputStream.writeShort(constantPool.put(INTEGER_CONSTRUCTOR));
    }

    private void loadLong(int n, DataOutputStream dataOutputStream, ConstantPool constantPool) throws IOException {
        dataOutputStream.writeByte(187);
        dataOutputStream.writeShort(constantPool.put(LONG_IDENTIFIER));
        dataOutputStream.writeByte(89);
        if (n < 4) {
            dataOutputStream.writeByte(30 + n);
        } else {
            dataOutputStream.writeByte(22);
            dataOutputStream.writeByte(n);
        }
        dataOutputStream.writeByte(183);
        dataOutputStream.writeShort(constantPool.put(LONG_CONSTRUCTOR));
    }

    private void loadFloat(int n, DataOutputStream dataOutputStream, ConstantPool constantPool) throws IOException {
        dataOutputStream.writeByte(187);
        dataOutputStream.writeShort(constantPool.put(FLOAT_IDENTIFIER));
        dataOutputStream.writeByte(89);
        if (n < 4) {
            dataOutputStream.writeByte(34 + n);
        } else {
            dataOutputStream.writeByte(23);
            dataOutputStream.writeByte(n);
        }
        dataOutputStream.writeByte(183);
        dataOutputStream.writeShort(constantPool.put(FLOAT_CONSTRUCTOR));
    }

    private void loadDouble(int n, DataOutputStream dataOutputStream, ConstantPool constantPool) throws IOException {
        dataOutputStream.writeByte(187);
        dataOutputStream.writeShort(constantPool.put(DOUBLE_IDENTIFIER));
        dataOutputStream.writeByte(89);
        if (n < 4) {
            dataOutputStream.writeByte(38 + n);
        } else {
            dataOutputStream.writeByte(24);
            dataOutputStream.writeByte(n);
        }
        dataOutputStream.writeByte(183);
        dataOutputStream.writeShort(constantPool.put(DOUBLE_CONSTRUCTOR));
    }

    private void loadByte(int n, DataOutputStream dataOutputStream, ConstantPool constantPool) throws IOException {
        dataOutputStream.writeByte(187);
        dataOutputStream.writeShort(constantPool.put(BYTE_IDENTIFIER));
        dataOutputStream.writeByte(89);
        if (n < 4) {
            dataOutputStream.writeByte(26 + n);
        } else {
            dataOutputStream.writeByte(21);
            dataOutputStream.writeByte(n);
        }
        dataOutputStream.writeByte(183);
        dataOutputStream.writeShort(constantPool.put(BYTE_CONSTRUCTOR));
    }

    private void loadShort(int n, DataOutputStream dataOutputStream, ConstantPool constantPool) throws IOException {
        dataOutputStream.writeByte(187);
        dataOutputStream.writeShort(constantPool.put(SHORT_IDENTIFIER));
        dataOutputStream.writeByte(89);
        if (n < 4) {
            dataOutputStream.writeByte(26 + n);
        } else {
            dataOutputStream.writeByte(21);
            dataOutputStream.writeByte(n);
        }
        dataOutputStream.writeByte(183);
        dataOutputStream.writeShort(constantPool.put(SHORT_CONSTRUCTOR));
    }

    private void loadBoolean(int n, DataOutputStream dataOutputStream, ConstantPool constantPool) throws IOException {
        dataOutputStream.writeByte(187);
        dataOutputStream.writeShort(constantPool.put(BOOLEAN_IDENTIFIER));
        dataOutputStream.writeByte(89);
        if (n < 4) {
            dataOutputStream.writeByte(26 + n);
        } else {
            dataOutputStream.writeByte(21);
            dataOutputStream.writeByte(n);
        }
        dataOutputStream.writeByte(183);
        dataOutputStream.writeShort(constantPool.put(BOOLEAN_CONSTRUCTOR));
    }

    private void loadChar(int n, DataOutputStream dataOutputStream, ConstantPool constantPool) throws IOException {
        dataOutputStream.writeByte(187);
        dataOutputStream.writeShort(constantPool.put(CHARACTER_IDENTIFIER));
        dataOutputStream.writeByte(89);
        if (n < 4) {
            dataOutputStream.writeByte(26 + n);
        } else {
            dataOutputStream.writeByte(21);
            dataOutputStream.writeByte(n);
        }
        dataOutputStream.writeByte(183);
        dataOutputStream.writeShort(constantPool.put(CHARACTER_CONSTRUCTOR));
    }
}

