/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter.modifier;

import koala.dynamicjava.interpreter.context.Context;
import koala.dynamicjava.interpreter.error.CatchedExceptionError;
import koala.dynamicjava.interpreter.modifier.LeftHandSideModifier;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.QualifiedName;
import koala.dynamicjava.tree.visitor.Visitor;

public class VariableModifier
extends LeftHandSideModifier {
    protected QualifiedName name;
    protected Class type;
    protected String representation;

    public VariableModifier(QualifiedName qualifiedName, Class clazz) {
        this.name = qualifiedName;
        this.type = clazz;
        this.representation = qualifiedName.getRepresentation();
    }

    public Object prepare(Visitor visitor, Context context) {
        return context.get(this.representation);
    }

    public void modify(Context context, Object object) {
        if (!this.type.isPrimitive() && object != null && !this.type.isAssignableFrom(object.getClass())) {
            ClassCastException classCastException = new ClassCastException(this.representation);
            throw new CatchedExceptionError(classCastException, (Node)this.name);
        }
        context.set(this.representation, object);
    }
}

