/*
 * Decompiled with CFR 0.152.
 */
package layedit.swing;

import de.netcomputing.anyj.application.JDialog;
import de.netcomputing.anyj.jwidgets.Binder;
import de.netcomputing.anyj.jwidgets.ISelectionProvider;
import de.netcomputing.runtime.SwingFactory;
import editapp.EditApp;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import layedit.Copyable;
import layedit.IGUIPersistence;
import layedit.ILayoutDoc;
import layedit.LayoutController;
import layedit.LayoutableComponent;
import layedit.LayoutableContainer;
import layedit.swing.AddDelAction;
import layedit.swing.BopComponent;
import layedit.swing.BopContainer;
import layedit.swing.BopSwingRoot;
import layedit.swing.IModellingRoot;
import layedit.swing.SwingPersistance;
import netcomputing.undo.UndoTracker;

public class SwingEditFrame
extends JDialog
implements ILayoutDoc,
FocusListener,
ISelectionProvider,
IModellingRoot {
    protected BopSwingRoot root;
    protected UndoTracker undoTracker;
    static /* synthetic */ Class class$javax$swing$border$Border;

    public SwingEditFrame(String title) {
        super(EditApp.App.getMainWindow());
        this.setTitle(title);
        this.undoTracker = new UndoTracker();
        this.setLayout(new BorderLayout());
        this.root = new BopSwingRoot();
        this.add("Center", this.root);
        this.addFocusListener(this);
        this.setName("hidFormEditor");
        this.setCanClose(false);
    }

    public SwingEditFrame(Frame par) {
        super(par);
    }

    public Object[] getDataSelection() {
        return new Object[]{this};
    }

    public UndoTracker getUndoTracker() {
        return this.undoTracker;
    }

    public Binder binder() {
        return this.root.binder();
    }

    public LayoutableContainer getRoot() {
        return this.root.bopRoot;
    }

    LayoutController getActiveController() {
        return this.root.getBopRoot().getControllerBop().getActiveController();
    }

    public void ungroup() {
        this.getActiveController().ungroup();
    }

    public void snapToGrid() {
        this.getActiveController().snapToGrid();
    }

    public void setSelected(LayoutableComponent lc, boolean b) {
        this.getActiveController().setSelected(lc, b);
    }

    public void selectedToFront() {
        this.getActiveController().selectedToFront();
    }

    public void selectedToBack() {
        this.getActiveController().selectedToBack();
    }

    public LayoutableComponent[] selectedComponents() {
        return this.getActiveController().selectedComponents();
    }

    public Object getImageWrapper(Image img) {
        return new ImageIcon(img);
    }

    public void pasteClipboard() {
        this.getActiveController().pasteClipboard(this.getActiveController().view);
    }

    public void group() {
        this.getActiveController().group();
    }

    public void deselect() {
        this.getActiveController().deselect();
    }

    public void deleteSelected() {
        this.getActiveController().deleteSelected();
    }

    public Image getIcon(String name) {
        return SwingFactory.This().getIcon(name);
    }

    public void cloneSelected() {
        this.getActiveController().cloneSelected();
    }

    public void alignSize(int direction) {
        this.getActiveController().alignSize(direction, this.getUndoTracker());
    }

    public void alignTopMost() {
        this.getActiveController().alignTopMost(this.getUndoTracker());
    }

    public void alignCenter(boolean horzIfTrue) {
        this.getActiveController().alignCenter(horzIfTrue, this.getUndoTracker());
    }

    public void alignRightMost() {
        this.getActiveController().alignRightMost(this.getUndoTracker());
    }

    public void alignLeftMost() {
        this.getActiveController().alignLeftMost(this.getUndoTracker());
    }

    public void alignBottomMost() {
        this.getActiveController().alignBottomMost(this.getUndoTracker());
    }

    public void addTarget(Object target, String selector) {
        this.getActiveController().binder().addTarget(target, selector);
    }

    public void focusLost(FocusEvent e) {
    }

    public void focusGained(FocusEvent e) {
        this.getActiveController().binder().notifyTargets("focusGained");
    }

    public Object instantiate(String className) {
        try {
            JComponent result = (JComponent)SwingFactory.This().createInstance(className);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected BopContainer getActContainer() {
        return (BopContainer)this.getActiveController().view;
    }

    public LayoutableComponent addNewComponent(Object component, Copyable ass) {
        BopComponent newOne = BopComponent.New((JComponent)component);
        newOne.setAssocObject(ass);
        this.getActContainer().addLayComponentBop(0, 0, newOne);
        newOne.selectBop(true);
        Dimension d = ((JComponent)component).getPreferredSize();
        d.width = Math.max(24, d.width);
        d.height = Math.max(16, d.height);
        d.width = Math.min(200, d.width);
        d.height = Math.min(200, d.height);
        newOne.setBoundsBop(10, 10, d.width + 40, d.height + 40);
        this.getUndoTracker().addUndoAction(new AddDelAction(newOne, new Rectangle(10, 10, d.width + 40, d.height + 40), newOne.getParentBop(), false));
        this.getActContainer().repaint();
        return newOne;
    }

    public boolean canConvertFromString(Class clazz) {
        return clazz == Boolean.TYPE;
    }

    public String[] getPossibleValues(Class clazz) {
        if (clazz == Boolean.TYPE) {
            return new String[]{"true", "false"};
        }
        if (clazz == (class$javax$swing$border$Border == null ? (class$javax$swing$border$Border = SwingEditFrame.class$("javax.swing.border.Border")) : class$javax$swing$border$Border)) {
            return new String[]{"none", "etched", "bevelRaised", "bevelLowered", "line"};
        }
        return null;
    }

    public String[] availableClasses() {
        return SwingFactory.This().getProducts();
    }

    public IGUIPersistence getGUIPersistence() {
        return new SwingPersistance(SwingFactory.This());
    }

    public void allComponents(Vector v) {
        BopContainer act = this.root.getBopRoot();
        v.addElement(act);
        this.allComponents(v, act);
    }

    public void allComponents(Vector v, LayoutableContainer act) {
        int n = 0;
        while (n < act.serialCountBop()) {
            v.addElement(act.serialAt(n));
            if (act.serialAt(n) instanceof LayoutableContainer) {
                this.allComponents(v, (LayoutableContainer)act.serialAt(n));
            }
            ++n;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

