/*
 * Decompiled with CFR 0.152.
 */
package layedit.waf;

import de.netcomputing.modeller.ModellerEntity;
import de.netcomputing.util.connections.ArrowConnection;
import de.netcomputing.util.connections.INConnection;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import layedit.LayoutableComponent;
import layedit.access.IConnectionDrawer;
import layedit.swing.BopComponent;
import layedit.swing.BopContainer;

public class WafConnectionDrawer
implements IConnectionDrawer {
    static INConnection doubleArrow = new ArrowConnection();
    static INConnection outArrow = new ArrowConnection(1, 0, true);
    static INConnection inArrow = new ArrowConnection(0, 1, true);

    void computeIntersectX(double m, int[] xy, int xa) {
        xy[1] = xy[1] + (int)(m * (double)(xa - xy[0]));
        xy[0] = xa;
    }

    void computeIntersectY(double m, int[] xy, int ya) {
        xy[0] = xy[0] + (int)(1.0 / m * (double)(ya - xy[1]));
        xy[1] = ya;
    }

    void computeArrowTarget(Rectangle rect, int[] line) {
        int x = line[0];
        int y = line[1];
        int x1 = line[2];
        int y1 = line[3];
        double m = (double)(y1 - y) / (double)(x1 - x);
        int[] xy = new int[]{x1, y1};
        this.computeIntersectX(m, xy, x < rect.x + rect.width / 2 ? rect.x : rect.x + rect.width);
        int[] xy1 = new int[]{x1, y1};
        this.computeIntersectY(m, xy1, y < rect.y + rect.height / 2 ? rect.y : rect.y + rect.height);
        if (xy1[0] < rect.x - 1 || xy1[0] > rect.width + rect.x + 1) {
            line[2] = xy[0];
            line[3] = xy[1];
        } else {
            line[2] = xy1[0];
            line[3] = xy1[1];
        }
        line[0] = x;
        line[1] = y;
    }

    public void clearConnection(LayoutableComponent comp) {
    }

    public void drawConnections(LayoutableComponent comp, Component glassPane, Graphics g) {
        if (comp instanceof BopContainer && BopComponent.DRAWCONN) {
            BopContainer cont = (BopContainer)comp;
            BopComponent lastLC = null;
            int n = 0;
            while (n < cont.componentCountBop()) {
                BopComponent lc = (BopComponent)cont.at(n);
                if (lc.getInner() instanceof ModellerEntity) {
                    if (lastLC != null) {
                        Rectangle p = lc.getBounds();
                        Rectangle p1 = lastLC.getBounds();
                        int[] target1 = new int[]{0, 0};
                        int[] target2 = new int[]{0, 0};
                        ((ModellerEntity)lc.getWrappedBop()).getConnectionTarget(lastLC, target1, true);
                        ((ModellerEntity)lastLC.getWrappedBop()).getConnectionTarget(lc, target2, false);
                        int[] li = new int[]{target1[0] + p.x, target1[1] + p.y, target2[0] + p1.x, target2[1] + p1.y};
                        int[] li1 = new int[]{li[2], li[3], li[0], li[1]};
                        this.computeArrowTarget(p, li1);
                        inArrow.draw(null, g, li1[0], li1[1], li1[2], li1[3]);
                    }
                    lastLC = lc;
                }
                ++n;
            }
        }
    }
}

