/*
 * Decompiled with CFR 0.152.
 */
package netcomputing.collections;

import java.util.Enumeration;
import netcomputing.collections.INCEnumerateable;
import netcomputing.collections.INCIndexed;
import netcomputing.collections.NCBasicCollection;
import netcomputing.collections.NCComparator;
import netcomputing.collections.NCIndexedEnumerator;

public abstract class NCIndexedCollection
extends NCBasicCollection
implements INCIndexed,
Cloneable {
    public static void QuickSort(INCIndexed a, NCComparator ge) {
        NCIndexedCollection.QuickSort(a, 0, a.size() - 1, ge);
    }

    /*
     * Unable to fully structure code
     */
    public static void QuickSort(INCIndexed a, int lo0, int hi0, NCComparator ge) {
        block5: {
            lo = lo0;
            hi = hi0;
            if (hi0 <= lo0) break block5;
            mid = a.at((lo0 + hi0) / 2);
            ** GOTO lbl14
            {
                ++lo;
                do {
                    if (lo < hi0 && !ge.isBiggerOrEqual(a.at(lo), mid)) continue block0;
                    while (hi > lo0 && !ge.isBiggerOrEqual(mid, a.at(hi))) {
                        --hi;
                    }
                    if (lo > hi) continue;
                    NCIndexedCollection.Swap(a, lo++, hi--);
lbl14:
                    // 3 sources

                } while (lo <= hi);
            }
        }
        if (lo0 < hi) {
            NCIndexedCollection.QuickSort(a, lo0, hi, ge);
        }
        if (lo < hi0) {
            NCIndexedCollection.QuickSort(a, lo, hi0, ge);
        }
    }

    public static void Swap(INCIndexed a, int i, int j) {
        Object T = a.at(i);
        a.setAt(i, a.at(j));
        a.setAt(j, T);
    }

    public void sortBy(NCComparator comp) {
        NCIndexedCollection.QuickSort(this, comp);
    }

    public void sort() {
        this.sortBy(this.comparator);
    }

    public Object find(Object what) {
        int n = this.indexOf(what);
        try {
            return this.at(n);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int lastIndexOf(Object what) {
        int n = this.size() - 1;
        while (n >= 0) {
            if (this.at(n) != null && this.comparator.isEqual(this.at(n), what)) break;
            --n;
        }
        return n;
    }

    public boolean contains(Object what) {
        return this.indexOf(what) >= 0;
    }

    public int firstIndexOf(Object what) {
        return this.indexOf(what, 0);
    }

    public int indexOf(Object what, int startIndex) {
        int n = startIndex;
        while (n < this.size()) {
            if (this.at(n) != null && this.comparator.isEqual(this.at(n), what)) break;
            ++n;
        }
        return n >= this.size() ? -1 : this.size();
    }

    public int indexOf(Object what) {
        return this.lastIndexOf(what);
    }

    public int countElements() {
        return this.size();
    }

    public boolean startsWith(INCIndexed arr) {
        if (arr.size() > this.size()) {
            return false;
        }
        int maxCnt = arr.size();
        int n = 0;
        while (n < maxCnt && this.comparator.isEqual(arr.at(n), this.at(n))) {
            ++n;
        }
        return n == maxCnt;
    }

    public boolean endsWith(INCIndexed arr) {
        if (arr.size() > this.size()) {
            return false;
        }
        int offset = this.size() - arr.size();
        int n = this.size() - 1;
        while (n >= 0 && this.comparator.isEqual(arr.at(n - offset), this.at(n))) {
            --n;
        }
        return n == this.size() - offset - 1;
    }

    public boolean equals(Object o) {
        INCIndexed arr;
        try {
            arr = (INCIndexed)o;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (arr.size() != this.size()) {
            return false;
        }
        int n = this.size() - 1;
        while (n >= 0 && this.comparator.isEqual(arr.at(n), this.at(n))) {
            --n;
        }
        return n < 0;
    }

    public int locateInsertionIndexWhenSorted(Object o) {
        return this.locateInsertionIndexWhenSorted(o, 0, this.size(), this.comparator);
    }

    public int locateInsertionIndexWhenSorted(Object o, int start, int end, NCComparator comp) {
        if (end <= start) {
            if (start >= this.size()) {
                return start;
            }
            if (!comp.isBiggerOrEqual(this.at(start), o)) {
                return start + 1;
            }
            return start;
        }
        int mid = start + (end - start) / 2;
        if (comp.isBiggerOrEqual(this.at(mid), o)) {
            return this.locateInsertionIndexWhenSorted(o, start, mid - 1, comp);
        }
        return this.locateInsertionIndexWhenSorted(o, mid + 1, end, comp);
    }

    public void swap(int i, int j) {
        Object tmp = this.at(i);
        this.setAt(i, this.at(j));
        this.setAt(j, tmp);
    }

    public void reverse() {
        int i = 0;
        int j = this.size() - 1;
        while (i < j) {
            this.swap(i, j);
            ++i;
            --j;
        }
    }

    public Object reverseAt(int i) {
        return this.at(this.size() - i - 1);
    }

    public void reverseSetAt(int i, Object o) {
        this.setAt(this.size() - i - 1, o);
    }

    public boolean isEmpty() {
        return this.size() <= 0;
    }

    public void replaceAll(Object toSearch, Object toReplace) {
        int n = 0;
        while (n < this.size()) {
            if (this.comparator.isEqual(this.at(n), toSearch)) {
                this.setAt(n, toReplace);
            }
            ++n;
        }
    }

    public Object last() {
        if (this.size() == 0) {
            return null;
        }
        return this.at(this.size() - 1);
    }

    public Object first() {
        if (this.size() == 0) {
            return null;
        }
        return this.at(0);
    }

    public Enumeration enumerate() {
        return new NCIndexedEnumerator(this);
    }

    public INCEnumerateable copyShallow() {
        try {
            return (INCEnumerateable)this.clone();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public abstract void setAt(int var1, Object var2);

    public abstract int size();

    public abstract Object at(int var1);
}

