/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import Jxe.TextDocument;
import de.netcomputing.anyj.AJBookmarks;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.JListPanel;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.util.NCStringUtilities;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Vector;
import jxeplugins.JEBasicPlugin;
import jxeplugins.JEBasicService;
import netcomputing.tools.PropWriter;

public class BookmarkPlugin
extends JEBasicPlugin {
    JListPanel lp;
    AJBookmarks bpanel;
    Vector items = new Vector();

    public String getGlobalMenuName() {
        return "Bookmarks";
    }

    public void storeProperty(PropWriter pw) throws Exception {
        try {
            DataOutputStream dos = pw.createStream("Bookmarks#1");
            this.bpanel.storeBookmarks(dos);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void loadProperty(PropWriter pw) throws Exception {
        try {
            DataInputStream dis = pw.getStream("Bookmarks#1");
            if (this.bpanel == null) {
                this.bpanel = new AJBookmarks();
            }
            this.bpanel.readBookmarks(dis);
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
        Tracer.This.println("BookmarkPlugin::loadprop");
    }

    public void init(EditApp app) {
        super.init(app);
    }

    public void addProperties(final EditApp app) {
        try {
            Tracer.This.println("BookmarkPlugin addProperties");
            if (this.bpanel == null) {
                this.bpanel = new AJBookmarks();
            }
            this.lp = this.bpanel.getLp();
            app.addCustomPanel("Bookmarks", this.bpanel, NCApplication.GetImage("/images/menus/add bookmark.gif"));
            JEBasicService ser = new JEBasicService("Bookmarks", "Add Bookmark", 30){

                public boolean canProcess1(Object selection, Object selector) {
                    return selection instanceof TextDocument;
                }

                public void doProcess1(Object selection, Object selector) {
                    BookmarkPlugin.this.actionRequested(selection);
                }

                public boolean canProcess(Object selection, Object selector) {
                    boolean res = selection instanceof File && !((File)selection).isDirectory();
                    return res || this.canProcess1(selection, selector);
                }

                public void doProcess(Object selection, Object selector) {
                    if (this.canProcess1(selection, selector)) {
                        this.doProcess1(selection, selector);
                        return;
                    }
                    BookmarkPlugin.this.bpanel.addItem((File)selection, 0, 0);
                }
            };
            app.addService(ser);
            ser = new JEBasicService("Bookmarks", "Add Bookmarks from opened Files", 30){

                public boolean canProcess(Object selection, Object selector) {
                    return EditApp.App.getOpenedFiles().size() > 0;
                }

                public void doProcess(Object selection, Object selector) {
                    Vector v = EditApp.App.getOpenedFiles();
                    int n = 0;
                    while (n < v.size()) {
                        BookmarkPlugin.this.bpanel.addItemQuiet(new File("" + v.elementAt(n)).getName(), new File("" + v.elementAt(n)), 0, 0);
                        ++n;
                    }
                }
            };
            app.addService(ser);
            ser = new JEBasicService("Bookmarks", "Add Bookmarks from Directory", 30){

                public boolean canProcess(Object selection, Object selector) {
                    return selection instanceof File && ((File)selection).isDirectory();
                }

                public void doProcess(Object selection, Object selector) {
                    BookmarkPlugin.this.bpanel.addItemQuiet(((File)selection).getName(), (File)selection, 0, 0);
                }
            };
            app.addService(ser);
            ser = new JEBasicService("Bookmarks", "Show Bookmarks", 18){

                public boolean canProcess(Object selection, Object selector) {
                    return true;
                }

                public void doProcess(Object selection, Object selector) {
                    app.showCard("Bookmarks");
                    BookmarkPlugin.this.bpanel.getLp().requestFocus();
                }
            };
            app.addService(ser);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void ensureSelection() {
        int i = this.lp.getSelectionIndex();
        if (i < 0) {
            if (this.lp.listSize() == 0) {
                return;
            }
            this.lp.setSelectionIndex(0);
        }
    }

    void importBookmarks(File f) {
        Exception exc = null;
        try {
            DataInputStream in = new DataInputStream(new FileInputStream(f));
            String line = null;
            while ((line = in.readLine()) != null) {
                try {
                    line = line.trim();
                    Vector lineItems = NCStringUtilities.SplitSeparatedString("|", line);
                    String finam = lineItems.elementAt(0).toString();
                    int lineNo = 0;
                    if (lineItems.size() > 1) {
                        lineNo = Integer.parseInt(lineItems.elementAt(1).toString());
                    }
                    String comment = new File(finam).getName();
                    if (lineItems.size() > 2) {
                        comment = lineItems.elementAt(2).toString();
                    }
                    this.bpanel.addItemQuiet(comment, new File(finam), 0, lineNo);
                }
                catch (Exception ex) {
                    exc = ex;
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            Confirm.ModalMsg("Exception during import", ex.getMessage());
            ex.printStackTrace();
        }
        if (exc != null) {
            Confirm.ModalMsg(EditApp.App.getMainWindow(), "Exceptions during import", new String[]{exc.getClass().getName() + ":" + exc.getMessage(), "Use a file containing lines formated like this:", "absoluteFilename|linenumber|comment"});
        }
    }

    public Object actionRemove(Object arg, Object sen) {
        this.bpanel.remBtn_actionPerformed(null);
        return null;
    }

    public String getDescription() {
        return "This Plugin adds the capability to mark bookmarks in the editor and retrieve themlater on.";
    }

    public void actionRequested(Object arg) {
        if (arg instanceof TextDocument) {
            TextDocument doc = (TextDocument)arg;
            this.bpanel.addItem(doc.getFile(), doc.cX(), doc.cY());
        }
        if (arg == null) {
            this.app.showCard("Bookmarks");
        }
    }

    static {
        NCApplication.PutImage("bookmark", "bookmark.gif");
    }
}

