/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import util.AttributeInfo;
import util.ClassFile;
import util.ConstantPoolInfo;

public class MethodInfo {
    public short accessFlags;
    public ConstantPoolInfo name;
    public ConstantPoolInfo signature;
    public AttributeInfo[] attributes;

    public boolean read(DataInputStream di, ConstantPoolInfo[] pool) throws IOException {
        this.accessFlags = di.readShort();
        this.name = pool[di.readShort()];
        this.signature = pool[di.readShort()];
        int count = di.readShort();
        if (count != 0) {
            this.attributes = new AttributeInfo[count];
            int i = 0;
            while (i < count) {
                this.attributes[i] = new AttributeInfo();
                if (!this.attributes[i].read(di, pool)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public void write(DataOutputStream dos, ConstantPoolInfo[] pool) throws IOException, Exception {
        dos.writeShort(this.accessFlags);
        dos.writeShort(ConstantPoolInfo.indexOf(this.name, pool));
        dos.writeShort(ConstantPoolInfo.indexOf(this.signature, pool));
        if (this.attributes == null) {
            dos.writeShort(0);
        } else {
            dos.writeShort(this.attributes.length);
            int i = 0;
            while (i < this.attributes.length) {
                this.attributes[i].write(dos, pool);
                ++i;
            }
        }
    }

    public String toString(String className) {
        StringBuffer x = new StringBuffer();
        boolean isArray = false;
        boolean ndx = false;
        StringBuffer parameterList = new StringBuffer();
        char initialParameter = 'a';
        StringBuffer varName = new StringBuffer();
        String s = this.signature.strValue;
        String paramSig = s.substring(s.indexOf(40) + 1, s.indexOf(41));
        String returnSig = s.substring(s.indexOf(41) + 1);
        x.append(ClassFile.accessString(this.accessFlags));
        if (className != null && this.name.toString().startsWith("<init>")) {
            parameterList.append(className);
        } else {
            parameterList.append(this.name.toString());
        }
        parameterList.append("(");
        if (paramSig.length() > 0 && paramSig.charAt(0) != 'V') {
            while (paramSig.length() > 0) {
                varName.setLength(0);
                varName.append(initialParameter);
                initialParameter = (char)(initialParameter + '\u0001');
                parameterList.append(ClassFile.typeString(paramSig, varName.toString()));
                paramSig = ClassFile.nextSig(paramSig);
                if (paramSig.length() <= 0) continue;
                parameterList.append(", ");
            }
        }
        parameterList.append(")");
        x.append(ClassFile.typeString(returnSig, parameterList.toString()));
        x.append(";");
        return x.toString();
    }

    public String toString() {
        return this.toString(null);
    }
}

