/*
 * Decompiled with CFR 0.152.
 */
package versioncontrol;

import de.netcomputing.util.Tracer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;

public class AccessControl {
    String lockDirectory;
    String userPath;
    String originalUserPath;

    public AccessControl(String lockDirectory) {
        this.setLockDirectory(lockDirectory);
    }

    public synchronized void setLockDirectory(String lockDirectory) {
        this.lockDirectory = lockDirectory;
        File f = new File(lockDirectory);
        if (f.exists() && f.isDirectory()) {
            new File(lockDirectory + File.separator + "history").mkdir();
        }
    }

    public synchronized String getLockDirectory() {
        return this.lockDirectory;
    }

    public void setUserPath(String userPath) {
        this.originalUserPath = userPath;
        this.userPath = this.privateGetLockNameFromFileName(userPath).toUpperCase();
    }

    public String getUserPath() {
        return this.userPath;
    }

    String getLockNameFromFileName(String file2) {
        if ((file2 = this.privateGetLockNameFromFileName(file2)).toUpperCase().startsWith(this.getUserPath())) {
            file2 = file2.substring(this.getUserPath().length());
        }
        return file2;
    }

    String privateGetLockNameFromFileName(String file2) {
        file2 = file2.replace('/', '_');
        file2 = file2.replace('\\', '_');
        file2 = file2.replace(':', '_');
        return file2;
    }

    public synchronized String getOwner(String file2) {
        file2 = this.getLockNameFromFileName(file2);
        String lockFile = this.lockDirectory + File.separator + file2 + ".lock";
        if (!new File(lockFile).exists()) {
            Tracer.This.println("getOwner, file does not exist:" + lockFile);
            return null;
        }
        try {
            FileInputStream lin = new FileInputStream(lockFile);
            String name = new DataInputStream(lin).readUTF();
            lin.close();
            Tracer.This.println("getOwner, result:" + name);
            return name;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String setLock(String file0, String username) {
        if (!file0.toUpperCase().startsWith(this.originalUserPath.toUpperCase())) {
            Tracer.This.println(file0.toUpperCase() + " not starting with accesscontrol root:" + this.getUserPath().toUpperCase());
            return username;
        }
        String file2 = this.getLockNameFromFileName(file0);
        String lockFile = this.lockDirectory + File.separator + file2 + ".lock";
        String history = this.lockDirectory + File.separator + "history" + File.separator + file2 + ".hist";
        String owner = this.getOwner(file0);
        if (owner != null && !owner.equals(username)) {
            return owner;
        }
        try {
            FileOutputStream fout = new FileOutputStream(history, true);
            FileOutputStream lockout = new FileOutputStream(lockFile);
            try {
                PrintStream dout = new PrintStream(fout);
                DataOutputStream plockout = new DataOutputStream(lockout);
                dout.println("locked   :" + username + ",  " + DateFormat.getDateTimeInstance().format(new Date()));
                plockout.writeUTF(username);
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                fout.close();
                lockout.close();
                throw throwable;
            }
            fout.close();
            lockout.close();
            {
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return username;
    }

    public synchronized Vector listLocks() {
        String[] s = new File(this.lockDirectory).list();
        Vector<String> result = null;
        if (s != null && s.length > 0) {
            result = new Vector(s.length);
            int n = 0;
            while (n < s.length) {
                if (s[n].endsWith(".lock")) {
                    try {
                        FileInputStream fin = new FileInputStream(this.lockDirectory + File.separator + s[n] + ".lock");
                        DataInputStream in = new DataInputStream(fin);
                        String line = in.readLine();
                        result.addElement(line);
                        fin.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                ++n;
            }
        } else {
            result = new Vector<String>(1);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String clearLock(String file0, String username) {
        String file2 = this.getLockNameFromFileName(file0);
        String lockFile = this.lockDirectory + File.separator + file2 + ".lock";
        String history = this.lockDirectory + File.separator + "history" + File.separator + file2 + ".hist";
        String owner = this.getOwner(file0);
        if (owner != null && !owner.equals(username)) {
            return owner;
        }
        try {
            FileOutputStream fout = new FileOutputStream(history, true);
            try {
                PrintStream dout = new PrintStream(fout);
                dout.println("unlocked :" + username + ",  " + DateFormat.getDateTimeInstance().format(new Date()));
                new File(lockFile).delete();
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                fout.close();
                throw throwable;
            }
            fout.close();
            {
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

