/******************************************************
 * File: SampleContainer.java
 * created 24-Feb-00 2:19:30 PM by ruedi
 */
package de.netcomputing.examplebeans;
import de.netcomputing.examplebeans.fontchooser.*;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.awt.*;
import de.netcomputing.runtime.*;

/**
* The Panel of a main frame.
*/
public class SampleContainer extends JPanel implements WindowListener
{
	//$$$vars 		------- GENERATED CODE, DO NOT EDIT THIS SECTION ----------
	NCFontChooserBean ncFontChooserBean;
	JLabel selectedFont;
	//$$$endVars    -----------------------------------------------------------
	
	public SampleContainer()
	{
		initGui();
	}

	public void initGui()
	{
		new SampleContainerGUI().createGui( this );
		selectedFont.setFont( ncFontChooserBean.getSelectedFont() );
	}

	public JFrame getFrame()
	{
		return (JFrame)getTopLevelAncestor();
	}
	
	/**
	* locate and load the image, replace code below to avoid the need of
	* a runtime library (ApplicationHelper)
	*/
	public Image getImageForBuilder( String imageName, String packageAsPath )
	{
		// load via classpath from de.netcomputing.examplebeans/images/imageName.gif
		// resp. /images/imageName.gif (2cnd lookup)
		return ApplicationHelper.Singleton().getImage( getClass(), "images/"+imageName );
		
	}

	// WindowListener interface (to listen events sent from the JFrame) (see main method below)

	/**
	* this panel acts as a windowlistener of the main frame
	*/
	public void windowOpened( WindowEvent e )
	{
	}

	/**
	* this panel acts as a windowlistener of the main frame
	*/
	public void windowIconified( WindowEvent e )
	{
	}

	/**
	* this panel acts as a windowlistener of the main frame
	*/
	public void windowDeiconified( WindowEvent e )
	{
	}

	/**
	* this panel acts as a windowlistener of the main frame
	*/
	public void windowDeactivated( WindowEvent e )
	{
	}

	/**
	* this panel acts as a windowlistener of the main frame
	*/
	public void windowClosing( WindowEvent e )
	{
		System.exit( 0 );
	}

	/**
	* this panel acts as a windowlistener of the main frame
	*/
	public void windowClosed( WindowEvent e )
	{
		
	}

	/**
	* this panel acts as a windowlistener of the main frame
	*/
	public void windowActivated( WindowEvent e )
	{
	}

	
	//$$$actions ------------------ do not delete, generated marker, eventhandlers are generated below

	public void ncFontChooserBean_fontChanged( NCFontChooserEvent var0 )
	{
		selectedFont.setFont( ncFontChooserBean.getSelectedFont() );
	}


	/**
	* Note that it i possible to access the Frame using '(JFrame)getTopLevelAncestor()' 
	*/
	public static void main( String arg[] )
	{
		try {
		UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
		} catch ( Exception e ) { e.printStackTrace(); }
		JFrame frame = new JFrame();
		SampleContainer panel = new SampleContainer();
		frame.getContentPane().add( "Center" , panel );
		frame.addWindowListener( panel );
		frame.pack();
		frame.setVisible( true );
	}


}
