/******************************************************
 * File: ScalingLayout.java
 * @autor
 *
 * Copyright 1999 by NetComputing GmbH, Inc.,
 * Erzbergerstr. 131 76133 Karlsruhe, Germany
 * www.netcomputing.de
 * All rights reserved.
 * 
 * This software is the confidential and proprietary information
 * of NetComputing, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with NetComputing.
 */


package de.netcomputing.runtime;

import java.awt.*;
import java.util.*;

/**
* This class implements the LayoutManager used by ressource (GML-files) created using
* AnyJ's Gui-Builder. It is fed with two sizes for each component, and calculates a linear transform
* from this values. It is not very useful for use by program, but useful for creating resizable GUI's
* using a graphical GUI-builder.
*/
public class ScalingLayout implements LayoutManager
{
	/**
	*/
	public Hashtable ht = new Hashtable(20);	

	public Dimension originalFrameSize;
	public Dimension originalFrameSize1;
	
	
	
	/** 
	* This static variable enables you to enforce a resize of all ressources. I.e. setting
	* fontFakX to 1.1 increases all controls width by 10 percent. 
	* This may be useful if the gui needs to be enlarged globally due to platform differences (fonts)
	* or Look & Feel differences.
	*/
	static public double fontFakX = 1.0;

	/** 
	* This static variable enables you to enforce a resize of all ressources. I.e. setting
	* fontFakY to 1.1 increases all controls hiheght by 10 percent. 
	* This may be useful if the gui needs to be enlarged globally due to platform differences (fonts)
	* or Lokk & Feel differences.
	* You won't use this class directly, it is used by AnyJ's GUI-Builder. 
	*/
	static public double fontFakY = 1.0;
	
	/**
	* creates a ScalingLayout 
	* @param w - minimum width of the panel
	* @param h - minimum heigt of the panel
	* @param w1 - larger width of the panel
	* @param h1 - larger heigt of the panel
	*/
	public ScalingLayout( int w, int h, int w1, int h1 )
	{
		originalFrameSize = new Dimension( (int)  (w /** fontFakX*/), (int) (h /** fontFakY*/) );
		w1 = Math.max( w1, w+1 );
		h1 = Math.max( h1, h+1 );
		originalFrameSize1 = new Dimension( (int) (w1 /** fontFakX*/),(int) (h1 /** fontFakY*/) );
	}

	protected double calcSize( 
		double originalFrame, double originalFrame1,
		double originalSize, double originalSize1,
		double currentFrame )
	{
		double m = ( originalSize1 - originalSize ) / ( ( originalFrame1 / originalFrame ) - 1 ),
			   b = originalSize - m;
		return (currentFrame/originalFrame) * m + b;
	}
	
	/**
	* set layout data for component 'c'.
	*/
	public void putProps( Component c, double lx, double ty, double w, double h )
	{  putProps( c, lx, ty, w, h, lx*10, ty*10, w*10, h*10 );   }

	/**
	* set layout data for component 'c'.
	*/
	public void putProps( Component c, Object[] rects )
	{  
		Rectangle r1 = (Rectangle) rects[0];
		Rectangle r2 = (Rectangle) rects[1];
		putProps( c, r1.x, r1.y, r1.width, r1.height, r2.x, r2.y, r2.width, r2.height );    
	}
	
	/**
	* set layout data for component 'c'.
	*/
	public void putProps( Component c, double lx, double ty, double w, double h,
		double slx, double sty, double sw, double sh )
	{
		double d[] = new double[8];
		d[0] = lx; d[1] = ty; d[2] = w; d[3] = h;
		d[4] = slx; d[5] = sty; d[6] = sw; d[7] = sh;
		ht.put( c,d ); 
	}

	/**
	* get layout data for component 'c'.
	*/
	public Object[] getProps( Component c )
	{
		double d[] = (double[]) ht.get( c );
		Object result[] = 
			{ new Rectangle( (int) d[0], (int) d[1], (int) d[2], (int) d[3] ) ,
			  new Rectangle( (int) d[4], (int) d[5], (int) d[6], (int) d[7] ) };
		return result;
	}

	/**
	* is empty
	*/
	public void addLayoutComponent(String  name, Component  comp)
	{
	}
	
	/**
	* @see java.awt.LayoutManager
	*/
	public void layoutContainer(Container  parent)
	{
		int c = parent.countComponents();
		Component comp;
		
		double 
			ox = originalFrameSize.width,
			oy = originalFrameSize.height,
			ox1 = originalFrameSize1.width,
			oy1 = originalFrameSize1.height,
			curX = (double)Math.max( parent.size().width, originalFrameSize.width ) / fontFakX + 0.5,
			curY = (double)Math.max( parent.size().height, originalFrameSize.height ) / fontFakY + 0.5,
			cx,cy,crx,cry;  // buffers for componentx/y-distances

		for ( int n = 0; n < c; n++ )
		{
			comp = parent.getComponent(n);
			double d[] = (double[])ht.get( comp );
			if (d == null) 
				System.out.println( "ScalingLayout: no Layout found for "+comp ); 
			else 
			{
				cx  = calcSize( ox, ox1, d[0], d[4], curX ) * fontFakX;
				cy  = calcSize( oy, oy1, d[1], d[5], curY ) * fontFakY;
				crx = calcSize( ox, ox1, d[2], d[6], curX ) * fontFakX;
				cry = calcSize( oy, oy1, d[3], d[7], curY ) * fontFakY;
				comp.reshape( (int) cx, (int) cy, (int) crx, (int) cry );
				if ( ! comp.isValid() )
				{
					comp.validate();
				}
			}
		}
	}
	
	/**
	* @see java.awt.LayoutManager
	*/
	public Dimension minimumLayoutSize(Container  parent)
	{
		return new Dimension( (int)(originalFrameSize.width /** fontFakX*/), (int)(originalFrameSize.height /** fontFakY*/) );
	}
	
	/**
	* @see java.awt.LayoutManager
	*/
	public Dimension preferredLayoutSize(Container  parent)
	{
		return minimumLayoutSize( parent );
	}

	/**
	* @see java.awt.LayoutManager
	*/
	public void removeLayoutComponent(Component  comp)
	{   
		ht.remove( comp );
	}
}
