/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.serial.impl;

import com.pi4j.io.serial.Serial;
import com.pi4j.io.serial.SerialDataListener;
import com.pi4j.io.serial.SerialPortException;
import com.pi4j.io.serial.impl.SerialDataMonitorThread;
import java.util.concurrent.CopyOnWriteArrayList;

public class SerialImpl
implements Serial {
    protected int fileDescriptor = -1;
    protected final CopyOnWriteArrayList<SerialDataListener> listeners = new CopyOnWriteArrayList();
    protected SerialDataMonitorThread monitor;
    protected boolean isshutdown = false;

    @Override
    public void open(String device, int baudRate) throws SerialPortException {
        this.fileDescriptor = com.pi4j.wiringpi.Serial.serialOpen(device, baudRate);
        if (this.fileDescriptor == -1) {
            throw new SerialPortException("Cannot open serial port");
        }
    }

    @Override
    public boolean isOpen() {
        return this.fileDescriptor >= 0;
    }

    @Override
    public boolean isClosed() {
        return !this.isOpen();
    }

    @Override
    public void close() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'close()'.");
        }
        com.pi4j.wiringpi.Serial.serialClose(this.fileDescriptor);
    }

    @Override
    public void flush() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'flush()'.");
        }
        com.pi4j.wiringpi.Serial.serialFlush(this.fileDescriptor);
    }

    @Override
    public char read() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'read()'.");
        }
        return (char)com.pi4j.wiringpi.Serial.serialGetchar(this.fileDescriptor);
    }

    @Override
    public void write(char data) throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'write(char)'.");
        }
        com.pi4j.wiringpi.Serial.serialPutchar(this.fileDescriptor, data);
    }

    @Override
    public void write(char[] data) throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'write(char[])'.");
        }
        this.write(new String(data));
    }

    @Override
    public void write(byte data) throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'write(byte)'.");
        }
        com.pi4j.wiringpi.Serial.serialPutchar(this.fileDescriptor, (char)data);
    }

    @Override
    public void write(byte[] data) throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'write(byte[])'.");
        }
        for (byte b : data) {
            com.pi4j.wiringpi.Serial.serialPutchar(this.fileDescriptor, (char)b);
        }
    }

    @Override
    public void write(String data) throws IllegalStateException {
        int length;
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'write(String)'.");
        }
        for (int position = 0; position < data.length(); position += length) {
            length = 1024;
            if (position + 1024 > data.length()) {
                com.pi4j.wiringpi.Serial.serialPuts(this.fileDescriptor, data.substring(position));
                continue;
            }
            com.pi4j.wiringpi.Serial.serialPuts(this.fileDescriptor, data.substring(position, position + length));
        }
    }

    @Override
    public void writeln(String data) throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'writeln(String)'.");
        }
        this.write(data + "\r\n");
    }

    @Override
    public void write(String data, String ... args) throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'write(String data, String...args)'.");
        }
        this.write(String.format(data, args));
    }

    @Override
    public void writeln(String data, String ... args) throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'writeln(String data, String...args)'.");
        }
        this.write(data + "\r\n", args);
    }

    @Override
    public int availableBytes() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Serial connection is not open; cannot 'availableBytes()'.");
        }
        return com.pi4j.wiringpi.Serial.serialDataAvail(this.fileDescriptor);
    }

    @Override
    public synchronized void addListener(SerialDataListener ... listener) {
        for (SerialDataListener lsnr : listener) {
            this.listeners.add(lsnr);
        }
        if (this.monitor == null || !this.monitor.isAlive()) {
            this.monitor = new SerialDataMonitorThread(this, this.listeners);
            this.monitor.start();
        }
    }

    @Override
    public synchronized void removeListener(SerialDataListener ... listener) {
        for (SerialDataListener lsnr : listener) {
            this.listeners.remove(lsnr);
        }
        if (this.listeners.isEmpty() && this.monitor != null) {
            this.monitor.shutdown();
            this.monitor = null;
        }
    }

    @Override
    public boolean isShutdown() {
        return this.isshutdown;
    }

    @Override
    public synchronized void shutdown() {
        if (this.isOpen()) {
            this.close();
        }
        if (this.isShutdown()) {
            return;
        }
        if (this.monitor != null) {
            this.monitor.shutdown();
        }
    }
}

