/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.util;

import com.pi4j.system.SystemInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NativeLibraryLoader {
    private static List<String> loadedLibraries = null;
    private static Logger logger = Logger.getLogger("com.pi4j.util.NativeLibraryLoader");
    private static FileHandler fileHandler;
    private static ConsoleHandler consoleHandler;
    private static boolean initialized;

    private NativeLibraryLoader() {
    }

    public static synchronized void load(String libraryName) {
        NativeLibraryLoader.load(libraryName, null);
    }

    public static synchronized void load(String libraryName, String fileName) {
        if (!initialized) {
            initialized = true;
            String debug = System.getProperty("pi4j.debug");
            if (debug != null) {
                logger.setLevel(Level.ALL);
                try {
                    fileHandler = new FileHandler("pi4j.log");
                    fileHandler.setLevel(Level.ALL);
                    consoleHandler = new ConsoleHandler();
                    consoleHandler.setLevel(Level.ALL);
                    logger.addHandler(fileHandler);
                    logger.addHandler(consoleHandler);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (fileName == null || fileName.length() == 0) {
            logger.fine("Load library [" + libraryName + "] (no alternate embedded file provided)");
        } else {
            logger.fine("Load library [" + libraryName + "] (alternate embedded file: " + fileName + ")");
        }
        if (loadedLibraries == null) {
            loadedLibraries = Collections.synchronizedList(new ArrayList());
        }
        if (loadedLibraries.contains(libraryName)) {
            logger.fine("Library [" + libraryName + "] has already been loaded; no need to load again.");
        } else {
            loadedLibraries.add(libraryName);
            try {
                logger.fine("Attempting to load library [" + libraryName + "] using the System.loadLibrary(name) method.");
                System.loadLibrary(libraryName);
                logger.fine("Library [" + libraryName + "] loaded successfully using the System.loadLibrary(name) method.");
            }
            catch (UnsatisfiedLinkError e) {
                URL resourceUrl;
                if (fileName == null) {
                    logger.severe("Library [" + libraryName + "] could not be located using the System.loadLibrary(name) method and no embedded file path was provided as an auxillary lookup.");
                    loadedLibraries.remove(libraryName);
                    throw e;
                }
                logger.fine("Library [" + libraryName + "] could not be located using the System.loadLibrary(name) method; attempting to resolve the library using embedded resources in the JAR file.");
                boolean armhf_force = false;
                if (System.getProperty("pi4j.armhf") != null) {
                    armhf_force = true;
                }
                boolean armel_force = false;
                if (System.getProperty("pi4j.armel") != null) {
                    armel_force = true;
                }
                if (armhf_force) {
                    resourceUrl = NativeLibraryLoader.class.getResource("/lib/hard-float/" + fileName);
                } else if (armel_force) {
                    resourceUrl = NativeLibraryLoader.class.getResource("/lib/soft-float/" + fileName);
                } else {
                    logger.fine("AUTO-DETECTED HARD-FLOAT ABI : " + SystemInfo.isHardFloatAbi());
                    resourceUrl = SystemInfo.isHardFloatAbi() ? NativeLibraryLoader.class.getResource("/lib/hard-float/" + fileName) : NativeLibraryLoader.class.getResource("/lib/soft-float/" + fileName);
                }
                try {
                    NativeLibraryLoader.loadLibraryFromResource(resourceUrl, libraryName, fileName);
                    logger.fine("Library [" + libraryName + "] loaded successfully using embedded resource file: [" + resourceUrl.toString() + "]");
                }
                catch (Exception | UnsatisfiedLinkError ex) {
                    URL resourceUrlHardFloat = NativeLibraryLoader.class.getResource("/lib/hard-float/" + fileName);
                    try {
                        NativeLibraryLoader.loadLibraryFromResource(resourceUrlHardFloat, libraryName, fileName);
                        logger.info("Library [" + libraryName + "] loaded successfully using embedded resource file: [" + resourceUrlHardFloat.toString() + "] (ARMHF)");
                    }
                    catch (UnsatisfiedLinkError ule_hard_float) {
                        logger.fine("Failed to load library [" + libraryName + "] using the System.load(file) method using embedded resource file: [" + resourceUrlHardFloat.toString() + "]");
                        URL resourceUrlSoftFloat = NativeLibraryLoader.class.getResource("/lib/soft-float/" + fileName);
                        try {
                            NativeLibraryLoader.loadLibraryFromResource(resourceUrlSoftFloat, libraryName, fileName);
                            logger.info("Library [" + libraryName + "] loaded successfully using embedded resource file: [" + resourceUrlSoftFloat.toString() + "] (ARMEL)");
                        }
                        catch (Throwable err) {
                            logger.severe("Failed to load library [" + libraryName + "] using the System.load(file) method using embedded resource file: [" + resourceUrlSoftFloat.toString() + "]");
                            logger.throwing(logger.getName(), "load", err);
                            loadedLibraries.remove(libraryName);
                            logger.severe("ERROR:  The native library [" + libraryName + " : " + fileName + "] could not be found in the JVM library path nor could it be loaded from the embedded JAR resource file; you may need to explicitly define the library path '-Djava.library.path' where this native library can be found.");
                        }
                    }
                    catch (Exception ex_hard_float) {
                        logger.severe("Failed to load library [" + libraryName + "] using the System.load(file) method using embedded resource file: [" + resourceUrlHardFloat.toString() + "]");
                        logger.throwing(logger.getName(), "load", ex_hard_float);
                        loadedLibraries.remove(libraryName);
                        logger.severe("ERROR:  The native library [" + libraryName + " : " + fileName + "] could not be found in the JVM library path nor could it be loaded from the embedded JAR resource file; you may need to explicitly define the library path '-Djava.library.path' where this native library can be found.");
                    }
                }
            }
        }
    }

    private static void loadLibraryFromResource(URL resourceUrl, String libraryName, String fileName) throws UnsatisfiedLinkError, Exception {
        File tempFile;
        byte[] buffer = new byte[1024];
        int byteCount = 0;
        logger.fine("Attempting to load library [" + libraryName + "] using the System.load(file) method using embedded resource file: [" + resourceUrl.toString() + "]");
        InputStream inputStream = resourceUrl.openStream();
        File tempDirectory = new File(System.getProperty("java.io.tmpdir"));
        if (!tempDirectory.exists()) {
            logger.warning("The Java system temporary path [" + tempDirectory.getAbsolutePath() + "] does not exist.");
            tempDirectory = new File("");
        }
        if ((tempFile = new File(tempDirectory.getAbsolutePath() + "/" + fileName)).exists()) {
            logger.warning("The temporary file already exists [" + tempFile.getAbsolutePath() + "]; attempting to delete it now.");
            tempFile.delete();
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(tempFile);
        }
        catch (FileNotFoundException fnfe) {
            logger.severe("The temporary file [" + tempFile.getAbsolutePath() + "] cannot be created; it is a directory, not a file.");
            throw fnfe;
        }
        catch (SecurityException se) {
            logger.severe("The temporary file [" + tempFile.getAbsolutePath() + "] cannot be created; a security exception was detected. " + se.getMessage());
            throw se;
        }
        try {
            while ((byteCount = inputStream.read(buffer)) >= 0) {
                ((OutputStream)outputStream).write(buffer, 0, byteCount);
            }
            outputStream.flush();
            ((OutputStream)outputStream).close();
        }
        catch (IOException ioe) {
            logger.severe("The temporary file [" + tempFile.getAbsolutePath() + "] could not be written to; an IO exception was detected. " + ioe.getMessage());
            throw ioe;
        }
        inputStream.close();
        try {
            System.load(tempFile.getAbsolutePath());
            try {
                tempFile.deleteOnExit();
            }
            catch (SecurityException dse) {
                logger.warning("The temporary file [" + tempFile.getAbsolutePath() + "] cannot be flagged for removal on program termination; a security exception was detected. " + dse.getMessage());
            }
        }
        catch (UnsatisfiedLinkError ule) {
            if (tempFile.exists()) {
                tempFile.delete();
            }
            throw ule;
        }
        catch (Exception ex) {
            if (tempFile.exists()) {
                tempFile.delete();
            }
            throw ex;
        }
    }

    static {
        initialized = false;
    }
}

