/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.debugger.DebuggerThread;
import bluej.debugger.DebuggerThreadTreeModel;
import bluej.debugger.jdi.JdiThread;
import bluej.debugger.jdi.JdiThreadNode;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import java.util.Enumeration;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JdiThreadTreeModel
extends DefaultTreeModel
implements DebuggerThreadTreeModel {
    private DebuggerThreadTreeModel.SyncMechanism syncer = new DebuggerThreadTreeModel.SyncMechanism(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invokeLater(Runnable r) {
            Object object = JdiThreadTreeModel.this.getRoot();
            synchronized (object) {
                r.run();
            }
        }
    };

    public JdiThreadTreeModel(JdiThreadNode root) {
        super(root, true);
    }

    @Override
    public void setSyncMechanism(DebuggerThreadTreeModel.SyncMechanism s) {
        this.syncer = s;
    }

    public void syncExec(Runnable r) {
        this.syncer.invokeLater(r);
    }

    @Override
    public DebuggerThread getNodeAsDebuggerThread(Object node) {
        Object o = ((JdiThreadNode)node).getUserObject();
        if (o instanceof JdiThread) {
            return (JdiThread)o;
        }
        return null;
    }

    @Override
    public TreePath findNodeForThread(DebuggerThread thr) {
        return new TreePath(this.findThreadNode(((JdiThread)thr).getRemoteThread()).getPath());
    }

    JdiThreadNode getThreadRoot() {
        return (JdiThreadNode)this.getRoot();
    }

    JdiThreadNode findThreadNode(ThreadGroupReference tgr) {
        Enumeration<TreeNode> en = this.getThreadRoot().breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            ThreadGroupReference otgr;
            JdiThreadNode n = (JdiThreadNode)en.nextElement();
            Object o = n.getUserObject();
            if (!(o instanceof ThreadGroupReference) || !(otgr = (ThreadGroupReference)o).equals(tgr)) continue;
            return n;
        }
        return null;
    }

    JdiThreadNode findThreadNode(ThreadReference tr) {
        Enumeration<TreeNode> en = this.getThreadRoot().breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            JdiThread jt;
            JdiThreadNode n = (JdiThreadNode)en.nextElement();
            Object o = n.getUserObject();
            if (!(o instanceof JdiThread) || !(jt = (JdiThread)o).getRemoteThread().equals(tr)) continue;
            return n;
        }
        return null;
    }
}

