/*
 * Decompiled with CFR 0.152.
 */
package bluej.graph;

import bluej.Config;
import bluej.graph.Graph;
import bluej.graph.GraphListener;
import bluej.graph.GraphPainter;
import bluej.graph.MarqueePainter;
import bluej.graph.RubberBand;
import bluej.graph.SelectableGraphElement;
import bluej.graph.SelectionController;
import bluej.graph.Vertex;
import bluej.pkgmgr.graphPainter.GraphPainterStdImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.PrintGraphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPanel;

public class GraphEditor
extends JPanel
implements MouseMotionListener,
GraphListener {
    protected final Color envOpColour = Config.ENV_COLOUR;
    private static final Cursor handCursor = new Cursor(12);
    private static final Cursor defaultCursor = new Cursor(0);
    private static final Cursor resizeCursor = new Cursor(5);
    public static final int GRID_SIZE = 10;
    private Graph graph;
    private GraphPainter graphPainter;
    private MarqueePainter marqueePainter;
    private SelectionController selectionController;
    private Cursor currentCursor = defaultCursor;
    private FocusListener focusListener;
    private boolean hasPermFocus;

    public GraphEditor(Graph graph) {
        this.graph = graph;
        this.marqueePainter = new MarqueePainter();
        this.graphPainter = GraphPainterStdImpl.getInstance();
        this.selectionController = new SelectionController(this);
        graph.addListener(this);
        this.setToolTipText("");
        this.focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!GraphEditor.this.hasPermFocus) {
                    GraphEditor.this.setPermFocus(true);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                Component opposite;
                if (GraphEditor.this.hasPermFocus && !e.isTemporary() && ((opposite = e.getOppositeComponent()) == null || opposite != GraphEditor.this && opposite.getParent() != GraphEditor.this)) {
                    GraphEditor.this.setPermFocus(false);
                }
            }
        };
        this.addFocusListener(this.focusListener);
        this.setLayout(null);
        this.graphChanged();
    }

    public void startMouseListening() {
        this.addMouseMotionListener(this);
        this.addMouseMotionListener(this.selectionController);
        this.addMouseListener(this.selectionController);
        this.addKeyListener(this.selectionController);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.graph.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.graph.getMinimumSize();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        if (!(g2D instanceof PrintGraphics)) {
            Dimension d = this.getSize();
            if (!Config.isRaspberryPi()) {
                GradientPaint gp = new GradientPaint(d.width / 4, 0.0f, new Color(253, 253, 250), d.width * 3 / 4, d.height, new Color(241, 231, 196));
                g2D.setPaint(gp);
            } else {
                g2D.setPaint(new Color(247, 242, 223));
            }
            g2D.fillRect(0, 0, d.width, d.height);
        }
        this.graphPainter.paint(g2D, this);
        this.marqueePainter.paint(g2D, this.selectionController.getMarquee());
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        SelectableGraphElement element = this.graph.findGraphElement(x, y);
        Cursor newCursor = defaultCursor;
        if (element != null) {
            newCursor = element.isResizable() && element.isHandle(x, y) ? resizeCursor : handCursor;
        }
        if (this.currentCursor != newCursor) {
            this.setCursor(newCursor);
            this.currentCursor = newCursor;
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent evt) {
        super.processMouseEvent(evt);
        if (evt.isPopupTrigger()) {
            this.selectionController.handlePopupTrigger(evt);
        }
    }

    public void clearSelection() {
        this.selectionController.clearSelection();
    }

    public void removeFromSelection(SelectableGraphElement element) {
        this.selectionController.removeFromSelection(element);
    }

    public void addToSelection(SelectableGraphElement element) {
        this.selectionController.addToSelection(element);
    }

    public RubberBand getRubberBand() {
        return this.selectionController.getRubberBand();
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void popupMenu(int x, int y) {
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int y;
        int x = event.getX();
        SelectableGraphElement element = this.graph.findGraphElement(x, y = event.getY());
        if (element == null) {
            return null;
        }
        return element.getTooltipText();
    }

    @Override
    public void selectableElementRemoved(SelectableGraphElement element) {
        this.removeFromSelection(element);
    }

    @Override
    public void graphChanged() {
        HashMap<Component, Boolean> keep = new HashMap<Component, Boolean>();
        for (Component c : this.getComponents()) {
            keep.put(c, false);
        }
        Iterator<? extends Vertex> it = this.graph.getVertices();
        while (it.hasNext()) {
            Vertex v = it.next();
            if (!keep.containsKey(v.getComponent())) {
                this.add(v.getComponent());
                v.getComponent().addFocusListener(this.focusListener);
                v.getComponent().addFocusListener(this.selectionController);
                v.getComponent().addKeyListener(this.selectionController);
                if (v.isSelected()) {
                    this.selectionController.addToSelection(v);
                }
            }
            keep.put(v.getComponent(), true);
        }
        for (Map.Entry e : keep.entrySet()) {
            if (((Boolean)e.getValue()).booleanValue()) continue;
            this.remove((Component)e.getKey());
            ((Component)e.getKey()).removeFocusListener(this.focusListener);
            ((Component)e.getKey()).removeFocusListener(this.selectionController);
            ((Component)e.getKey()).removeKeyListener(this.selectionController);
        }
        this.repaint();
    }

    public void graphClosed() {
        for (Component c : this.getComponents()) {
            c.removeFocusListener(this.focusListener);
            c.removeFocusListener(this.selectionController);
            c.removeKeyListener(this.selectionController);
        }
    }

    public void setPermFocus(boolean focus) {
        this.hasPermFocus = focus;
    }

    public boolean hasPermFocus() {
        return this.hasPermFocus;
    }
}

