/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork;

import bluej.Config;
import java.io.File;

public class TeamStatusInfo {
    private File file;
    private String localVersion;
    private String remoteVersion;
    private int status;
    public static final int STATUS_UPTODATE = 0;
    public static final int STATUS_NEEDSCHECKOUT = 1;
    public static final int STATUS_DELETED = 2;
    public static final int STATUS_NEEDSUPDATE = 3;
    public static final int STATUS_NEEDSCOMMIT = 4;
    public static final int STATUS_NEEDSMERGE = 5;
    public static final int STATUS_NEEDSADD = 6;
    public static final int STATUS_REMOVED = 7;
    public static final int STATUS_UNRESOLVED = 8;
    public static final int STATUS_HASCONFLICTS = 9;
    public static final int STATUS_WEIRD = 10;
    public static final int STATUS_CONFLICT_ADD = 12;
    public static final int STATUS_CONFLICT_LMRD = 13;
    public static final int STATUS_CONFLICT_LDRM = 14;
    public static final int STATUS_BLANK = 11;
    public static final String[] statusStrings = new String[]{"team.statusinfo.upToDate", "team.statusinfo.needsCheckout", "team.statusinfo.deleted", "team.statusinfo.needsUpdate", "team.statusinfo.needsCommit", "team.statusinfo.needsMerge", "team.statusinfo.needsAdd", "team.statusinfo.removed", "team.statusinfo.unresolved", "team.statusinfo.hasConflicts", "team.statusinfo.weird", "", "team.statusinfo.conflictAdd", "team.statusinfo.conflictLMRD", "team.statusinfo.conflictLDRM"};

    public TeamStatusInfo() {
        this(new File(""), "", "", 11);
    }

    public TeamStatusInfo(File file, String localVersion, String remoteVersion, int status) {
        this.file = file;
        this.localVersion = localVersion;
        this.remoteVersion = remoteVersion;
        this.status = status;
    }

    public File getFile() {
        return this.file;
    }

    public String getLocalVersion() {
        return this.localVersion;
    }

    public String getRepositoryVersion() {
        return this.remoteVersion;
    }

    public int getStatus() {
        return this.status;
    }

    public String toString() {
        return this.getFile().getName();
    }

    public static String getStatusString(int status) {
        if (status == 11) {
            return "";
        }
        return Config.getString(statusStrings[status]);
    }
}

