/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.EscapeDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public final class VersionCheckDialog
extends EscapeDialog
implements ActionListener {
    private static final String close = Config.getString("close");
    private static final String dialogTitle = Config.getString("pkgmgr.versionDlg.title");
    private static final String helpLine1 = Config.getString("pkgmgr.versionDlg.helpLine1");
    private static final String helpLine2 = Config.getString("pkgmgr.versionDlg.helpLine2");
    private static final String versionURL = Config.getPropString("bluej.url.versionCheck");
    private JTextArea textArea;
    private JButton closeButton;
    private String newVersion = null;
    private Thread versionThread = null;
    private boolean isClosed = false;

    public VersionCheckDialog(PkgMgrFrame parent) {
        super(parent, dialogTitle, true);
        this.makeDialog();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (close.equals(cmd)) {
            this.doClose();
        }
    }

    private void doClose() {
        this.isClosed = true;
        this.setVisible(false);
    }

    private void doVersionCheck() {
        this.textArea.setText(Config.getString("pkgmgr.checkingVersion"));
        this.versionThread = new VersionChecker();
        this.versionThread.start();
    }

    private void makeDialog() {
        this.setDefaultCloseOperation(2);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BlueJTheme.dialogBorder);
        JLabel helpText1 = new JLabel(helpLine1);
        mainPanel.add(helpText1);
        JLabel helpText2 = new JLabel(helpLine2);
        mainPanel.add(helpText2);
        Font smallFont = helpText1.getFont().deriveFont(10);
        helpText1.setFont(smallFont);
        helpText2.setFont(smallFont);
        mainPanel.add(Box.createVerticalStrut(5));
        this.textArea = new JTextArea(14, 46);
        this.textArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        mainPanel.add(scrollPane);
        mainPanel.add(Box.createVerticalStrut(17));
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setAlignmentX(0.0f);
        this.closeButton = new JButton(close);
        this.closeButton.addActionListener(this);
        buttonPanel.add(this.closeButton);
        this.getRootPane().setDefaultButton(this.closeButton);
        this.closeButton.requestFocus();
        mainPanel.add(buttonPanel);
        this.getContentPane().add(mainPanel);
        this.pack();
        DialogManager.centreDialog(this);
        this.doVersionCheck();
    }

    private void setTextLater(String txt) {
        final String text = txt;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VersionCheckDialog.this.textArea.setText(text);
            }
        });
    }

    private class VersionChecker
    extends Thread {
        private VersionChecker() {
        }

        @Override
        public void run() {
            try {
                InputStream is = new URL(versionURL).openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                if (this.isOutOfDate(reader)) {
                    if (!VersionCheckDialog.this.isClosed) {
                        this.displayNewVersionInfo(reader);
                    }
                } else if (!VersionCheckDialog.this.isClosed) {
                    VersionCheckDialog.this.setTextLater(Config.getString("pkgmgr.versionDlg.upToDate"));
                }
            }
            catch (IOException exc) {
                if (!VersionCheckDialog.this.isClosed) {
                    VersionCheckDialog.this.setTextLater("Error: could not access remote version information");
                }
                Debug.reportError("IO error when trying to access URL\n" + exc);
            }
        }

        private boolean isOutOfDate(BufferedReader versionReader) {
            try {
                VersionCheckDialog.this.newVersion = versionReader.readLine();
                if (VersionCheckDialog.this.newVersion != null) {
                    VersionCheckDialog.this.newVersion = VersionCheckDialog.this.newVersion.trim();
                }
            }
            catch (IOException exc) {
                VersionCheckDialog.this.setTextLater("Error: could not read remote version information");
                Debug.reportError("IO error when reading remote version info\n" + exc);
            }
            return !"3.1.7".equals(VersionCheckDialog.this.newVersion);
        }

        private void displayNewVersionInfo(BufferedReader versionReader) {
            if (VersionCheckDialog.this.newVersion == null) {
                VersionCheckDialog.this.setTextLater("Error: could not read remote version info");
            } else {
                StringBuffer text = new StringBuffer(Config.getString("pkgmgr.versionDlg.currentVersion"));
                text.append(" ");
                text.append("3.1.7");
                text.append("\n");
                text.append(Config.getString("pkgmgr.versionDlg.newVersion"));
                text.append(" ");
                text.append(VersionCheckDialog.this.newVersion);
                text.append("\n");
                try {
                    String line = versionReader.readLine();
                    while (line != null) {
                        text.append(line);
                        text.append("\n");
                        line = versionReader.readLine();
                    }
                }
                catch (IOException exc) {
                    Debug.reportError("IO error when reading from version file");
                }
                final StringBuffer txt = text;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VersionCheckDialog.this.textArea.setText(txt.toString());
                        VersionCheckDialog.this.textArea.setCaretPosition(0);
                    }
                });
            }
        }
    }
}

