/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.graphPainter;

import bluej.Config;
import bluej.pkgmgr.graphPainter.GraphPainterStdImpl;
import bluej.pkgmgr.target.PackageTarget;
import bluej.pkgmgr.target.Target;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Utility;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;

public class PackageTargetPainter {
    private static final int TAB_HEIGHT = 12;
    private static final int HANDLE_SIZE = 20;
    private static final Color bordercolour = Color.BLACK;
    private static final int TEXT_HEIGHT = GraphPainterStdImpl.TEXT_HEIGHT;
    private static final int TEXT_BORDER = 4;
    private static final AlphaComposite alphaComposite = GraphPainterStdImpl.alphaComposite;
    private static Composite oldComposite;
    private int tabWidth;

    public void paint(Graphics2D g, Target target, boolean hasFocus) {
        PackageTarget packageTarget = (PackageTarget)target;
        g.translate(packageTarget.getX(), packageTarget.getY());
        int width = packageTarget.getWidth();
        int height = packageTarget.getHeight();
        this.drawUMLStyle(g, packageTarget, hasFocus, width, height);
        g.translate(-packageTarget.getX(), -packageTarget.getY());
    }

    public void paintGhost(Graphics2D g, Target target, boolean hasFocus) {
        PackageTarget packageTarget = (PackageTarget)target;
        oldComposite = g.getComposite();
        g.translate(packageTarget.getGhostX(), packageTarget.getGhostY());
        int width = packageTarget.getGhostWidth();
        int height = packageTarget.getGhostHeight();
        g.setComposite(alphaComposite);
        this.drawUMLStyle(g, packageTarget, hasFocus, width, height);
        g.setComposite(oldComposite);
        g.translate(-packageTarget.getGhostX(), -packageTarget.getGhostY());
    }

    private void drawUMLStyle(Graphics2D g, PackageTarget packageTarget, boolean hasFocus, int width, int height) {
        boolean isSelected;
        this.tabWidth = packageTarget.getWidth() / 3;
        int thickness = 1;
        boolean bl = isSelected = packageTarget.isSelected() && hasFocus;
        if (isSelected) {
            thickness = 2;
        }
        Paint fill = !Config.isRaspberryPi() ? new GradientPaint(width / 4, 0.0f, new Color(229, 183, 173), width * 3 / 4, height, new Color(207, 130, 117)) : new Color(253, 157, 145);
        if (!Config.isRaspberryPi()) {
            this.drawShadow(g, packageTarget, this.tabWidth, width, height);
        }
        g.setPaint(fill);
        g.fillRoundRect(0, 0, this.tabWidth, 17, 5, 5);
        g.setColor(bordercolour);
        Utility.drawThickRoundRect(g, 0, 0, this.tabWidth, 17, 5, thickness);
        g.setPaint(fill);
        g.fillRect(0, 12, width, height - 12);
        g.setColor(bordercolour);
        for (int i = 0; i < thickness; ++i) {
            g.drawLine(this.tabWidth - (isSelected ? 1 : 0), 12 + i, width - i, 12 + i);
            g.drawLine(i, height - i, width - i, height - i);
            g.drawLine(i, 12, i, height - i);
            g.drawLine(width - i, 12 + i, width - i, height - i);
        }
        g.setFont(this.getFont(packageTarget));
        Utility.drawCentredText(g, packageTarget.getDisplayName(), 4, 26, width - 8, TEXT_HEIGHT);
        if (isSelected) {
            g.drawLine(width - 20 - 2, height, width, height - 20 - 2);
            g.drawLine(width - 20 + 2, height, width, height - 20 + 2);
        }
    }

    private void drawShadow(Graphics2D g, PackageTarget packageTarget, int tabWidth, int width, int height) {
        int[] shadowAlphas = new int[]{20, 15, 10, 5, 5};
        for (int i = 0; i < 5; ++i) {
            g.setColor(new Color(0, 0, 0, shadowAlphas[i]));
            g.fillRoundRect(2 - i, 4 - i, tabWidth + 2 * i - 1, 17 + 2 * i - 1, 8, 8);
            g.fillRoundRect(2 - i, 16 - i, width + 2 * i - 1, height - 12 + 2 * i - 1, 8, 8);
        }
    }

    private Font getFont(PackageTarget packageTarget) {
        return PrefMgr.getTargetFont();
    }
}

