/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.MoeEditor;
import bluej.prefmgr.PrefMgr;
import bluej.utility.DBox;
import bluej.utility.DBoxLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FindPanel
extends JPanel
implements ActionListener,
DocumentListener,
MouseListener {
    private MoeEditor editor;
    private JComponent findBody;
    private DBox findTextBody;
    private DBox optionsBody;
    private JPanel mcBody;
    private JPanel closeBody;
    private DBox findLabelBox;
    private JLabel replaceLabel;
    private JTextField findTField;
    private JButton previousButton;
    private JButton nextButton;
    private JCheckBox matchCaseCheckBox;
    private JLabel replaceIconLabel;
    private JLabel closeIconLabel;
    private String searchString = "";
    private static Font findFont;
    private ImageIcon openIcon;
    private ImageIcon closedIcon;
    private int searchStart = -1;

    public FindPanel(MoeEditor ed) {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 5, 0));
        this.openIcon = Config.getFixedImageAsIcon((String)"bluej_arrow_open.gif");
        this.closedIcon = Config.getFixedImageAsIcon((String)"bluej_arrow_close.gif");
        findFont = PrefMgr.getStandardFont();
        this.editor = ed;
        this.initDisplay();
        this.setFindDisplay();
        this.setCaseCheckDisplay();
        this.setCloseDisplay();
        this.setPrevNextDisplay();
        this.setReplaceDisplay();
        this.addDisplayElements();
        this.findTField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (FindPanel.this.searchStart == -1) {
                    FindPanel.this.searchStart = FindPanel.this.editor.getCurrentTextPane().getCaretPosition();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                FindPanel.this.searchStart = -1;
            }
        });
    }

    @Override
    public void setVisible(boolean aFlag) {
        if (aFlag && !this.isVisible()) {
            this.searchStart = this.editor.getCurrentTextPane().getSelectionStart();
        }
        super.setVisible(aFlag);
        if (aFlag) {
            this.findTField.requestFocus();
        }
    }

    public int getLabelBoxWidth() {
        return this.findLabelBox.getPreferredSize().width;
    }

    private void initDisplay() {
        this.findBody = new DBox(DBoxLayout.X_AXIS, 0, 11, 0.5f);
        this.findTextBody = new DBox(DBoxLayout.X_AXIS, 0, 5, 0.5f);
        this.optionsBody = new DBox(DBoxLayout.X_AXIS, 0, 5, 0.5f);
        this.mcBody = new DBox(DBoxLayout.X_AXIS, 0, 0, 0.5f);
        if (!Config.isRaspberryPi()) {
            this.findBody.setOpaque(false);
        }
        if (!Config.isRaspberryPi()) {
            this.findTextBody.setOpaque(false);
        }
        if (!Config.isRaspberryPi()) {
            this.optionsBody.setOpaque(false);
        }
        if (!Config.isRaspberryPi()) {
            this.mcBody.setOpaque(false);
        }
        this.closeBody = new JPanel(new BorderLayout());
        if (!Config.isRaspberryPi()) {
            this.closeBody.setOpaque(false);
        }
    }

    private void setFindDisplay() {
        JLabel findLabel = new JLabel(Config.getString((String)"editor.findpanel.findLabel"));
        findLabel.setFont(findFont);
        this.replaceLabel = new JLabel(Config.getString((String)"editor.replacePanel.replaceLabel"));
        this.replaceLabel.setFont(findFont);
        Dimension lblSize = findLabel.getPreferredSize();
        lblSize.width = Math.max(lblSize.width, this.replaceLabel.getPreferredSize().width);
        this.findLabelBox = new DBox(DBox.X_AXIS, 0.5f);
        this.findLabelBox.setMaximumSize(lblSize);
        this.findLabelBox.setPreferredSize(lblSize);
        this.findLabelBox.add(Box.createHorizontalGlue());
        this.findLabelBox.add((Component)findLabel);
        this.findLabelBox.setOpaque(false);
        this.findTField = new JTextField(11);
        this.findTField.setMaximumSize(this.findTField.getPreferredSize());
        this.findTField.setFont(findFont);
        this.setSearchString("");
        this.setfindTextField("");
        this.findTField.getDocument().addDocumentListener(this);
        this.findTField.addActionListener(this);
    }

    private void setPrevNextDisplay() {
        this.previousButton = new JButton();
        this.previousButton.addActionListener(this);
        this.previousButton.setText(Config.getString((String)"editor.findpanel.findPrevious") + " ");
        this.previousButton.setEnabled(false);
        this.previousButton.setFont(findFont);
        this.nextButton = new JButton();
        this.nextButton.addActionListener(this);
        this.nextButton.setText(Config.getString((String)"editor.findpanel.findNext"));
        this.nextButton.setEnabled(false);
        this.nextButton.setFont(findFont);
        if (Config.isMacOS()) {
            this.previousButton.putClientProperty("JButton.buttonType", "segmentedTextured");
            this.previousButton.putClientProperty("JButton.segmentPosition", "first");
            this.nextButton.putClientProperty("JButton.buttonType", "segmentedTextured");
            this.nextButton.putClientProperty("JButton.segmentPosition", "last");
        }
    }

    private void setCaseCheckDisplay() {
        this.matchCaseCheckBox = new JCheckBox();
        this.matchCaseCheckBox.setText(Config.getString((String)"editor.findpanel.matchCase"));
        this.matchCaseCheckBox.setSelected(false);
        this.matchCaseCheckBox.setFont(findFont);
        this.matchCaseCheckBox.addActionListener(this);
        if (!Config.isRaspberryPi()) {
            this.matchCaseCheckBox.setOpaque(false);
        }
    }

    public boolean getMatchCase() {
        return this.matchCaseCheckBox.isSelected();
    }

    private void setCloseDisplay() {
        this.closeIconLabel = new JLabel();
        this.closeIconLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 10));
        this.closeIconLabel.setIcon(Config.getFixedImageAsIcon((String)"cross.png"));
        this.closeIconLabel.addMouseListener(this);
    }

    private void setReplaceDisplay() {
        this.replaceIconLabel = new JLabel(Config.getString((String)"editor.findpanel.replacePanel"));
        this.replaceIconLabel.setFont(findFont);
        this.replaceIconLabel.setIcon(this.closedIcon);
        this.replaceIconLabel.addMouseListener(this);
    }

    private void addDisplayElements() {
        this.findTextBody.add((Component)this.findLabelBox);
        this.findTextBody.add((Component)this.findTField);
        if (Config.isMacOS()) {
            DBox buttonBox = new DBox(DBoxLayout.X_AXIS, 0.5f);
            if (!Config.isRaspberryPi()) {
                buttonBox.setOpaque(false);
            }
            buttonBox.add((Component)this.previousButton);
            buttonBox.add((Component)this.nextButton);
            this.optionsBody.add((Component)buttonBox);
        } else {
            this.optionsBody.add((Component)this.previousButton);
            this.optionsBody.add((Component)this.nextButton);
        }
        this.closeBody.add((Component)this.closeIconLabel, "East");
        this.mcBody.add(this.matchCaseCheckBox);
        this.mcBody.add(Box.createHorizontalStrut(22));
        this.mcBody.add(this.replaceIconLabel);
        this.findBody.add((Component)this.findTextBody);
        this.findBody.add((Component)this.optionsBody);
        this.findBody.add(this.mcBody);
        this.add((Component)this.findBody, "West");
        this.add((Component)this.closeBody, "East");
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.getInputMap(2).put(keyStroke, "escapeAction");
        this.getActionMap().put("escapeAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindPanel.this.close();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComponent src = (JComponent)e.getSource();
        if (src == this.nextButton || src == this.findTField) {
            this.getNext();
        } else if (src == this.previousButton) {
            this.getPrev();
        } else if (src == this.matchCaseCheckBox) {
            this.editor.getCurrentTextPane().setCaretPosition(this.editor.getCurrentTextPane().getSelectionStart());
            this.find(true);
        }
    }

    public void getNext() {
        this.editor.getCurrentTextPane().setCaretPosition(this.editor.getCurrentTextPane().getSelectionStart() + 1);
        this.find(true);
        this.editor.enableReplaceButtons();
    }

    public void getPrev() {
        this.find(false);
        this.editor.enableReplaceButtons();
    }

    private void findEvent() {
        int selBegin = this.editor.getCurrentTextPane().getSelectionStart();
        if (this.getSearchString() != null && this.findTField.getText().length() == 0) {
            this.editor.removeSearchHighlights();
            this.setSearchString(null);
            this.editor.getCurrentTextPane().setCaretPosition(selBegin);
            this.writeMessage(false, 0);
            return;
        }
        this.editor.getCurrentTextPane().setCaretPosition(selBegin);
        boolean found = this.find(true);
        if (!found && this.searchStart != -1) {
            this.editor.getCurrentTextPane().setCaretPosition(this.searchStart);
        }
        this.updateDisplay(found);
    }

    public void displayFindPanel(String selection) {
        if (selection == null) {
            selection = this.getSearchString();
        }
        this.setSearchString(selection);
        this.setVisible(true);
        this.populateFindTextfield(selection);
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    private void updateDisplay(boolean enable) {
        this.previousButton.setEnabled(enable);
        this.nextButton.setEnabled(enable);
        this.editor.enableReplaceButtons(enable);
    }

    private void setFindValues() {
        this.setSearchString(this.findTField.getText());
        this.findTField.requestFocus();
    }

    public boolean highlightAll(boolean ignoreCase, boolean forwards) {
        int counter = this.search(ignoreCase, true, forwards);
        if (counter < 1) {
            if (this.searchStart != -1) {
                this.editor.getCurrentTextPane().setCaretPosition(this.searchStart);
            }
            this.previousButton.setEnabled(false);
            this.nextButton.setEnabled(false);
            this.editor.enableReplaceButtons(false);
        }
        this.writeMessage(true, counter);
        return counter != 0;
    }

    private void writeMessage(boolean emptyMessage, int counter) {
        if (!emptyMessage) {
            this.editor.writeMessage(" ");
            return;
        }
        if (counter > 0) {
            if (this.editor.getCurrentTextPane().getSelectedText() != null) {
                // empty if block
            }
            this.editor.writeMessage(Config.getString((String)"editor.highlight.found").trim() + " " + counter + " " + Config.getString((String)"editor.replaceAll.intancesOf").trim() + " " + this.getSearchString());
        } else if (counter < 1 && this.getSearchString().length() > 0) {
            this.editor.writeMessage(Config.getString((String)"editor.replaceAll.string").trim() + " " + this.getSearchString() + " " + Config.getString((String)"editor.highlight.notFound").trim());
        }
    }

    private int search(boolean ignoreCase, boolean wrap, boolean next) {
        String searchStr = this.getSearchString();
        if (searchStr.length() == 0) {
            return 0;
        }
        if (!next) {
            this.editor.doFindBackward(searchStr, ignoreCase, wrap);
        } else {
            this.editor.doFind(searchStr, ignoreCase, wrap);
        }
        int caretPos = this.editor.getCurrentTextPane().getCaretPosition();
        if (caretPos > this.getSearchString().length()) {
            caretPos = this.editor.getCurrentTextPane().getCaretPosition() - searchStr.length();
        }
        this.editor.getCurrentTextPane().setCaretPosition(caretPos);
        int found = this.editor.doFindSelect(searchStr, ignoreCase, wrap);
        return found;
    }

    protected boolean find(boolean forward) {
        this.setFindValues();
        this.editor.removeSearchHighlights();
        return this.highlightAll(!this.matchCaseCheckBox.isSelected(), forward);
    }

    public String getSearchTextfield() {
        return this.findTField.getText();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.findEvent();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.findTField.getText().length() == 0) {
            this.editor.removeSearchHighlights();
            this.editor.removeSelections();
            this.setSearchString(null);
            if (this.searchStart != -1) {
                this.editor.getCurrentTextPane().setCaretPosition(this.searchStart);
            }
            this.writeMessage(false, 0);
            this.updateDisplay(false);
        } else {
            this.findEvent();
        }
    }

    public void setfindTextField(String selection) {
        this.findTField.setText(selection);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JComponent src = (JComponent)e.getSource();
        if (src == this.closeIconLabel) {
            this.close();
            return;
        }
        if (src == this.replaceIconLabel) {
            if (this.editor.isShowingInterface()) {
                return;
            }
            this.editor.toggleReplacePanelVisible();
            if (this.replaceIconLabel.getIcon() == this.openIcon) {
                this.replaceIconLabel.setIcon(this.closedIcon);
            } else if (this.replaceIconLabel.getIcon() == this.closedIcon) {
                this.replaceIconLabel.setIcon(this.openIcon);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void setTextfieldSelected() {
        this.findTField.selectAll();
    }

    protected void setFindReplaceIcon(boolean open) {
        if (open) {
            this.replaceIconLabel.setIcon(this.openIcon);
        } else {
            this.replaceIconLabel.setIcon(this.closedIcon);
        }
    }

    public void close() {
        this.editor.removeSearchHighlights();
        this.setVisible(false);
        this.editor.setReplacePanelVisible(false);
        this.editor.getCurrentTextPane().requestFocusInWindow();
        this.replaceIconLabel.setIcon(this.closedIcon);
    }

    protected JTextField getFindTField() {
        return this.findTField;
    }

    protected void requestFindfieldFocus() {
        this.findTField.requestFocus();
    }

    protected void populateFindTextfield(String selection) {
        this.setfindTextField(selection);
        this.findTField.selectAll();
        this.findTField.requestFocus();
    }

    protected void setReplaceEnabled(boolean isEnabled) {
        this.replaceIconLabel.setEnabled(isEnabled);
        if (!isEnabled) {
            this.setFindReplaceIcon(false);
        }
    }

    protected int getSearchStart() {
        return this.searchStart;
    }

    protected void setSearchStart(int searchStart) {
        this.searchStart = searchStart;
    }
}

