/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.AdvancedHighlightPainter;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;

public class MoeBorderHighlighterPainter
implements AdvancedHighlightPainter {
    Color borderColor = Color.BLACK;
    Color innerColor1;
    Color innerColor2;
    Color selectionColor1;
    Color selectionColor2;

    public MoeBorderHighlighterPainter(Color bColor, Color fillColor1, Color fillColor2, Color selectionColor1, Color selectionColor2) {
        this.borderColor = bColor;
        this.innerColor1 = fillColor1;
        this.innerColor2 = fillColor2;
        this.selectionColor1 = selectionColor1;
        this.selectionColor2 = selectionColor2;
    }

    private void paintGradient(Graphics g, Rectangle r, Color color1, Color color2) {
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            Paint origPaint = g2d.getPaint();
            GradientPaint gp = new GradientPaint(r.x, r.y, color1, r.x + r.width / 2, r.y + r.height, color2);
            g2d.setPaint(gp);
            g2d.fillRoundRect(r.x - 2, r.y, r.width + 2, r.height, 6, 6);
            g2d.setPaint(origPaint);
        }
    }

    @Override
    public void paint(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
        try {
            offs0 = Math.max(offs0, view.getStartOffset());
            offs1 = Math.min(offs1, view.getEndOffset());
            Shape s = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
            Rectangle r = s.getBounds();
            if (!Config.isRaspberryPi()) {
                this.paintGradient(g, r, this.innerColor1, this.innerColor2);
            } else {
                g.setColor(new Color(Math.round((this.innerColor1.getRed() + this.innerColor2.getRGB()) / 2)));
                g.fillRoundRect(r.x - 2, r.y, r.width + 2, r.height, 6, 6);
            }
            g.setColor(this.borderColor);
            int selStart = c.getSelectionStart();
            int selEnd = c.getSelectionEnd();
            boolean overLaps = selStart != selEnd;
            if (overLaps &= selStart < offs1 && selEnd >= offs0) {
                int clipL;
                int diff;
                Rectangle clip;
                Shape origClip = g.getClip();
                Rectangle rectangle = clip = origClip != null ? origClip.getBounds() : bounds.getBounds();
                if (selEnd < offs1) {
                    int clipR = view.modelToView((int)selEnd, (Shape)bounds, (Position.Bias)Position.Bias.Backward).getBounds().x;
                    clip.width = Math.min(clip.width, clipR - clip.x);
                }
                if (selStart > offs0 && (diff = (clipL = view.modelToView((int)selStart, (Shape)bounds, (Position.Bias)Position.Bias.Forward).getBounds().x) - clip.x) > 0) {
                    clip.x = clipL;
                    clip.width -= diff;
                }
                g.setClip(clip);
                if (!Config.isRaspberryPi()) {
                    this.paintGradient(g, r, this.selectionColor1, this.selectionColor2);
                } else {
                    g.setColor(new Color(Math.round((this.innerColor1.getRed() + this.innerColor2.getRGB()) / 2)));
                    g.fillRoundRect(r.x - 2, r.y, r.width + 2, r.height, 6, 6);
                }
                g.setClip(origClip);
            }
            g.drawRoundRect(r.x - 2, r.y, r.width + 2, r.height - 1, 6, 6);
            r.x -= 2;
            r.width += 3;
        }
        catch (BadLocationException e) {
            return;
        }
    }

    @Override
    public void issueRepaint(int p0, int p1, Shape viewBounds, JTextComponent editor, View rootView) {
        try {
            Shape s = rootView.modelToView(p0, Position.Bias.Forward, p1, Position.Bias.Backward, viewBounds);
            Rectangle r = s.getBounds();
            r.x -= 2;
            r.width += 4;
            editor.repaint(r);
        }
        catch (BadLocationException ble) {
            throw new RuntimeException(ble);
        }
    }
}

