/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class MoePlainView
extends View {
    private Font currentFont;
    protected FontMetrics metrics;
    private Element longestLine;
    protected int tabSize;
    private Segment segment = new Segment();
    private int leftMargin;

    public MoePlainView(Element elem) {
        super(elem);
    }

    public MoePlainView(Element elem, int leftMargin) {
        super(elem);
        this.leftMargin = leftMargin;
    }

    @Override
    public float getPreferredSpan(int axis) {
        this.checkMetrics();
        switch (axis) {
            case 0: {
                return this.getLineWidth(this.getLongestLine()) + this.leftMargin;
            }
            case 1: {
                return this.getElement().getElementCount() * this.metrics.getHeight();
            }
        }
        return 0.0f;
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        this.checkMetrics();
        Element map = this.getElement();
        int lineIndex = map.getElementIndex(pos);
        Element line = map.getElement(lineIndex);
        Segment s = this.segment;
        Document doc = this.getDocument();
        doc.getText(line.getStartOffset(), pos - line.getStartOffset(), s);
        MoeTabExpander tabExpander = new MoeTabExpander(this.tabSize, this.leftMargin);
        int tpos = Utilities.getTabbedTextWidth(s, this.metrics, this.leftMargin, (TabExpander)tabExpander, line.getStartOffset());
        Rectangle aBounds = a.getBounds();
        return new Rectangle(aBounds.x + (tpos += this.leftMargin), aBounds.y + lineIndex * this.metrics.getHeight(), 1, this.metrics.getHeight());
    }

    @Override
    public int viewToModel(float x, float y, Shape a, Position.Bias[] biasReturn) {
        this.checkMetrics();
        Rectangle aBounds = a.getBounds();
        if (y < (float)aBounds.y) {
            biasReturn[0] = Position.Bias.Forward;
            return 0;
        }
        if (y > (float)(aBounds.height + aBounds.y)) {
            biasReturn[0] = Position.Bias.Backward;
            return this.getDocument().getLength();
        }
        int lindex = ((int)y - aBounds.y) / this.metrics.getHeight();
        if (lindex >= this.getElement().getElementCount()) {
            biasReturn[0] = Position.Bias.Backward;
            return this.getDocument().getLength();
        }
        if (lindex < 0) {
            biasReturn[0] = Position.Bias.Forward;
            return 0;
        }
        Element line = this.getElement().getElement(lindex);
        if (x <= (float)aBounds.x) {
            biasReturn[0] = Position.Bias.Forward;
            return line.getStartOffset();
        }
        if (x > (float)(aBounds.x + aBounds.width)) {
            biasReturn[0] = Position.Bias.Backward;
            return line.getEndOffset() - 1;
        }
        Segment s = this.segment;
        int lineStart = line.getStartOffset();
        try {
            this.getDocument().getText(lineStart, line.getEndOffset() - lineStart - 1, s);
        }
        catch (BadLocationException ble) {
            throw new RuntimeException(ble);
        }
        MoeTabExpander tx = new MoeTabExpander(this.tabSize, this.leftMargin);
        int offset = Utilities.getTabbedTextOffset(s, this.metrics, this.leftMargin, (int)x - aBounds.x, tx, lineStart);
        biasReturn[0] = Position.Bias.Forward;
        return Math.min(lineStart + offset, this.getDocument().getLength());
    }

    @Override
    public void paint(Graphics g, Shape allocation) {
        LayeredHighlighter lh;
        this.checkMetrics();
        JTextComponent host = (JTextComponent)this.getContainer();
        Highlighter h = host.getHighlighter();
        g.setFont(host.getFont());
        Rectangle clip = g.getClipBounds();
        Rectangle abounds = allocation.getBounds();
        int topLine = (clip.y - abounds.y) / this.metrics.getHeight();
        int bottomLine = (clip.y + clip.height - abounds.y) / this.metrics.getHeight();
        int maxLine = this.getElement().getElementCount() - 1;
        LayeredHighlighter layeredHighlighter = lh = h instanceof LayeredHighlighter ? (LayeredHighlighter)h : null;
        if (topLine > maxLine || bottomLine < 0) {
            return;
        }
        bottomLine = Math.min(bottomLine, maxLine);
        topLine = Math.max(topLine, 0);
        int mheight = this.metrics.getHeight();
        int ypos = abounds.y + topLine * mheight;
        int textBase = this.metrics.getAscent();
        g.setColor(this.getTextColor());
        g.setFont(host.getFont());
        for (int i = topLine; i <= bottomLine; ++i) {
            Element line = this.getElement().getElement(i);
            if (lh != null) {
                Rectangle lineClip = new Rectangle(abounds.x, ypos, abounds.width, mheight);
                Rectangle.intersect(lineClip, clip, lineClip);
                g.setClip(lineClip);
                lh.paintLayeredHighlights(g, line.getStartOffset(), line.getEndOffset() - 1, allocation, host, this);
            }
            this.drawLine(i, g, abounds.x + this.leftMargin, ypos + textBase);
            ypos += mheight;
        }
        g.setClip(clip);
    }

    protected Color getTextColor() {
        JTextComponent host = (JTextComponent)this.getContainer();
        return host.isEnabled() ? host.getForeground() : host.getDisabledTextColor();
    }

    protected void drawLine(int lineIndex, Graphics g, int x, int y) {
        try {
            Element line = this.getElement().getElement(lineIndex);
            this.getDocument().getText(line.getStartOffset(), line.getEndOffset() - line.getStartOffset(), this.segment);
            MoeTabExpander tx = new MoeTabExpander(this.tabSize, x);
            Utilities.drawTabbedText(this.segment, x, y, g, (TabExpander)tx, line.getStartOffset());
        }
        catch (BadLocationException ble) {
            throw new RuntimeException(ble);
        }
    }

    protected void checkMetrics() {
        Container host = this.getContainer();
        Font f = host.getFont();
        if (this.currentFont != f) {
            this.currentFont = f;
            this.metrics = this.getContainer().getFontMetrics(this.currentFont);
            this.longestLine = null;
            this.tabSize = this.getTabSize() * this.metrics.charWidth('m');
        }
    }

    protected int getLineWidth(Element line) {
        try {
            this.getDocument().getText(line.getStartOffset(), line.getEndOffset() - line.getStartOffset(), this.segment);
            MoeTabExpander tx = new MoeTabExpander(this.tabSize, this.leftMargin);
            int width = Utilities.getTabbedTextWidth(this.segment, this.metrics, this.leftMargin, (TabExpander)tx, line.getStartOffset());
            return width;
        }
        catch (BadLocationException ble) {
            throw new RuntimeException(ble);
        }
    }

    private Element getLongestLine() {
        if (this.longestLine == null) {
            this.determineLongestLine();
        }
        return this.longestLine;
    }

    private void determineLongestLine() {
        Element rootElement = this.getElement();
        int lineCount = rootElement.getElementCount();
        this.longestLine = null;
        int maxLineWidth = -1;
        for (int i = 0; i < lineCount; ++i) {
            Element line = rootElement.getElement(i);
            int lineWidth = this.getLineWidth(line);
            if (lineWidth <= maxLineWidth) continue;
            this.longestLine = line;
            maxLineWidth = lineWidth;
        }
    }

    protected int getTabSize() {
        Integer i = (Integer)this.getDocument().getProperty("tabSize");
        return i != null ? i : 8;
    }

    protected void damageLineRange(int line0, int line1, Shape a, Component host) {
        if (line1 < line0 || a == null) {
            return;
        }
        Rectangle abounds = a.getBounds();
        int rx = abounds.x;
        int ry = abounds.y + line0 * this.metrics.getHeight();
        int rw = abounds.width;
        int rh = (line1 - line0 + 1) * this.metrics.getHeight();
        host.repaint(rx, ry, rw, rh);
    }

    protected void updateDamage(DocumentEvent changes, Shape a, ViewFactory f) {
        Element[] removed;
        this.checkMetrics();
        Container host = this.getContainer();
        Element elem = this.getElement();
        DocumentEvent.ElementChange ec = changes.getChange(elem);
        Element[] added = ec != null ? ec.getChildrenAdded() : null;
        Element[] elementArray = removed = ec != null ? ec.getChildrenRemoved() : null;
        if (added != null && added.length > 0 || removed != null && removed.length > 0) {
            if (added != null && this.longestLine != null) {
                int currentMaxWidth = this.getLineWidth(this.longestLine);
                for (int i = 0; i < added.length; ++i) {
                    int width = this.getLineWidth(added[i]);
                    if (width <= currentMaxWidth) continue;
                    currentMaxWidth = width;
                    this.longestLine = added[i];
                }
            }
            if (removed != null) {
                for (int i = 0; i < removed.length; ++i) {
                    if (removed[i] != this.longestLine) continue;
                    this.longestLine = null;
                    break;
                }
            }
            this.preferenceChanged(null, true, true);
            host.repaint();
        } else {
            Element map = this.getElement();
            int line = map.getElementIndex(changes.getOffset());
            int endLine = map.getElementIndex(changes.getOffset() + changes.getLength());
            this.damageLineRange(line, endLine, a, host);
            this.getLongestLine();
            if (changes.getType() == DocumentEvent.EventType.INSERT) {
                int w = this.getLineWidth(this.longestLine);
                Element e = map.getElement(line);
                if (e == this.longestLine) {
                    this.preferenceChanged(null, true, false);
                } else if (this.getLineWidth(e) > w) {
                    this.longestLine = e;
                    this.preferenceChanged(null, true, false);
                }
            } else if (changes.getType() == DocumentEvent.EventType.REMOVE && map.getElement(line) == this.longestLine) {
                this.determineLongestLine();
                this.preferenceChanged(null, true, false);
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        this.updateDamage(changes, a, f);
    }

    @Override
    public void removeUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        this.updateDamage(changes, a, f);
    }

    @Override
    public void changedUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        this.updateDamage(changes, a, f);
    }

    protected static class MoeTabExpander
    implements TabExpander {
        private int tabSize;
        private int leftMargin;

        public MoeTabExpander(int tabSize, int leftMargin) {
            this.tabSize = tabSize;
            this.leftMargin = leftMargin;
        }

        @Override
        public float nextTabStop(float x, int tabOffset) {
            if (this.tabSize == 0) {
                return x;
            }
            int ntabs = ((int)x - this.leftMargin) / this.tabSize;
            return this.leftMargin + 0 + (ntabs + 1) * this.tabSize;
        }
    }
}

