/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.editor.moe.NVDrawPane;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParsedCUNode;
import bluej.parser.nodes.ParsedNode;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.ToolTipManager;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.View;

public class NaviView
extends JPanel
implements AdjustmentListener {
    private static final Image frame = Config.getFixedImageAsIcon((String)"naviview-frame.png").getImage();
    private static final int frw = 5;
    private Document document;
    private JEditorPane editorPane;
    private JScrollBar scrollBar;
    private int currentViewPos;
    private int currentViewPosBottom;
    private int dragOffset;
    private boolean haveToolTip = false;
    private BufferedImage imgBuffer;
    private int prefViewHeight;
    private List<Integer> tops = new ArrayList<Integer>();
    private List<Integer> bottoms = new ArrayList<Integer>();

    public NaviView(Document document, JScrollBar scrollBar) {
        this.scrollBar = scrollBar;
        this.editorPane = new NVDrawPane(this);
        this.setDocument(document);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.enableEvents(131072L);
        this.setFocusable(true);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void setDocument(Document document) {
        this.scrollBar.removeAdjustmentListener(this);
        this.document = document;
        this.editorPane.setDocument(document);
        this.scrollBar.addAdjustmentListener(this);
        this.documentChangedLength();
    }

    private Document getDocument() {
        return this.document;
    }

    public void documentChangedLength() {
        View view = this.editorPane.getUI().getRootView(this.editorPane);
        int newPrefHeight = (int)view.getPreferredSpan(1);
        Insets insets = this.getInsets();
        int yoffs = insets.top + 5;
        if (!this.scrollBar.isVisible()) {
            int rpHeight = Math.max(newPrefHeight, this.prefViewHeight) + yoffs + 5;
            this.repaint(0, 0, this.getWidth(), rpHeight);
        } else {
            this.repaint(0, Math.min(newPrefHeight, this.prefViewHeight) + yoffs, this.getWidth(), Math.abs(newPrefHeight - this.prefViewHeight) + 5);
        }
        this.prefViewHeight = newPrefHeight;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void setVisible(boolean flag) {
        if (!flag) {
            this.scrollBar.removeAdjustmentListener(this);
        } else if (!this.isVisible() && this.document != null) {
            this.scrollBar.addAdjustmentListener(this);
        }
        super.setVisible(flag);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.imgBuffer != null && this.isVisible() && width > 0) {
            Insets insets = this.getInsets();
            int myHeight = Math.max(this.getHeight() - insets.top - insets.bottom - 10, 1);
            this.createImgBuffer(this.imgBuffer.getGraphics(), this.prefViewHeight > myHeight);
        }
        this.enqueueRepaint(0, height);
        this.repaint();
    }

    private int yViewToDocument(int vpos) {
        View view = this.editorPane.getUI().getRootView(this.editorPane);
        Insets insets = this.getInsets();
        vpos -= insets.top + 5;
        int myHeight = Math.max(this.getHeight() - insets.top - insets.bottom - 10, 1);
        if (this.prefViewHeight > myHeight) {
            vpos = vpos * this.prefViewHeight / myHeight;
        }
        Position.Bias[] breturn = new Position.Bias[1];
        int pos = view.viewToModel(0.0f, vpos, new Rectangle(5, Integer.MAX_VALUE), breturn);
        return pos;
    }

    public void repaintModel(int top, int bottom) {
        if (this.editorPane == null || this.imgBuffer == null) {
            return;
        }
        Insets insets = this.getInsets();
        int myHeight = Math.max(this.getHeight() - insets.top - insets.bottom - 10, 1);
        if (this.prefViewHeight > myHeight) {
            int ptop = top * myHeight / this.prefViewHeight;
            int pbottom = (bottom * myHeight + this.prefViewHeight - 1) / this.prefViewHeight;
            this.enqueueRepaint(ptop, pbottom);
        } else {
            this.enqueueRepaint(top, bottom);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        Insets insets = this.getInsets();
        int height = Math.min(this.prefViewHeight, this.getHeight() - insets.top - insets.bottom - 10);
        int topV = e.getValue() * height / this.scrollBar.getMaximum() + insets.top + 5;
        int bottomV = (e.getValue() + this.scrollBar.getVisibleAmount()) * height / this.scrollBar.getMaximum() + insets.top + 5;
        this.repaint(0, topV - 5, this.getWidth(), bottomV - topV + 2 + 10);
        this.repaint(0, this.currentViewPos - 5, this.getWidth(), this.currentViewPosBottom - this.currentViewPos + 2 + 10);
        this.currentViewPos = topV;
        this.currentViewPosBottom = bottomV;
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        if (this.haveToolTip) {
            Point ttloc = event.getPoint();
            ttloc.y += 15;
            ttloc.x -= 20;
            return ttloc;
        }
        return null;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int pos = this.yViewToDocument(event.getPoint().y);
        MoeSyntaxDocument document = (MoeSyntaxDocument)((Object)this.getDocument());
        ParsedCUNode pn = document.getParser();
        int startpos = 0;
        while (pn != null) {
            if (pn.getNodeType() == 2) {
                this.haveToolTip = true;
                return pn.getName();
            }
            NodeTree.NodeAndPosition nap = pn.findNodeAtOrAfter(pos, startpos);
            if (nap == null || nap.getPosition() > pos) break;
            pn = (ParsedNode)nap.getNode();
            startpos = nap.getPosition();
        }
        this.haveToolTip = false;
        return null;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            int y = e.getY();
            if (y > this.currentViewPos && y < this.currentViewPosBottom) {
                this.dragOffset = y - this.currentViewPos;
            } else {
                this.dragOffset = (this.currentViewPosBottom - this.currentViewPos) / 2;
                this.moveView(e.getY());
            }
        } else {
            super.processMouseEvent(e);
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if (e.getID() == 506) {
            this.moveView(e.getY());
        } else {
            super.processMouseMotionEvent(e);
        }
    }

    @Override
    protected void processMouseWheelEvent(MouseWheelEvent e) {
        if (e.getID() == 507) {
            this.scrollBar.dispatchEvent(e);
        }
    }

    private void moveView(int ypos) {
        int modelPos = this.yViewToDocument(ypos - this.dragOffset);
        int lineNum = this.getDocument().getDefaultRootElement().getElementIndex(modelPos);
        lineNum = Math.max(0, lineNum);
        int totalLines = this.getDocument().getDefaultRootElement().getElementCount();
        int totalAmt = this.scrollBar.getMaximum() - this.scrollBar.getMinimum();
        int pos = lineNum * totalAmt / totalLines + this.scrollBar.getMinimum();
        this.scrollBar.setValue(pos);
    }

    private void paintImgBuffer(int top, int bottom) {
        int myHeight = this.imgBuffer.getHeight();
        View view = this.editorPane.getUI().getRootView(this.editorPane);
        Color background = MoeSyntaxDocument.getBackgroundColor();
        Graphics2D g = this.imgBuffer.createGraphics();
        if (this.prefViewHeight > myHeight) {
            int width = Math.max(this.imgBuffer.getWidth() * this.prefViewHeight / myHeight, 1);
            int ybtm = (bottom * this.prefViewHeight + myHeight - 1) / myHeight;
            int ytop = top * this.prefViewHeight / myHeight;
            int height = ybtm - ytop;
            if (height > 400) {
                height = 400;
                ybtm = ytop + 400;
                int newbottom = top + height * myHeight / this.prefViewHeight;
                if (newbottom <= top) {
                    newbottom = top + 1;
                    ybtm = (newbottom * this.prefViewHeight + myHeight - 1) / myHeight;
                    height = ybtm - ytop;
                }
                this.enqueueRepaint(newbottom, bottom);
                bottom = newbottom;
            }
            if (height < 1) {
                height = 1;
                ybtm = ytop + 1;
                bottom = top + height * myHeight / this.prefViewHeight;
            }
            BufferedImage bimage = g.getDeviceConfiguration().createCompatibleImage(width, height, 3);
            HashMap<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
            hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.addRenderingHints(hints);
            g.setColor(background);
            g.fillRect(0, top, this.imgBuffer.getWidth(), bottom - top);
            Graphics2D bg = bimage.createGraphics();
            Rectangle shape = new Rectangle(5, 5, width, this.prefViewHeight);
            bg.setClip(0, 0, width, height);
            bg.translate(-5, -ytop - 5);
            view.paint(bg, shape);
            g.drawImage(bimage, 0, top, this.imgBuffer.getWidth(), bottom, 0, 0, width, height, null);
            bg.dispose();
        } else {
            int w = this.imgBuffer.getWidth();
            int h = myHeight;
            Rectangle rb = new Rectangle();
            rb.x = 0;
            rb.y = Math.max(0, top);
            rb.width = this.imgBuffer.getWidth();
            rb.height = bottom - top;
            g.setClip(rb);
            g.setColor(background);
            g.fillRect(rb.x, rb.y, rb.width, rb.height);
            g.translate(-5, -5);
            Rectangle bufferBounds = new Rectangle(5, 5, w, h);
            view.paint(g, bufferBounds);
        }
        g.dispose();
    }

    private void enqueueRepaint(int top, int bottom) {
        ListIterator<Integer> i = this.tops.listIterator();
        ListIterator<Integer> j = this.bottoms.listIterator();
        if (!i.hasNext()) {
            Insets insets = this.getInsets();
            this.repaint(insets.left + 5, insets.top + 5 + top, this.getWidth() - insets.left - insets.right - 10, bottom - top);
        }
        while (i.hasNext()) {
            int etop = i.next();
            int ebtm = j.next();
            if (top < etop) {
                if (bottom > ebtm) {
                    i.remove();
                    j.remove();
                    continue;
                }
                bottom = Math.min(bottom, etop);
                continue;
            }
            if (bottom > ebtm) {
                top = Math.max(top, ebtm);
                continue;
            }
            return;
        }
        this.tops.add(top);
        this.bottoms.add(bottom);
    }

    @Override
    protected void paintComponent(Graphics g) {
        int docBottom;
        Rectangle clipBounds = new Rectangle(new Point(0, 0), this.getSize());
        Insets insets = this.getInsets();
        g.getClipBounds(clipBounds);
        int myHeight = Math.max(this.getHeight() - insets.top - insets.bottom - 10, 1);
        Document document = this.getDocument();
        if (document == null) {
            return;
        }
        int docHeight = Math.min(myHeight, this.prefViewHeight);
        int topV = insets.top + 5 + this.scrollBar.getValue() * docHeight / this.scrollBar.getMaximum();
        int bottomV = insets.top + 5 + ((this.scrollBar.getValue() + this.scrollBar.getVisibleAmount()) * docHeight + (this.scrollBar.getMaximum() - 1)) / this.scrollBar.getMaximum();
        this.createImgBuffer(g, this.prefViewHeight > myHeight);
        if (!this.tops.isEmpty()) {
            int rtop = this.tops.remove(0);
            int rbottom = this.bottoms.remove(0);
            this.paintImgBuffer(rtop, rbottom);
        }
        g.drawImage(this.imgBuffer, insets.left + 5, insets.top + 5, null);
        Color background = MoeSyntaxDocument.getBackgroundColor();
        int lx = insets.left;
        int rx = this.getWidth() - insets.right;
        int ty = insets.top;
        g.setColor(background);
        g.fillRect(lx, ty, rx - lx, 5);
        g.fillRect(lx, ty, 5, docHeight + 5);
        g.fillRect(rx - 5, ty, 5, docHeight + 5);
        g.setColor(this.getBackground());
        g.fillRect(lx, docHeight + 5 + insets.top, rx - lx, myHeight - docHeight + 5);
        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.15f));
        if (topV > clipBounds.y) {
            g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, topV - clipBounds.y);
        }
        if (bottomV < (docBottom = docHeight + 5 + insets.top)) {
            g.fillRect(clipBounds.x, bottomV, clipBounds.width, docBottom - bottomV);
        }
        if (docBottom < clipBounds.y + clipBounds.height) {
            Color myBgColor = this.getBackground();
            g.setColor(new Color(myBgColor.getRGB()));
            g.fillRect(clipBounds.x, docBottom, clipBounds.width, clipBounds.y + clipBounds.height - docBottom);
        }
        int fx1 = lx;
        int fy1 = topV - 5;
        int fx2 = rx;
        int fy2 = bottomV;
        int fh = frame.getHeight(null);
        int fw = frame.getWidth(null);
        g.drawImage(frame, fx1, fy1, fx1 + 5, fy1 + 5, 0, 0, 5, 5, null);
        g.drawImage(frame, fx1 + 5, fy1, fx2 - 5, fy1 + 5, 5, 0, fw - 5, 5, null);
        g.drawImage(frame, fx2 - 5, fy1, fx2, fy1 + 5, fw - 5, 0, fw, 5, null);
        g.drawImage(frame, fx1, fy1 + 5, fx1 + 5, fy2, 0, 5, 5, fh - 5, null);
        g.drawImage(frame, fx2 - 5, fy1 + 5, fx2, fy2, fw - 5, 5, fw, fh - 5, null);
        g.drawImage(frame, fx1, fy2, fx1 + 5, fy2 + 5, 0, fh - 5, 5, fh, null);
        g.drawImage(frame, fx1 + 5, fy2, fx2 - 5, fy2 + 5, 5, fh - 5, fw - 5, fh, null);
        g.drawImage(frame, fx2 - 5, fy2, fx2, fy2 + 5, fw - 5, fh - 5, fw, fh, null);
        if (!this.tops.isEmpty()) {
            int rtop = this.tops.get(0);
            int rbottom = this.bottoms.get(0);
            this.repaint(0, rtop, this.getWidth(), rbottom - rtop);
        }
    }

    public void createImgBuffer(Graphics g, boolean scaling) {
        Graphics2D g2d;
        Insets insets = this.getInsets();
        int w = Math.max(this.getWidth() - insets.left - insets.right - 10, 1);
        int h = Math.max(this.getHeight() - insets.top - insets.bottom - 10, 1);
        if (this.imgBuffer != null && this.imgBuffer.getHeight() == h && this.imgBuffer.getWidth() == w) {
            return;
        }
        BufferedImage oldImgBuffer = this.imgBuffer;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            this.imgBuffer = g2d.getDeviceConfiguration().createCompatibleImage(w, h);
        } else {
            this.imgBuffer = new BufferedImage(w, h, 5);
        }
        g2d = this.imgBuffer.createGraphics();
        if (oldImgBuffer == null) {
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, this.imgBuffer.getWidth(), this.imgBuffer.getHeight());
            this.paintImgBuffer(0, this.imgBuffer.getHeight());
        } else if (!scaling) {
            g2d.drawImage((Image)oldImgBuffer, 0, 0, null);
            this.paintImgBuffer(oldImgBuffer.getHeight(), this.imgBuffer.getHeight());
        } else {
            g2d.drawImage(oldImgBuffer, 0, 0, this.imgBuffer.getWidth(), this.imgBuffer.getHeight(), 0, 0, oldImgBuffer.getWidth(), oldImgBuffer.getHeight(), null);
            this.paintImgBuffer(0, this.imgBuffer.getHeight());
        }
        g2d.dispose();
    }

    public Graphics2D getScalingImgBufferGraphics(Graphics g) {
        Insets insets = this.getInsets();
        int myHeight = Math.max(this.getHeight() - insets.top - insets.bottom - 10, 1);
        this.createImgBuffer(g, this.prefViewHeight > myHeight);
        Graphics2D r = this.imgBuffer.createGraphics();
        if (this.prefViewHeight > myHeight) {
            double scaleFactor = (double)myHeight / (double)this.prefViewHeight;
            r.scale(scaleFactor, scaleFactor);
        }
        r.translate(-5, -5);
        return r;
    }
}

