/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.BlueJSyntaxView;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.prefmgr.PrefMgr;
import java.awt.Color;
import java.awt.GridLayout;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ScopeHighlightingPrefDisplay
implements ChangeListener {
    public static final int MIN = 0;
    public static final int MAX = 20;
    JSlider slider;
    JPanel colorPanel;
    JPanel greenPanelArea;
    JPanel yellowPanelArea;
    JPanel pinkPanelArea;
    JPanel bluePanelArea;
    Color greenArea = BlueJSyntaxView.GREEN_BASE;
    Color pinkArea = BlueJSyntaxView.PINK_BASE;
    Color yellowArea = BlueJSyntaxView.YELLOW_BASE;
    Color blueArea = BlueJSyntaxView.BLUE_BASE;
    Color greenBorder = BlueJSyntaxView.GREEN_OUTER_BASE;
    Color pinkBorder = BlueJSyntaxView.PINK_OUTER_BASE;
    Color yellowBorder = BlueJSyntaxView.YELLOW_OUTER_BASE;
    Color blueBorder = BlueJSyntaxView.BLUE_OUTER_BASE;
    Color greenSetting;
    Color greenSettingBorder;
    Color yellowSetting;
    Color yellowSettingBorder;
    Color pinkSetting;
    Color pinkSettingBorder;
    Color blueSetting;
    Color blueSettingBorder;
    Color bg;

    public ScopeHighlightingPrefDisplay() {
        MoeSyntaxDocument.getColors();
        this.bg = MoeSyntaxDocument.getBackgroundColor();
        this.slider = new JSlider(0, 20);
        this.slider.setValue(PrefMgr.getScopeHighlightStrength());
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(0), new JLabel(Config.getString((String)"prefmgr.edit.highlightLighter")));
        labelTable.put(new Integer(20), new JLabel(Config.getString((String)"prefmgr.edit.highlightDarker")));
        this.slider.setLabelTable(labelTable);
        this.slider.setPaintLabels(true);
        this.slider.addChangeListener(this);
        this.colorPanel = new JPanel(new GridLayout(4, 1, 0, 0));
        this.colorPanel.setBorder(BorderFactory.createLineBorder(this.bg, 10));
        this.colorPanel.setBackground(this.bg);
        this.greenPanelArea = new JPanel();
        this.yellowPanelArea = new JPanel();
        this.pinkPanelArea = new JPanel();
        this.bluePanelArea = new JPanel();
        this.setPaletteValues();
        this.colorPanel.add(this.greenPanelArea);
        this.colorPanel.add(this.yellowPanelArea);
        this.colorPanel.add(this.pinkPanelArea);
        this.colorPanel.add(this.bluePanelArea);
    }

    protected JSlider getHighlightStrengthSlider() {
        return this.slider;
    }

    protected JPanel getColourPalette() {
        return this.colorPanel;
    }

    protected int getStrengthValue() {
        return this.slider.getValue();
    }

    private Color getReducedColor(Color c) {
        return BlueJSyntaxView.getReducedColor(c.getRed(), c.getGreen(), c.getBlue(), this.getStrengthValue());
    }

    protected void setGreenPalette() {
        this.greenSetting = this.getReducedColor(this.greenArea);
        this.greenPanelArea.setBackground(this.greenSetting);
        this.greenSettingBorder = this.getReducedColor(this.greenBorder);
        this.greenPanelArea.setBorder(BorderFactory.createLineBorder(this.greenSettingBorder));
    }

    protected void setYellowPalette() {
        this.yellowSetting = this.getReducedColor(this.yellowArea);
        this.yellowPanelArea.setBackground(this.yellowSetting);
        this.yellowSettingBorder = this.getReducedColor(this.yellowBorder);
        this.yellowPanelArea.setBorder(BorderFactory.createLineBorder(this.yellowSettingBorder));
    }

    protected void setPinkPalette() {
        this.pinkSetting = this.getReducedColor(this.pinkArea);
        this.pinkPanelArea.setBackground(this.pinkSetting);
        this.pinkSettingBorder = this.getReducedColor(this.pinkBorder);
        this.pinkPanelArea.setBorder(BorderFactory.createLineBorder(this.pinkSettingBorder));
    }

    protected void setBluePalette() {
        this.blueSetting = this.getReducedColor(this.blueArea);
        this.bluePanelArea.setBackground(this.blueSetting);
        this.blueSettingBorder = this.getReducedColor(this.blueBorder);
        this.bluePanelArea.setBorder(BorderFactory.createLineBorder(this.blueSettingBorder));
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setPaletteValues();
    }

    private void setPaletteValues() {
        this.setGreenPalette();
        this.setYellowPalette();
        this.setBluePalette();
        this.setPinkPalette();
    }
}

