/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter;

import bluej.extensions.PreferenceGenerator;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.bluej.extensions.submitter.Stat;

public class PrefPanel
implements PreferenceGenerator,
ActionListener {
    private Stat stat;
    private JPanel thePanel;
    private JTextField host;
    private JTextField sender;
    private JTextField user;
    private JTextField port;
    private JTextField authUser;
    private JRadioButton sslConnection;
    private JRadioButton tlsConnection;
    private JRadioButton insecureConnection;
    private JCheckBox auth;
    private String authString;
    private String sslString;
    private String tlsString;
    private String noSecString;
    private String smtpDetailsString;
    private JLabel hostLabel;
    private JLabel senderLabel;
    private JLabel userLabel;
    private JLabel portLabel;
    private JLabel secConnLabel;
    private JLabel defaultPortLabel;
    private JLabel authUserLabel;
    private static final String DEFAULT_PORT = "25";

    public PrefPanel(Stat i_stat) {
        this.stat = i_stat;
        this.setLanguageDependentLabels();
        this.thePanel = new JPanel();
        this.thePanel.setLayout(new BoxLayout(this.thePanel, 3));
        Box topBox = new Box(2);
        Box labelsBox = new Box(3);
        labelsBox.add(this.userLabel);
        labelsBox.add(Box.createRigidArea(new Dimension(0, 5)));
        labelsBox.add(this.senderLabel);
        this.senderLabel.setAlignmentX(1.0f);
        this.userLabel.setAlignmentX(1.0f);
        Box fieldsBox = new Box(3);
        this.user = new JTextField();
        fieldsBox.add(this.user);
        fieldsBox.add(Box.createRigidArea(new Dimension(0, 2)));
        this.sender = new JTextField();
        fieldsBox.add(this.sender);
        topBox.add(labelsBox);
        topBox.add(fieldsBox);
        Box smtpDetails = new Box(3);
        Box rowOne = new Box(2);
        rowOne.add(this.hostLabel);
        this.host = new JTextField();
        rowOne.add(this.host);
        rowOne.add(Box.createRigidArea(new Dimension(15, 0)));
        rowOne.add(this.portLabel);
        this.port = new JTextField();
        rowOne.add(this.port);
        this.port.setMaximumSize(new Dimension(40, 20));
        this.port.setPreferredSize(new Dimension(40, 20));
        rowOne.add(Box.createRigidArea(new Dimension(8, 0)));
        rowOne.add(this.defaultPortLabel);
        rowOne.add(Box.createRigidArea(new Dimension(8, 0)));
        Box rowTwo = new Box(2);
        this.auth = new JCheckBox(this.authString);
        rowTwo.add(this.auth);
        rowTwo.add(Box.createRigidArea(new Dimension(15, 0)));
        rowTwo.add(this.authUserLabel);
        this.authUser = new JTextField();
        rowTwo.add(this.authUser);
        Box rowThree = new Box(2);
        rowThree.add(this.secConnLabel);
        rowThree.add(Box.createRigidArea(new Dimension(10, 0)));
        this.insecureConnection = new JRadioButton(this.noSecString);
        rowThree.add(this.insecureConnection);
        rowThree.add(Box.createRigidArea(new Dimension(30, 0)));
        this.sslConnection = new JRadioButton(this.sslString);
        rowThree.add(this.sslConnection);
        rowThree.add(Box.createRigidArea(new Dimension(30, 0)));
        this.tlsConnection = new JRadioButton(this.tlsString);
        rowThree.add(this.tlsConnection);
        boolean b = !this.sslConnection.isSelected() && !this.tlsConnection.isSelected();
        this.insecureConnection.setSelected(b);
        ButtonGroup btg = new ButtonGroup();
        btg.add(this.insecureConnection);
        btg.add(this.sslConnection);
        btg.add(this.tlsConnection);
        smtpDetails.add(rowOne);
        smtpDetails.add(Box.createRigidArea(new Dimension(0, 4)));
        smtpDetails.add(rowTwo);
        smtpDetails.add(rowThree);
        smtpDetails.setBorder(new TitledBorder(this.smtpDetailsString));
        rowOne.setAlignmentX(0.0f);
        rowTwo.setAlignmentX(0.0f);
        rowThree.setAlignmentX(0.0f);
        topBox.setAlignmentX(0.0f);
        smtpDetails.setAlignmentX(0.0f);
        this.thePanel.add(topBox);
        this.thePanel.add(smtpDetails);
        this.sslConnection.addActionListener(this);
        this.auth.addActionListener(this);
        this.port.addActionListener(this);
        this.loadValues();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JCheckBox) {
            this.authUserLabel.setEnabled(this.auth.isSelected());
            this.authUser.setEnabled(this.auth.isSelected());
        } else if (e.getSource() instanceof JRadioButton) {
            if (this.sslConnection.isSelected()) {
                this.port.setText("465");
            }
        } else if (this.port.getText().trim().equals("")) {
            this.port.setText(DEFAULT_PORT);
        }
    }

    public JPanel getPanel() {
        return this.thePanel;
    }

    public void saveValues() {
        if (this.port.getText().trim().equals("")) {
            this.port.setText(DEFAULT_PORT);
        }
        this.saveOneValue("smtphost", this.host.getText());
        this.saveOneValue("useraddr", this.sender.getText());
        this.saveOneValue("username", this.user.getText());
        this.saveOneValue("port", this.port.getText());
        this.saveOneValue("authenticate", Boolean.toString(this.auth.isSelected()));
        this.saveOneValue("smtpauthuser", this.authUser.getText());
        this.saveOneValue("ssl", Boolean.toString(this.sslConnection.isSelected()));
        this.saveOneValue("tls", Boolean.toString(this.tlsConnection.isSelected()));
    }

    private void saveOneValue(String propKey, String propVal) {
        this.stat.bluej.setExtensionPropertyString(propKey, propVal);
        this.stat.globalProp.setProperty(propKey, propVal);
    }

    public void loadValues() {
        String saslRealm;
        String propVal = this.stat.bluej.getExtensionPropertyString("smtphost", "");
        this.host.setText(propVal);
        this.stat.globalProp.setProperty("smtphost", propVal);
        propVal = this.stat.bluej.getExtensionPropertyString("useraddr", System.getProperty("user.name", "") + "@");
        this.sender.setText(propVal);
        this.stat.globalProp.setProperty("useraddr", propVal);
        propVal = this.stat.bluej.getExtensionPropertyString("username", System.getProperty("user.name", ""));
        this.user.setText(propVal);
        this.stat.globalProp.setProperty("username", propVal);
        propVal = this.stat.bluej.getExtensionPropertyString("port", DEFAULT_PORT);
        this.port.setText(propVal.trim());
        this.stat.globalProp.setProperty("port", propVal);
        propVal = this.stat.bluej.getExtensionPropertyString("authenticate", "false");
        this.auth.setSelected(new Boolean(propVal));
        this.stat.globalProp.setProperty("authenticate", propVal);
        propVal = this.stat.bluej.getExtensionPropertyString("smtpauthuser", System.getProperty("user.name", ""));
        this.authUser.setText(propVal);
        this.stat.globalProp.setProperty("smtpauthuser", propVal);
        propVal = this.stat.bluej.getExtensionPropertyString("ssl", "false");
        this.sslConnection.setSelected(new Boolean(propVal));
        this.stat.globalProp.setProperty("ssl", propVal);
        propVal = this.stat.bluej.getExtensionPropertyString("tls", "false");
        this.tlsConnection.setSelected(new Boolean(propVal));
        this.stat.globalProp.setProperty("tls", propVal);
        this.authUserLabel.setEnabled(this.auth.isSelected());
        this.authUser.setEnabled(this.auth.isSelected());
        if (this.port.getText().equals("")) {
            this.port.setText(DEFAULT_PORT);
        }
        if ((saslRealm = this.stat.bluej.getExtensionPropertyString("saslrealm", "invalid.bluej.org")).equals("invalid.bluej.org")) {
            this.stat.bluej.setExtensionPropertyString("saslrealm", "");
        }
    }

    private void setLanguageDependentLabels() {
        String s = "preferences.label.";
        this.hostLabel = new JLabel(this.stat.bluej.getLabel(s + "smtphost") + ": ");
        this.senderLabel = new JLabel(this.stat.bluej.getLabel(s + "useraddr") + ": ");
        this.userLabel = new JLabel(this.stat.bluej.getLabel(s + "username") + ": ");
        this.portLabel = new JLabel(this.stat.bluej.getLabel(s + "port") + ": ");
        this.authUserLabel = new JLabel(this.stat.bluej.getLabel(s + "smtpauthuser") + ": ");
        this.secConnLabel = new JLabel(this.stat.bluej.getLabel("preferences.label.connection") + ": ");
        this.defaultPortLabel = new JLabel(this.stat.bluej.getLabel(s + "default") + ": " + DEFAULT_PORT);
        this.authString = this.stat.bluej.getLabel(s + "authenticate");
        this.sslString = this.stat.bluej.getLabel(s + "ssl");
        this.tlsString = this.stat.bluej.getLabel(s + "tls");
        this.noSecString = this.stat.bluej.getLabel("preferences.label.insecureconnection");
        this.smtpDetailsString = this.stat.bluej.getLabel("preferences.label.smtpdetailstitle");
    }
}

