/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.sensor.impl;

import com.pi4j.component.sensor.Sensor;
import com.pi4j.component.sensor.SensorBase;
import com.pi4j.component.sensor.SensorState;
import com.pi4j.component.sensor.SensorStateChangeEvent;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;

public class GpioSensorComponent
extends SensorBase {
    private GpioPinDigitalInput pin = null;
    private PinState openState = PinState.LOW;
    private PinState closedState = PinState.HIGH;
    private final Sensor sensor = this;
    private GpioPinListenerDigital pinListener = new GpioPinListenerDigital(){

        public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
            if (event.getState() == GpioSensorComponent.this.openState) {
                GpioSensorComponent.this.notifyListeners(new SensorStateChangeEvent(GpioSensorComponent.this.sensor, SensorState.CLOSED, SensorState.OPEN));
            } else if (event.getState() == GpioSensorComponent.this.closedState) {
                GpioSensorComponent.this.notifyListeners(new SensorStateChangeEvent(GpioSensorComponent.this.sensor, SensorState.OPEN, SensorState.CLOSED));
            }
        }
    };

    public GpioSensorComponent(GpioPinDigitalInput pin, PinState openState, PinState closedState) {
        this(pin);
        this.openState = openState;
        this.closedState = closedState;
    }

    public GpioSensorComponent(GpioPinDigitalInput pin) {
        this.pin = pin;
        this.pin.addListener(new GpioPinListener[]{this.pinListener});
    }

    @Override
    public SensorState getState() {
        if (this.pin.isState(this.openState)) {
            return SensorState.OPEN;
        }
        return SensorState.CLOSED;
    }
}

