/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.switches.impl;

import com.pi4j.component.switches.MomentarySwitch;
import com.pi4j.component.switches.MomentarySwitchBase;
import com.pi4j.component.switches.SwitchState;
import com.pi4j.component.switches.SwitchStateChangeEvent;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;

public class GpioMomentarySwitchComponent
extends MomentarySwitchBase {
    private GpioPinDigitalInput pin = null;
    private PinState offState = PinState.LOW;
    private PinState onState = PinState.HIGH;
    private final MomentarySwitch switchComponent = this;
    private GpioPinListenerDigital pinListener = new GpioPinListenerDigital(){

        public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
            if (event.getState() == GpioMomentarySwitchComponent.this.onState) {
                GpioMomentarySwitchComponent.this.notifyListeners(new SwitchStateChangeEvent(GpioMomentarySwitchComponent.this.switchComponent, SwitchState.OFF, SwitchState.ON));
            } else if (event.getState() == GpioMomentarySwitchComponent.this.offState) {
                GpioMomentarySwitchComponent.this.notifyListeners(new SwitchStateChangeEvent(GpioMomentarySwitchComponent.this.switchComponent, SwitchState.ON, SwitchState.OFF));
            }
        }
    };

    public GpioMomentarySwitchComponent(GpioPinDigitalInput pin, PinState offState, PinState onState) {
        this.pin = pin;
        this.onState = onState;
        this.offState = offState;
        this.pin.addListener(new GpioPinListener[]{this.pinListener});
    }

    public GpioMomentarySwitchComponent(GpioPinDigitalInput pin) {
        this.pin = pin;
        this.pin.addListener(new GpioPinListener[]{this.pinListener});
    }

    @Override
    public SwitchState getState() {
        if (this.pin.isState(this.onState)) {
            return SwitchState.ON;
        }
        return SwitchState.OFF;
    }
}

