/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.switches.impl;

import com.pi4j.component.switches.Switch;
import com.pi4j.component.switches.SwitchBase;
import com.pi4j.component.switches.SwitchState;
import com.pi4j.component.switches.SwitchStateChangeEvent;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;

public class GpioSwitchComponent
extends SwitchBase {
    private GpioPinDigitalInput pin = null;
    private PinState offState = PinState.LOW;
    private PinState onState = PinState.HIGH;
    private final Switch switchComponent = this;
    private GpioPinListenerDigital pinListener = new GpioPinListenerDigital(){

        public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
            if (event.getState() == GpioSwitchComponent.this.onState) {
                GpioSwitchComponent.this.notifyListeners(new SwitchStateChangeEvent(GpioSwitchComponent.this.switchComponent, SwitchState.OFF, SwitchState.ON));
            } else if (event.getState() == GpioSwitchComponent.this.offState) {
                GpioSwitchComponent.this.notifyListeners(new SwitchStateChangeEvent(GpioSwitchComponent.this.switchComponent, SwitchState.ON, SwitchState.OFF));
            }
        }
    };

    public GpioSwitchComponent(GpioPinDigitalInput pin, PinState offState, PinState onState) {
        this.pin = pin;
        this.onState = onState;
        this.offState = offState;
        this.pin.addListener(new GpioPinListener[]{this.pinListener});
    }

    public GpioSwitchComponent(GpioPinDigitalInput pin) {
        this.pin = pin;
        this.pin.addListener(new GpioPinListener[]{this.pinListener});
    }

    @Override
    public SwitchState getState() {
        if (this.pin.isState(this.onState)) {
            return SwitchState.ON;
        }
        return SwitchState.OFF;
    }
}

