/*
 * Decompiled with CFR 0.152.
 */
package bluej.doclet.doclets.formats.html.markup;

import bluej.doclet.doclets.formats.html.markup.HtmlWriter;
import bluej.doclet.doclets.internal.toolkit.Configuration;
import com.sun.javadoc.ClassDoc;
import java.io.File;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public abstract class HtmlDocWriter
extends HtmlWriter {
    public HtmlDocWriter(Configuration configuration, String filename) throws IOException {
        super(configuration, null, configuration.destDirName + filename, configuration.docencoding);
        configuration.message.notice("doclet.Generating_0", new File(configuration.destDirName, filename));
    }

    public HtmlDocWriter(Configuration configuration, String path, String filename) throws IOException {
        super(configuration, configuration.destDirName + path, filename, configuration.docencoding);
        configuration.message.notice("doclet.Generating_0", new File(configuration.destDirName, (path.length() > 0 ? path + File.separator : "") + filename));
    }

    public abstract Configuration configuration();

    public void printHyperLink(String link, String where, String label, boolean bold) {
        this.print(this.getHyperLink(link, where, label, bold, "", "", ""));
    }

    public void printHyperLink(String link, String where, String label) {
        this.printHyperLink(link, where, label, false);
    }

    public void printHyperLink(String link, String where, String label, boolean bold, String stylename) {
        this.print(this.getHyperLink(link, where, label, bold, stylename, "", ""));
    }

    public String getHyperLink(String link, String where, String label, boolean bold) {
        return this.getHyperLink(link, where, label, bold, "", "", "");
    }

    public String getHyperLink(String link, String where, String label, boolean bold, String stylename) {
        return this.getHyperLink(link, where, label, bold, stylename, "", "");
    }

    public String getHyperLink(String link, String where, String label, boolean bold, String stylename, String title, String target) {
        StringBuffer retlink = new StringBuffer();
        retlink.append("<A HREF=\"");
        retlink.append(link);
        if (where != null && where.length() != 0) {
            retlink.append("#");
            retlink.append(where);
        }
        retlink.append("\"");
        if (title != null && title.length() != 0) {
            retlink.append(" title=\"" + title + "\"");
        }
        if (target != null && target.length() != 0) {
            retlink.append(" target=\"" + target + "\"");
        }
        retlink.append(">");
        if (stylename != null && stylename.length() != 0) {
            retlink.append("<FONT CLASS=\"");
            retlink.append(stylename);
            retlink.append("\">");
        }
        if (bold) {
            retlink.append("<B>");
        }
        retlink.append(label);
        if (bold) {
            retlink.append("</B>");
        }
        if (stylename != null && stylename.length() != 0) {
            retlink.append("</FONT>");
        }
        retlink.append("</A>");
        return retlink.toString();
    }

    public void printHyperLink(String link, String label) {
        this.print(this.getHyperLink(link, "", label, false));
    }

    public String getHyperLink(String link, String label) {
        return this.getHyperLink(link, "", label, false);
    }

    public void printPkgName(ClassDoc cd) {
        this.print(this.getPkgName(cd));
    }

    public String getPkgName(ClassDoc cd) {
        String pkgName = cd.containingPackage().name();
        if (pkgName.length() > 0) {
            pkgName = pkgName + ".";
            return pkgName;
        }
        return "";
    }

    public void printFramesetHeader(String title) {
        this.printFramesetHeader(title, false);
    }

    public void printFramesetHeader(String title, boolean noTimeStamp) {
        this.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\" \"http://www.w3.org/TR/html4/frameset.dtd\">");
        this.println("<!--NewPage-->");
        this.html();
        this.head();
        if (!noTimeStamp) {
            this.print("<!-- Generated by javadoc on ");
            this.print(this.today());
            this.println("-->");
        }
        if (this.configuration.charset.length() > 0) {
            this.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=" + this.configuration.charset + "\">");
        }
        this.title();
        this.println(title);
        this.titleEnd();
        this.script();
        this.println("    targetPage = \"\" + window.location.search;");
        this.println("    if (targetPage != \"\" && targetPage != \"undefined\")");
        this.println("        targetPage = targetPage.substring(1);");
        this.println("    if (targetPage.indexOf(\":\") != -1)");
        this.println("        targetPage = \"undefined\";");
        this.println("    function loadFrames() {");
        this.println("        if (targetPage != \"\" && targetPage != \"undefined\")");
        this.println("             top.classFrame.location = top.targetPage;");
        this.println("    }");
        this.scriptEnd();
        this.noScript();
        this.noScriptEnd();
        this.headEnd();
    }

    public String spaces(int len) {
        String space = "";
        for (int i = 0; i < len; ++i) {
            space = space + " ";
        }
        return space;
    }

    public void printBodyHtmlEnd() {
        this.println();
        this.bodyEnd();
        this.htmlEnd();
    }

    public void printFooter() {
        this.printBodyHtmlEnd();
    }

    public void printFrameFooter() {
        this.htmlEnd();
    }

    public void printNbsps() {
        this.print("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
    }

    public String today() {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getDefault());
        return calendar.getTime().toString();
    }
}

