/*
 * Decompiled with CFR 0.152.
 */
package bluej.doclet.doclets.internal.toolkit.util;

import bluej.doclet.doclets.internal.toolkit.Configuration;
import bluej.doclet.doclets.internal.toolkit.util.DirectoryManager;
import bluej.doclet.doclets.internal.toolkit.util.DocletConstants;
import bluej.doclet.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.StringTokenizer;

public class SourceToHTMLConverter {
    protected static final String BGCOLOR = "white";
    protected static final String LINE_NO_COLOR = "green";
    protected static final int NUM_BLANK_LINES = 60;

    private SourceToHTMLConverter() {
    }

    public static void convertRoot(Configuration configuration, RootDoc rd, String outputdir) {
        if (rd == null || outputdir == null) {
            return;
        }
        PackageDoc[] pds = rd.specifiedPackages();
        for (int i = 0; i < pds.length; ++i) {
            SourceToHTMLConverter.convertPackage(configuration, pds[i], outputdir);
        }
        ClassDoc[] cds = rd.specifiedClasses();
        for (int i = 0; i < cds.length; ++i) {
            SourceToHTMLConverter.convertClass(configuration, cds[i], SourceToHTMLConverter.getPackageOutputDir(outputdir, cds[i].containingPackage()));
        }
    }

    public static void convertPackage(Configuration configuration, PackageDoc pd, String outputdir) {
        if (pd == null || outputdir == null) {
            return;
        }
        String classOutputdir = SourceToHTMLConverter.getPackageOutputDir(outputdir, pd);
        ClassDoc[] cds = pd.allClasses();
        for (int i = 0; i < cds.length; ++i) {
            SourceToHTMLConverter.convertClass(configuration, cds[i], classOutputdir);
        }
    }

    private static String getPackageOutputDir(String outputDir, PackageDoc pd) {
        return outputDir + File.separator + DirectoryManager.getDirectoryPath(pd) + File.separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertClass(Configuration configuration, ClassDoc cd, String outputdir) {
        if (cd == null || outputdir == null) {
            return;
        }
        try {
            SourcePosition sp = cd.position();
            if (sp == null) {
                return;
            }
            File file = sp.file();
            if (file == null) {
                return;
            }
            FileReader r = new FileReader(file);
            LineNumberReader reader = new LineNumberReader(r);
            int lineno = 1;
            StringBuffer output = new StringBuffer();
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    output.append(SourceToHTMLConverter.formatLine(line, configuration.sourcetab, lineno));
                    ++lineno;
                }
            }
            finally {
                reader.close();
            }
            output = SourceToHTMLConverter.addLineNumbers(output.toString());
            output.insert(0, SourceToHTMLConverter.getHeader());
            output.append(SourceToHTMLConverter.getFooter());
            SourceToHTMLConverter.writeToFile(output.toString(), outputdir, cd.name(), configuration);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeToFile(String output, String outputDir, String className, Configuration configuration) throws IOException {
        File dir = new File(outputDir);
        dir.mkdirs();
        File newFile = new File(dir, className + ".html");
        configuration.message.notice("doclet.Generating_0", newFile.getPath());
        FileOutputStream fout = new FileOutputStream(newFile);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fout));
        bw.write(output);
        bw.close();
        fout.close();
    }

    private static StringBuffer addLineNumbers(String s) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(s, "\n", true);
        int lineno = 1;
        while (st.hasMoreTokens()) {
            String current = st.nextToken();
            sb.append(current.equals("\n") ? SourceToHTMLConverter.getHTMLLineNo(lineno) + current : SourceToHTMLConverter.getHTMLLineNo(lineno) + current + st.nextToken());
            ++lineno;
        }
        return sb;
    }

    protected static String getHeader() {
        StringBuffer result = new StringBuffer("<HTML>" + DocletConstants.NL);
        result.append("<BODY BGCOLOR=\"white\">" + DocletConstants.NL);
        result.append("<PRE>" + DocletConstants.NL);
        return result.toString();
    }

    protected static String getFooter() {
        StringBuffer footer = new StringBuffer();
        for (int i = 0; i < 60; ++i) {
            footer.append(DocletConstants.NL);
        }
        footer.append("</PRE>" + DocletConstants.NL + "</BODY>" + DocletConstants.NL + "</HTML>" + DocletConstants.NL);
        return footer.toString();
    }

    protected static String getHTMLLineNo(int lineno) {
        StringBuffer result = new StringBuffer("<FONT color=\"green\">");
        if (lineno < 10) {
            result.append("00" + new Integer(lineno).toString());
        } else if (lineno < 100) {
            result.append("0" + new Integer(lineno).toString());
        } else {
            result.append(new Integer(lineno).toString());
        }
        result.append("</FONT>    ");
        return result.toString();
    }

    protected static String formatLine(String line, int tabLength, int currentLineNo) {
        if (line == null) {
            return null;
        }
        StringBuffer lineBuffer = new StringBuffer(Util.escapeHtmlChars(line));
        lineBuffer.append("<a name=\"line." + Integer.toString(currentLineNo) + "\"></a>");
        lineBuffer.append(DocletConstants.NL);
        Util.replaceTabs(tabLength, lineBuffer);
        return lineBuffer.toString();
    }

    protected static void addToHash(Doc[] docs, HashMap<Integer, String> hash) {
        if (docs == null) {
            return;
        }
        for (int i = 0; i < docs.length; ++i) {
            hash.put(docs[i].position().line(), SourceToHTMLConverter.getAnchor(docs[i]));
        }
    }

    protected static String getAnchor(Doc d) {
        return "    <a name=\"" + SourceToHTMLConverter.getAnchorName(d) + "\"></a>";
    }

    public static String getAnchorName(Doc d) {
        return "line." + d.position().line();
    }
}

