/*
 * Decompiled with CFR 0.152.
 */
package bluej;

import bluej.SplashLabel;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class SplashWindow
extends Frame {
    private boolean painted = false;
    private JProgressBar progress;

    public SplashWindow(SplashLabel splashLabel) {
        this.setLayout(new BoxLayout(this, 1));
        this.setUndecorated(true);
        this.add(splashLabel);
        this.progress = new JProgressBar();
        this.progress.setIndeterminate(true);
        this.progress.setDoubleBuffered(true);
        this.progress.setVisible(false);
        this.add(this.progress);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.setVisible(true);
        Timer timer = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SplashWindow.this.isVisible()) {
                    SplashWindow.this.progress.setVisible(true);
                    SplashWindow.this.pack();
                }
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    @Override
    public synchronized void paint(Graphics graphics) {
        super.paint(graphics);
        this.painted = true;
        this.notify();
    }

    public synchronized void waitUntilPainted() {
        long l = System.currentTimeMillis();
        long l2 = System.currentTimeMillis() - l;
        while (!this.painted && l2 < 3000L) {
            try {
                this.wait(3000L - l2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            l2 = System.currentTimeMillis() - l;
        }
        this.painted = true;
    }
}

