/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceFillBackgroundDelegate {
    private float alphaComposite;
    public static final String PREVIEW_MODE = "substancelaf.previewMode";

    public SubstanceFillBackgroundDelegate() {
        this(1.0f);
    }

    public SubstanceFillBackgroundDelegate(float alphaComposite) {
        this.alphaComposite = alphaComposite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Graphics g, JComponent c) {
        if (!(UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel)) {
            return;
        }
        boolean isInCellRenderer = c.getParent() instanceof CellRendererPane;
        boolean isPreviewMode = Boolean.TRUE.equals(c.getClientProperty(PREVIEW_MODE));
        if (!(isPreviewMode || c.isShowing() || isInCellRenderer)) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        JComponent jComponent = c;
        synchronized (jComponent) {
            if (c.isOpaque()) {
                graphics.setColor(c.getBackground());
                graphics.fillRect(0, 0, c.getWidth(), c.getHeight());
                graphics.setComposite(AlphaComposite.getInstance(3, this.alphaComposite));
                if (!isPreviewMode && !isInCellRenderer && c.isShowing() && SubstanceCoreUtilities.toDrawWatermark(c)) {
                    SubstanceLookAndFeel.getCurrentWatermark().drawWatermarkImage(graphics, c, 0, 0, c.getWidth(), c.getHeight());
                }
            }
        }
        graphics.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Graphics g, JComponent c, Rectangle rect) {
        if (!(UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel)) {
            return;
        }
        boolean isInCellRenderer = c.getParent() instanceof CellRendererPane;
        if (!c.isShowing() && !isInCellRenderer) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        JComponent jComponent = c;
        synchronized (jComponent) {
            if (c.isOpaque()) {
                graphics.setColor(c.getBackground());
                graphics.fillRect(rect.x, rect.y, rect.width, rect.height);
                graphics.setComposite(AlphaComposite.getInstance(3, this.alphaComposite));
                if (!isInCellRenderer && c.isShowing() && SubstanceCoreUtilities.toDrawWatermark(c)) {
                    SubstanceLookAndFeel.getCurrentWatermark().drawWatermarkImage(graphics, c, rect.x, rect.y, rect.width, rect.height);
                }
            }
        }
        graphics.dispose();
    }

    public void setAlphaComposite(float alphaComposite) {
        this.alphaComposite = alphaComposite;
    }
}

