/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.button;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.geom.GeneralPath;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.border.Border;
import org.jvnet.substance.SubstanceButtonBorder;
import org.jvnet.substance.button.BaseButtonShaper;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class ClassicButtonShaper
extends BaseButtonShaper {
    public static final int DEFAULT_WIDTH = 70;
    public static final int DEFAULT_HEIGHT = 20;

    public String getDisplayName() {
        return "Classic";
    }

    public GeneralPath getButtonOutline(AbstractButton button) {
        return this.getButtonOutline(button, null);
    }

    public GeneralPath getButtonOutline(AbstractButton button, Insets insets) {
        Object sideProp = button.getClientProperty("substancelaf.buttonside");
        HashSet<SubstanceConstants.Side> straightSides = new HashSet<SubstanceConstants.Side>();
        if (sideProp != null) {
            if (sideProp instanceof String) {
                straightSides.add(SubstanceConstants.Side.valueOf((String)sideProp));
            } else {
                String[] clientSides;
                for (String side : clientSides = (String[])sideProp) {
                    straightSides.add(SubstanceConstants.Side.valueOf(side));
                }
            }
        }
        float radius = 2.0f;
        return ClassicButtonShaper.getBaseOutline(button, radius, straightSides, insets);
    }

    public Border getButtonBorder(AbstractButton button) {
        return new SubstanceButtonBorder(ClassicButtonShaper.class){

            public Insets getBorderInsets(Component c) {
                return new Insets(2, 3, 2, 3);
            }
        };
    }

    public Dimension getPreferredSize(AbstractButton button, Dimension uiPreferredSize) {
        Insets margin;
        boolean toTweakWidth = false;
        boolean toTweakHeight = false;
        Icon icon = button.getIcon();
        boolean hasIcon = SubstanceCoreUtilities.hasIcon(button);
        boolean hasText = SubstanceCoreUtilities.hasText(button);
        Dimension result = uiPreferredSize;
        boolean hasNoMinSizeProperty = SubstanceCoreUtilities.hasNoMinSizeProperty(button);
        if (!hasNoMinSizeProperty && hasText) {
            int baseWidth = uiPreferredSize.width;
            if (baseWidth < 70) {
                baseWidth = 70;
            }
            result = new Dimension(baseWidth, uiPreferredSize.height);
            int baseHeight = result.height;
            if (baseHeight < 20) {
                baseHeight = 20;
            }
            result = new Dimension(result.width, baseHeight);
        } else if (hasNoMinSizeProperty && (margin = button.getMargin()) != null) {
            result = new Dimension(result.width + margin.left + margin.right, result.height + margin.top + margin.bottom);
        }
        if (hasIcon) {
            int iconWidth;
            int iconHeight = icon.getIconHeight();
            if ((double)iconHeight > result.getHeight() - 6.0) {
                result = new Dimension(result.width, iconHeight);
                toTweakHeight = true;
            }
            if ((double)(iconWidth = icon.getIconWidth()) > result.getWidth() - 6.0) {
                result = new Dimension(iconWidth, result.height);
                toTweakWidth = true;
            }
        }
        if (SubstanceCoreUtilities.isScrollBarButton(button)) {
            toTweakWidth = false;
            toTweakHeight = false;
        }
        if (toTweakWidth) {
            result = new Dimension(result.width + 6, result.height);
        }
        if (toTweakHeight) {
            result = new Dimension(result.width, result.height + 6);
        }
        return result;
    }

    public boolean isProportionate() {
        return true;
    }
}

