/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.tabbed;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.JTabbedPane;
import org.jvnet.substance.tabbed.TabOverviewDialog;
import org.jvnet.substance.tabbed.TabPreviewPainter;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceThread;

public class TabPreviewThread
extends SubstanceThread {
    private boolean stopRequested;
    protected BlockingQueue<JTabbedPane> tabPanesToPreview;
    protected Map<JTabbedPane, TabPreviewInfo> previewInfoMap;
    private static TabPreviewThread tabPreviewThread;

    public TabPreviewThread() {
        this.setName("Substance tab preview");
        this.stopRequested = false;
        this.tabPanesToPreview = new LinkedBlockingQueue<JTabbedPane>();
        this.previewInfoMap = new HashMap<JTabbedPane, TabPreviewInfo>();
    }

    public void run() {
        while (!this.stopRequested) {
            try {
                JTabbedPane nextToPreview = this.tabPanesToPreview.poll(500L, TimeUnit.MILLISECONDS);
                if (nextToPreview == null) continue;
                TabPreviewPainter previewPainter = SubstanceCoreUtilities.getTabPreviewPainter(nextToPreview);
                int tabCount = nextToPreview.getTabCount();
                TabPreviewInfo previewInfo = this.previewInfoMap.remove(nextToPreview);
                if (previewInfo == null) continue;
                if (previewInfo.toPreviewAllTabs) {
                    for (int i = 0; i < tabCount; ++i) {
                        this.getSingleTabPreviewImage(nextToPreview, previewPainter, previewInfo, i);
                    }
                    continue;
                }
                this.getSingleTabPreviewImage(nextToPreview, previewPainter, previewInfo, previewInfo.tabIndexToPreview);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
    }

    protected void getSingleTabPreviewImage(JTabbedPane tabPane, TabPreviewPainter previewPainter, TabPreviewInfo previewInfo, int tabIndex) {
        int pWidth = previewInfo.previewWidth;
        int pHeight = previewInfo.previewHeight;
        BufferedImage previewImage = new BufferedImage(pWidth, pHeight, 2);
        Graphics2D gr = previewImage.createGraphics();
        Component comp = tabPane.getComponentAt(tabIndex);
        if (previewPainter.hasPreview(tabPane, tabIndex)) {
            HashMap<Component, Boolean> dbSnapshot = new HashMap<Component, Boolean>();
            SubstanceCoreUtilities.makePreviewable(comp, dbSnapshot);
            previewPainter.previewTab(tabPane, tabIndex, gr, 0, 0, pWidth, pHeight);
            SubstanceCoreUtilities.restorePreviewable(comp, dbSnapshot);
        } else {
            gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            gr.setColor(Color.red);
            gr.setStroke(new BasicStroke(Math.max(5.0f, (float)Math.min(pWidth, pHeight) / 10.0f)));
            gr.drawLine(0, 0, pWidth, pHeight);
            gr.drawLine(0, pHeight, pWidth, 0);
        }
        gr.dispose();
        previewInfo.previewCallback.offer(tabPane, tabIndex, previewImage);
    }

    public void queueTabPreviewRequest(JTabbedPane tabPane, TabPreviewInfo previewInfo) {
        this.previewInfoMap.put(tabPane, previewInfo);
        this.tabPanesToPreview.offer(tabPane);
    }

    protected void requestStop() {
        this.stopRequested = true;
        tabPreviewThread = null;
    }

    public static synchronized TabPreviewThread getInstance() {
        if (tabPreviewThread == null) {
            tabPreviewThread = new TabPreviewThread();
            tabPreviewThread.start();
        }
        return tabPreviewThread;
    }

    protected static class TabPreviewInfo {
        public JTabbedPane tabPane;
        public TabOverviewDialog.TabPreviewCallback previewCallback;
        public int previewWidth;
        public int previewHeight;
        public boolean toPreviewAllTabs;
        public int tabIndexToPreview;

        protected TabPreviewInfo() {
        }
    }
}

