/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.watermark;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.watermark.SubstanceWatermark;

public class SubstanceLatchWatermark
implements SubstanceWatermark {
    private static Image watermarkImage = null;

    public void drawWatermarkImage(Graphics graphics, Component c, int x, int y, int width, int height) {
        int dx = c.getLocationOnScreen().x;
        int dy = c.getLocationOnScreen().y;
        graphics.drawImage(watermarkImage, x, y, x + width, y + height, x + dx, y + dy, x + dx + width, y + dy + height, null);
    }

    public boolean updateWatermarkImage() {
        GraphicsDevice[] gds;
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gds = ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            virtualBounds = virtualBounds.union(gc.getBounds());
        }
        int screenWidth = virtualBounds.width;
        int screenHeight = virtualBounds.height;
        watermarkImage = SubstanceCoreUtilities.getBlankImage(screenWidth, screenHeight);
        Graphics2D graphics = (Graphics2D)watermarkImage.getGraphics().create();
        boolean status = this.drawWatermarkImage(graphics, 0, 0, screenWidth, screenHeight, false);
        graphics.dispose();
        return status;
    }

    public void previewWatermark(Graphics g, int x, int y, int width, int height) {
        this.drawWatermarkImage((Graphics2D)g, x, y, width, height, true);
    }

    private boolean drawWatermarkImage(Graphics2D graphics, int x, int y, int width, int height, boolean isPreview) {
        Color stampColorDark = null;
        Color stampColorAll = null;
        Color stampColorLight = null;
        if (isPreview) {
            stampColorDark = SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme()) ? Color.white : Color.black;
            stampColorAll = Color.lightGray;
            stampColorLight = SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme()) ? Color.black : Color.white;
        } else {
            stampColorDark = SubstanceColorUtilities.getWatermarkDarkColor();
            stampColorAll = SubstanceColorUtilities.getWatermarkStampColor();
            stampColorLight = SubstanceColorUtilities.getWatermarkLightColor();
        }
        graphics.setColor(stampColorAll);
        graphics.fillRect(0, 0, width, height);
        int dimension = 12;
        BufferedImage tile = SubstanceCoreUtilities.getBlankImage(dimension, dimension);
        GeneralPath latch1 = new GeneralPath();
        latch1.moveTo(0.45f * (float)dimension, 0.0f);
        latch1.quadTo(0.45f * (float)dimension, 0.45f * (float)dimension, 0.05f * (float)dimension, 0.45f * (float)dimension);
        latch1.quadTo(0.15f * (float)dimension, 0.15f * (float)dimension, 0.45f * (float)dimension, 0.0f);
        this.drawLatch(tile, latch1, stampColorLight, stampColorDark);
        GeneralPath latch2 = new GeneralPath();
        latch2.moveTo(0.55f * (float)dimension, 0.55f * (float)dimension);
        latch2.quadTo(0.75f * (float)dimension, 0.4f * (float)dimension, dimension, dimension);
        latch2.quadTo(0.4f * (float)dimension, 0.75f * (float)dimension, 0.5f * (float)dimension, 0.5f * (float)dimension);
        this.drawLatch(tile, latch2, stampColorLight, stampColorDark);
        for (int row = 0; row < height; row += dimension) {
            for (int col = 0; col < width; col += dimension) {
                graphics.drawImage((Image)tile, x + col, y + row, null);
            }
        }
        return true;
    }

    private void drawLatch(BufferedImage tile, GeneralPath latchOutline, Color colorLight, Color colorDark) {
        Graphics2D graphics = (Graphics2D)tile.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(colorLight);
        graphics.draw(latchOutline);
        graphics.setColor(colorDark);
        graphics.setStroke(new BasicStroke(1.5f));
        graphics.fill(latchOutline);
        graphics.dispose();
    }

    public String getDisplayName() {
        return SubstanceLatchWatermark.getName();
    }

    public static String getName() {
        return "Latch";
    }

    public boolean isDependingOnTheme() {
        return true;
    }

    public void dispose() {
        watermarkImage = null;
    }
}

