/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class NimRODIconFactory
implements Serializable {
    private static final long serialVersionUID = 7191199335114123414L;
    private static Icon checkBoxIcon;
    private static Icon radioButtonIcon;
    private static Icon checkBoxMenuItemIcon;
    private static Icon radioButtonMenuItemIcon;
    private static Icon sliderHorizIcon;
    private static Icon sliderVertIcon;
    private static Icon treeCollapsedIcon;
    private static Icon treeExpandedIcon;

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    public static Icon getSliderVerticalIcon() {
        if (sliderVertIcon == null) {
            sliderVertIcon = new SliderVerticalIcon();
        }
        return sliderVertIcon;
    }

    public static Icon getSliderHorizontalIcon() {
        if (sliderHorizIcon == null) {
            sliderHorizIcon = new SliderHorizontalIcon();
        }
        return sliderHorizIcon;
    }

    public static Icon getTreeCollapsedIcon() {
        if (treeCollapsedIcon == null) {
            treeCollapsedIcon = new TreeCollapsedIcon();
        }
        return treeCollapsedIcon;
    }

    public static Icon getTreeExpandedIcon() {
        if (treeExpandedIcon == null) {
            treeExpandedIcon = new TreeExpandedIcon();
        }
        return treeExpandedIcon;
    }

    private static class TreeExpandedIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = 7191199335214121114L;
        private int w = 18;
        private int h = 18;

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            graphics.setColor(NimRODLookAndFeel.getFocusColor());
            graphics.fillOval(n2 + 2, n3 + 2, 13, 13);
            Icon icon = UIManager.getIcon("Tree.EstructuraExpandedIcon");
            icon.paintIcon(component, graphics, n2, n3);
        }

        public int getIconWidth() {
            return this.w;
        }

        public int getIconHeight() {
            return this.h;
        }
    }

    private static class TreeCollapsedIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = 6191195335214123414L;
        private int w = 18;
        private int h = 18;

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            graphics.setColor(NimRODLookAndFeel.getFocusColor());
            graphics.fillOval(n2 + 2, n3 + 2, 13, 13);
            Icon icon = UIManager.getIcon("Tree.EstructuraCollapsedIcon");
            icon.paintIcon(component, graphics, n2, n3);
        }

        public int getIconWidth() {
            return this.w;
        }

        public int getIconHeight() {
            return this.h;
        }
    }

    private static class SliderHorizontalIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = 1191199335214123414L;
        private int w = 19;
        private int h = 21;

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            if (component.hasFocus()) {
                graphics.setColor(NimRODLookAndFeel.getFocusColor());
                graphics.fillOval(n2 + 3, n3 + 2, 11, 17);
            } else if (!component.isEnabled()) {
                graphics.setColor(Color.gray);
                graphics.fillOval(n2 + 3, n3 + 2, 11, 17);
            }
            Icon icon = UIManager.getIcon("Slider.horizontalThumbIconImage");
            icon.paintIcon(component, graphics, n2, n3);
        }

        public int getIconWidth() {
            return this.w;
        }

        public int getIconHeight() {
            return this.h;
        }
    }

    private static class SliderVerticalIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = 3191199335214123414L;
        private int w = 21;
        private int h = 19;

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            if (component.hasFocus()) {
                graphics.setColor(NimRODLookAndFeel.getFocusColor());
                graphics.fillOval(n2 + 1, n3 + 4, 17, 11);
            } else if (!component.isEnabled()) {
                graphics.setColor(Color.gray);
                graphics.fillOval(n2 + 1, n3 + 4, 17, 11);
            }
            Icon icon = UIManager.getIcon("Slider.verticalThumbIconImage");
            icon.paintIcon(component, graphics, n2, n3);
        }

        public int getIconWidth() {
            return this.w;
        }

        public int getIconHeight() {
            return this.h;
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = 8191199335214123414L;
        private int w = 21;
        private int h = 21;

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            JMenuItem jMenuItem = (JMenuItem)component;
            ButtonModel buttonModel = jMenuItem.getModel();
            boolean bl = buttonModel.isEnabled();
            boolean bl2 = buttonModel.isSelected() || buttonModel.isPressed();
            Icon icon = UIManager.getIcon("MenuRadioButton.iconBase");
            icon.paintIcon(component, graphics, n2, n3);
            if (!bl) {
                graphics.setColor(new Color(0, 0, 0, 63));
                graphics.fillOval(n2 + 3, n3 + 3, 15, 15);
            } else if (bl2) {
                graphics.setColor(NimRODLookAndFeel.getFocusColor());
                graphics.fillOval(n2 + 3, n3 + 3, 15, 15);
            }
            if (buttonModel.isArmed() && bl) {
                graphics.setColor(new Color(255, 255, 155, 127));
                graphics.fillOval(n2 + 5, n3 + 5, 11, 11);
            }
            if (bl2) {
                icon = UIManager.getIcon("MenuRadioButton.iconTick");
                icon.paintIcon(component, graphics, n2, n3);
            }
        }

        public int getIconWidth() {
            return this.w;
        }

        public int getIconHeight() {
            return this.h;
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = 7291199335214123414L;
        private int w = 21;
        private int h = 21;

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            JMenuItem jMenuItem = (JMenuItem)component;
            ButtonModel buttonModel = jMenuItem.getModel();
            boolean bl = buttonModel.isEnabled();
            boolean bl2 = buttonModel.isSelected() || buttonModel.isPressed();
            Icon icon = UIManager.getIcon("MenuCheckBox.iconBase");
            icon.paintIcon(component, graphics, n2, n3);
            if (!bl) {
                graphics.setColor(new Color(0, 0, 0, 63));
                graphics.fillRect(n2 + 3, n3 + 3, 15, 15);
            } else if (bl2) {
                graphics.setColor(NimRODLookAndFeel.getFocusColor());
                graphics.fillRect(n2 + 3, n3 + 3, 15, 15);
            }
            if (buttonModel.isArmed() && bl) {
                graphics.setColor(new Color(255, 255, 155, 127));
                graphics.fillRect(n2 + 5, n3 + 5, 11, 11);
            }
            if (bl2) {
                icon = UIManager.getIcon("MenuCheckBox.iconTick");
                icon.paintIcon(component, graphics, n2, n3);
            }
        }

        public int getIconWidth() {
            return this.w;
        }

        public int getIconHeight() {
            return this.h;
        }
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = 7191299335214123414L;
        private int w = 21;
        private int h = 21;

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            JRadioButton jRadioButton = (JRadioButton)component;
            ButtonModel buttonModel = jRadioButton.getModel();
            boolean bl = buttonModel.isEnabled();
            boolean bl2 = buttonModel.isSelected() || buttonModel.isPressed();
            Icon icon = UIManager.getIcon("RadioButton.iconBase");
            icon.paintIcon(component, graphics, n2, n3);
            if (!bl) {
                graphics.setColor(new Color(0, 0, 0, 63));
                graphics.fillOval(n2 + 3, n3 + 3, 15, 15);
            } else if (bl2) {
                graphics.setColor(NimRODLookAndFeel.getFocusColor());
                graphics.fillOval(n2 + 3, n3 + 3, 15, 15);
            }
            if (buttonModel.isArmed() && bl) {
                graphics.setColor(new Color(255, 255, 155, 127));
                graphics.fillOval(n2 + 5, n3 + 5, 11, 11);
            }
            if (bl2) {
                icon = UIManager.getIcon("RadioButton.iconTick");
                icon.paintIcon(component, graphics, n2, n3);
            }
            if (buttonModel.isRollover()) {
                graphics.setColor(NimRODLookAndFeel.getRolloverColor());
                graphics.fillRect(n2 + 5, n3 + 5, 11, 11);
            }
        }

        public int getIconWidth() {
            return this.w;
        }

        public int getIconHeight() {
            return this.h;
        }
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = 7191199235214123414L;
        private int w = 21;
        private int h = 21;

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            JCheckBox jCheckBox = (JCheckBox)component;
            ButtonModel buttonModel = jCheckBox.getModel();
            boolean bl = buttonModel.isEnabled();
            boolean bl2 = buttonModel.isSelected() || buttonModel.isPressed();
            Icon icon = UIManager.getIcon("CheckBox.iconBase");
            icon.paintIcon(component, graphics, n2, n3);
            if (!bl) {
                graphics.setColor(new Color(0, 0, 0, 63));
                graphics.fillRect(n2 + 3, n3 + 3, 15, 15);
            } else if (bl2) {
                graphics.setColor(NimRODLookAndFeel.getFocusColor());
                graphics.fillRect(n2 + 3, n3 + 3, 15, 15);
            }
            if (buttonModel.isArmed() && bl) {
                graphics.setColor(new Color(255, 255, 155, 127));
                graphics.fillRect(n2 + 5, n3 + 5, 11, 11);
            }
            if (bl2) {
                icon = UIManager.getIcon("CheckBox.iconTick");
                icon.paintIcon(component, graphics, n2, n3);
            }
            if (buttonModel.isRollover()) {
                graphics.setColor(NimRODLookAndFeel.getRolloverColor());
                graphics.fillRect(n2 + 5, n3 + 5, 11, 11);
            }
        }

        public int getIconWidth() {
            return this.w;
        }

        public int getIconHeight() {
            return this.h;
        }
    }
}

