/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;

public class CTabItem
extends Item {
    CTabFolder parent;
    int x;
    int y;
    int width;
    int height = 0;
    Control control;
    String toolTipText;
    String shortenedText;
    int shortenedTextWidth;
    Font font;
    Image disabledImage;
    Rectangle closeRect = new Rectangle(0, 0, 0, 0);
    int closeImageState = 0;
    boolean showClose = false;
    boolean showing = false;
    static final int TOP_MARGIN = 2;
    static final int BOTTOM_MARGIN = 2;
    static final int LEFT_MARGIN = 4;
    static final int RIGHT_MARGIN = 4;
    static final int INTERNAL_SPACING = 4;
    static final int FLAGS = 9;
    static final String ELLIPSIS = "...";

    public CTabItem(CTabFolder cTabFolder, int n2) {
        this(cTabFolder, n2, cTabFolder.getItemCount());
    }

    public CTabItem(CTabFolder cTabFolder, int n2, int n3) {
        super(cTabFolder, CTabItem.checkStyle(n2));
        this.showClose = (n2 & 0x40) != 0;
        cTabFolder.createItem(this, n3);
    }

    static int checkStyle(int n2) {
        return 0;
    }

    static String shortenText(GC gC, String string, int n2) {
        if (gC.textExtent((String)string, (int)9).x <= n2) {
            return string;
        }
        int n3 = gC.textExtent((String)ELLIPSIS, (int)9).x;
        int n4 = string.length();
        for (int i2 = n4 - 1; i2 > 0; --i2) {
            string = string.substring(0, i2);
            int n5 = gC.textExtent((String)string, (int)9).x;
            if (n5 + n3 > n2) continue;
            return string + ELLIPSIS;
        }
        return string.substring(0, 1);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.parent.destroyItem(this);
        super.dispose();
        this.parent = null;
        this.control = null;
        this.toolTipText = null;
        this.shortenedText = null;
        this.font = null;
    }

    void drawClose(GC gC) {
        if (this.closeRect.width == 0 || this.closeRect.height == 0) {
            return;
        }
        Display display = this.getDisplay();
        int n2 = Math.max(1, 4);
        int n3 = this.closeRect.x + n2;
        int n4 = this.closeRect.y + n2;
        n4 += this.parent.onBottom ? -1 : 1;
        Color color = display.getSystemColor(17);
        switch (this.closeImageState) {
            case 1: {
                int[] nArray = new int[]{n3, n4, n3 + 2, n4, n3 + 4, n4 + 2, n3 + 5, n4 + 2, n3 + 7, n4, n3 + 9, n4, n3 + 9, n4 + 2, n3 + 7, n4 + 4, n3 + 7, n4 + 5, n3 + 9, n4 + 7, n3 + 9, n4 + 9, n3 + 7, n4 + 9, n3 + 5, n4 + 7, n3 + 4, n4 + 7, n3 + 2, n4 + 9, n3, n4 + 9, n3, n4 + 7, n3 + 2, n4 + 5, n3 + 2, n4 + 4, n3, n4 + 2};
                gC.setBackground(display.getSystemColor(25));
                gC.fillPolygon(nArray);
                gC.setForeground(color);
                gC.drawPolygon(nArray);
                break;
            }
            case 2: {
                int[] nArray = new int[]{n3, n4, n3 + 2, n4, n3 + 4, n4 + 2, n3 + 5, n4 + 2, n3 + 7, n4, n3 + 9, n4, n3 + 9, n4 + 2, n3 + 7, n4 + 4, n3 + 7, n4 + 5, n3 + 9, n4 + 7, n3 + 9, n4 + 9, n3 + 7, n4 + 9, n3 + 5, n4 + 7, n3 + 4, n4 + 7, n3 + 2, n4 + 9, n3, n4 + 9, n3, n4 + 7, n3 + 2, n4 + 5, n3 + 2, n4 + 4, n3, n4 + 2};
                Color color2 = new Color(display, CTabFolder.CLOSE_FILL);
                gC.setBackground(color2);
                gC.fillPolygon(nArray);
                color2.dispose();
                gC.setForeground(color);
                gC.drawPolygon(nArray);
                break;
            }
            case 3: {
                int[] nArray = new int[]{n3 + 1, n4 + 1, n3 + 3, n4 + 1, n3 + 5, n4 + 3, n3 + 6, n4 + 3, n3 + 8, n4 + 1, n3 + 10, n4 + 1, n3 + 10, n4 + 3, n3 + 8, n4 + 5, n3 + 8, n4 + 6, n3 + 10, n4 + 8, n3 + 10, n4 + 10, n3 + 8, n4 + 10, n3 + 6, n4 + 8, n3 + 5, n4 + 8, n3 + 3, n4 + 10, n3 + 1, n4 + 10, n3 + 1, n4 + 8, n3 + 3, n4 + 6, n3 + 3, n4 + 5, n3 + 1, n4 + 3};
                Color color3 = new Color(display, CTabFolder.CLOSE_FILL);
                gC.setBackground(color3);
                gC.fillPolygon(nArray);
                color3.dispose();
                gC.setForeground(color);
                gC.drawPolygon(nArray);
                break;
            }
            case 0: {
                int[] nArray = new int[]{n3, n4, n3 + 10, n4, n3 + 10, n4 + 10, n3, n4 + 10};
                if (this.parent.gradientColors != null && !this.parent.gradientVertical) {
                    this.parent.drawBackground(gC, nArray, false);
                    break;
                }
                Color color4 = this.parent.getBackground();
                Image image = this.parent.bgImage;
                Color[] colorArray = this.parent.gradientColors;
                int[] nArray2 = this.parent.gradientPercents;
                boolean bl = this.parent.gradientVertical;
                this.parent.drawBackground(gC, nArray, n3, n4, 10, 10, color4, image, colorArray, nArray2, bl);
                break;
            }
        }
    }

    void drawSelected(GC gC) {
        Object object;
        Object object2;
        Point point = this.parent.getSize();
        int n2 = Math.min(this.x + this.width, this.parent.getRightItemEdge());
        int n3 = this.parent.borderLeft;
        int n4 = this.parent.onBottom ? point.y - this.parent.borderBottom - this.parent.tabHeight - this.parent.highlight_header : this.parent.borderTop + this.parent.tabHeight + 1;
        int n5 = point.x - this.parent.borderLeft - this.parent.borderRight;
        int n6 = this.parent.highlight_header - 1;
        int[] nArray = new int[]{n3, n4, n3 + n5, n4, n3 + n5, n4 + n6, n3, n4 + n6};
        if (this.parent.selectionGradientColors != null && !this.parent.selectionGradientVertical) {
            this.parent.drawBackground(gC, nArray, true);
        } else {
            gC.setBackground(this.parent.selectionBackground);
            gC.fillRectangle(n3, n4, n5, n6);
        }
        if (this.parent.single) {
            if (!this.showing) {
                return;
            }
        } else {
            Object object3;
            int n7;
            int n8;
            Object object4;
            if (!this.showing) {
                int n9 = Math.max(0, this.parent.borderLeft - 1);
                int n10 = this.parent.onBottom ? this.y - 1 : this.y + this.height;
                int n11 = point.x - this.parent.borderRight;
                gC.setForeground(CTabFolder.borderColor);
                gC.drawLine(n9, n10, n11, n10);
                return;
            }
            nArray = null;
            if (this.parent.onBottom) {
                object4 = this.parent.simple ? CTabFolder.SIMPLE_BOTTOM_LEFT_CORNER : CTabFolder.BOTTOM_LEFT_CORNER;
                object2 = this.parent.simple ? CTabFolder.SIMPLE_BOTTOM_RIGHT_CORNER : this.parent.curve;
                if (this.parent.borderLeft == 0 && this.parent.indexOf(this) == this.parent.firstIndex) {
                    object4 = new int[]{this.x, this.y + this.height};
                }
                nArray = new int[((int[])object4).length + ((Object)object2).length + 8];
                n8 = 0;
                nArray[n8++] = this.x;
                nArray[n8++] = this.y - 1;
                nArray[n8++] = this.x;
                nArray[n8++] = this.y - 1;
                for (n7 = 0; n7 < ((int[])object4).length / 2; ++n7) {
                    nArray[n8++] = this.x + object4[2 * n7];
                    nArray[n8++] = this.y + this.height + object4[2 * n7 + 1] - 1;
                }
                for (n7 = 0; n7 < ((Object)object2).length / 2; ++n7) {
                    nArray[n8++] = this.parent.simple ? n2 - 1 + object2[2 * n7] : n2 - this.parent.curveIndent + object2[2 * n7];
                    nArray[n8++] = this.parent.simple ? this.y + this.height + object2[2 * n7 + 1] - 1 : this.y + object2[2 * n7 + 1] - 2;
                }
                nArray[n8++] = this.parent.simple ? n2 - 1 : n2 + this.parent.curveWidth - this.parent.curveIndent;
                nArray[n8++] = this.y - 1;
                nArray[n8++] = this.parent.simple ? n2 - 1 : n2 + this.parent.curveWidth - this.parent.curveIndent;
                nArray[n8++] = this.y - 1;
            } else {
                object4 = this.parent.simple ? CTabFolder.SIMPLE_TOP_LEFT_CORNER : CTabFolder.TOP_LEFT_CORNER;
                object2 = this.parent.simple ? CTabFolder.SIMPLE_TOP_RIGHT_CORNER : this.parent.curve;
                if (this.parent.borderLeft == 0 && this.parent.indexOf(this) == this.parent.firstIndex) {
                    object4 = new int[]{this.x, this.y};
                }
                nArray = new int[((int[])object4).length + ((Object)object2).length + 8];
                n8 = 0;
                nArray[n8++] = this.x;
                nArray[n8++] = this.y + this.height + 1;
                nArray[n8++] = this.x;
                nArray[n8++] = this.y + this.height + 1;
                for (n7 = 0; n7 < ((int[])object4).length / 2; ++n7) {
                    nArray[n8++] = this.x + object4[2 * n7];
                    nArray[n8++] = this.y + object4[2 * n7 + 1];
                }
                for (n7 = 0; n7 < ((Object)object2).length / 2; ++n7) {
                    nArray[n8++] = this.parent.simple ? n2 - 1 + object2[2 * n7] : n2 - this.parent.curveIndent + object2[2 * n7];
                    nArray[n8++] = this.y + object2[2 * n7 + 1];
                }
                nArray[n8++] = this.parent.simple ? n2 - 1 : n2 + this.parent.curveWidth - this.parent.curveIndent;
                nArray[n8++] = this.y + this.height + 1;
                nArray[n8++] = this.parent.simple ? n2 - 1 : n2 + this.parent.curveWidth - this.parent.curveIndent;
                nArray[n8++] = this.y + this.height + 1;
            }
            object4 = gC.getClipping();
            object2 = this.getBounds();
            ++((Rectangle)object2).height;
            if (this.parent.onBottom) {
                --((Rectangle)object2).y;
            }
            if ((n8 = (int)(((Rectangle)object4).intersects((Rectangle)object2) ? 1 : 0)) != 0) {
                if (this.parent.selectionGradientColors != null && !this.parent.selectionGradientVertical) {
                    this.parent.drawBackground(gC, nArray, true);
                } else {
                    Color color = this.parent.selectionBackground;
                    object3 = this.parent.selectionBgImage;
                    Color[] colorArray = this.parent.selectionGradientColors;
                    object = this.parent.selectionGradientPercents;
                    boolean bl = this.parent.selectionGradientVertical;
                    n3 = this.x;
                    n4 = this.parent.onBottom ? this.y - 1 : this.y + 1;
                    n5 = this.width;
                    n6 = this.height;
                    if (!this.parent.single && !this.parent.simple) {
                        n5 += this.parent.curveWidth - this.parent.curveIndent;
                    }
                    this.parent.drawBackground(gC, nArray, n3, n4, n5, n6, color, (Image)object3, colorArray, (int[])object, bl);
                }
            }
            nArray[0] = Math.max(0, this.parent.borderLeft - 1);
            if (this.parent.borderLeft == 0 && this.parent.indexOf(this) == this.parent.firstIndex) {
                nArray[1] = this.parent.onBottom ? this.y + this.height - 1 : this.y;
                nArray[5] = nArray[3] = nArray[1];
            }
            nArray[nArray.length - 2] = point.x - this.parent.borderRight + 1;
            for (int i2 = 0; i2 < nArray.length / 2; ++i2) {
                if (nArray[2 * i2 + 1] != this.y + this.height + 1) continue;
                int n12 = 2 * i2 + 1;
                nArray[n12] = nArray[n12] - 1;
            }
            RGB rGB = this.parent.selectionBackground.getRGB();
            if (this.parent.selectionBgImage != null || this.parent.selectionGradientColors != null && this.parent.selectionGradientColors.length > 1) {
                rGB = null;
            }
            object3 = this.parent.getBackground().getRGB();
            if (this.parent.bgImage != null || this.parent.gradientColors != null && this.parent.gradientColors.length > 1) {
                object3 = null;
            }
            this.parent.antialias(nArray, CTabFolder.borderColor.getRGB(), rGB, (RGB)object3, gC);
            gC.setForeground(CTabFolder.borderColor);
            gC.drawPolyline(nArray);
            if (n8 == 0) {
                return;
            }
        }
        int n13 = this.x + 4;
        if (this.parent.single && (this.parent.showClose || this.showClose)) {
            n13 += 18;
        }
        if ((object2 = this.getImage()) != null) {
            Rectangle rectangle = ((Image)object2).getBounds();
            int n14 = n2 - n13 - 4;
            if (!this.parent.single && this.closeRect.width > 0) {
                n14 -= this.closeRect.width + 4;
            }
            if (rectangle.width < n14) {
                int n15 = n13;
                int n16 = this.y + (this.height - rectangle.height) / 2;
                gC.drawImage((Image)object2, n15, n16 += this.parent.onBottom ? -1 : 1);
                n13 += rectangle.width + 4;
            }
        }
        int n17 = n2 - n13 - 4;
        if (!this.parent.single && this.closeRect.width > 0) {
            n17 -= this.closeRect.width + 4;
        }
        if (n17 > 0) {
            Font font = gC.getFont();
            gC.setFont(this.font == null ? this.parent.getFont() : this.font);
            if (this.shortenedText == null || this.shortenedTextWidth != n17) {
                this.shortenedText = CTabItem.shortenText(gC, this.getText(), n17);
                this.shortenedTextWidth = n17;
            }
            Point point2 = gC.textExtent(this.shortenedText, 9);
            int n18 = this.y + (this.height - point2.y) / 2;
            int n19 = this.parent.onBottom ? -1 : 1;
            gC.setForeground(this.parent.selectionForeground);
            gC.drawText(this.shortenedText, n13, n18 += n19, 9);
            gC.setFont(font);
            if (this.parent.isFocusControl()) {
                object = this.getDisplay();
                if (this.parent.simple || this.parent.single) {
                    gC.setBackground(((Display)object).getSystemColor(2));
                    gC.setForeground(((Display)object).getSystemColor(1));
                    gC.drawFocus(n13 - 1, n18 - 1, point2.x + 2, point2.y + 2);
                } else {
                    gC.setForeground(((Display)object).getSystemColor(17));
                    gC.drawLine(n13, n18 + point2.y + 1, n13 + point2.x + 1, n18 + point2.y + 1);
                }
            }
        }
        if (this.parent.showClose || this.showClose) {
            this.drawClose(gC);
        }
    }

    void drawUnselected(GC gC) {
        int n2;
        int n3;
        Rectangle rectangle;
        if (!this.showing) {
            return;
        }
        Rectangle rectangle2 = gC.getClipping();
        if (!rectangle2.intersects(rectangle = this.getBounds())) {
            return;
        }
        int n4 = -1;
        for (n3 = this.parent.indexOf(this) + 1; n3 < this.parent.items.length; ++n3) {
            if (!this.parent.items[n3].showing) continue;
            n4 = n3;
            break;
        }
        if (n4 == -1 || n4 != this.parent.selectedIndex) {
            gC.setForeground(CTabFolder.borderColor);
            gC.drawLine(this.x + this.width - 1, this.y, this.x + this.width - 1, this.y + this.height);
        }
        n3 = this.x + 4;
        Image image = this.getImage();
        if (image != null && this.parent.showUnselectedImage) {
            Rectangle rectangle3 = image.getBounds();
            int n5 = this.x + this.width - n3 - 4;
            if (this.parent.showUnselectedClose && (this.parent.showClose || this.showClose)) {
                n5 -= this.closeRect.width + 4;
            }
            if (rectangle3.width < n5) {
                int n6 = n3;
                n2 = rectangle3.height;
                int n7 = this.y + (this.height - n2) / 2;
                int n8 = this.parent.onBottom ? -1 : 1;
                int n9 = rectangle3.width * n2 / rectangle3.height;
                gC.drawImage(image, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, n6, n7 += n8, n9, n2);
                n3 += n9 + 4;
            }
        }
        int n10 = this.x + this.width - n3 - 4;
        if (this.parent.showUnselectedClose && (this.parent.showClose || this.showClose)) {
            n10 -= this.closeRect.width + 4;
        }
        if (n10 > 0) {
            Font font = gC.getFont();
            gC.setFont(this.font == null ? this.parent.getFont() : this.font);
            if (this.shortenedText == null || this.shortenedTextWidth != n10) {
                this.shortenedText = CTabItem.shortenText(gC, this.getText(), n10);
                this.shortenedTextWidth = n10;
            }
            Point point = gC.textExtent(this.shortenedText, 9);
            n2 = this.y + (this.height - point.y) / 2;
            int n11 = this.parent.onBottom ? -1 : 1;
            gC.setForeground(this.parent.getForeground());
            gC.drawText(this.shortenedText, n3, n2 += n11, 9);
            gC.setFont(font);
        }
        if (this.parent.showUnselectedClose && (this.parent.showClose || this.showClose)) {
            this.drawClose(gC);
        }
    }

    public Rectangle getBounds() {
        int n2 = this.width;
        if (!this.parent.simple && !this.parent.single && this.parent.indexOf(this) == this.parent.selectedIndex) {
            n2 += this.parent.curveWidth - this.parent.curveIndent;
        }
        return new Rectangle(this.x, this.y, n2, this.height);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font != null) {
            return this.font;
        }
        return this.parent.getFont();
    }

    public CTabFolder getParent() {
        return this.parent;
    }

    public String getToolTipText() {
        String string;
        this.checkWidget();
        if (this.toolTipText == null && this.shortenedText != null && !this.shortenedText.equals(string = this.getText())) {
            return string;
        }
        return this.toolTipText;
    }

    public boolean isShowing() {
        this.checkWidget();
        return this.showing;
    }

    void onPaint(GC gC, boolean bl) {
        if (this.width == 0 || this.height == 0) {
            return;
        }
        if (bl) {
            this.drawSelected(gC);
        } else {
            this.drawUnselected(gC);
        }
    }

    int preferredHeight(GC gC) {
        Image image = this.getImage();
        int n2 = image == null ? 0 : image.getBounds().height;
        String string = this.getText();
        if (this.font == null) {
            n2 = Math.max(n2, gC.textExtent((String)string, (int)9).y);
        } else {
            Font font = gC.getFont();
            gC.setFont(this.font);
            n2 = Math.max(n2, gC.textExtent((String)string, (int)9).y);
            gC.setFont(font);
        }
        return n2 + 2 + 2;
    }

    int preferredWidth(GC gC, boolean bl, boolean bl2) {
        if (this.isDisposed()) {
            return 0;
        }
        int n2 = 0;
        Image image = this.getImage();
        if (image != null && (bl || this.parent.showUnselectedImage)) {
            n2 += image.getBounds().width;
        }
        String string = null;
        if (bl2) {
            int n3 = this.parent.minChars;
            String string2 = string = n3 == 0 ? null : this.getText();
            if (string != null && string.length() > n3) {
                int n4 = n3 < ELLIPSIS.length() + 1 ? n3 : n3 - ELLIPSIS.length();
                string = string.substring(0, n4);
                if (n3 > ELLIPSIS.length() + 1) {
                    string = string + ELLIPSIS;
                }
            }
        } else {
            string = this.getText();
        }
        if (string != null) {
            if (n2 > 0) {
                n2 += 4;
            }
            if (this.font == null) {
                n2 += gC.textExtent((String)string, (int)9).x;
            } else {
                Font font = gC.getFont();
                gC.setFont(this.font);
                n2 += gC.textExtent((String)string, (int)9).x;
                gC.setFont(font);
            }
        }
        if ((this.parent.showClose || this.showClose) && (bl || this.parent.showUnselectedClose)) {
            if (n2 > 0) {
                n2 += 4;
            }
            n2 += 18;
        }
        return n2 + 4 + 4;
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                SWT.error(5);
            }
            if (control.getParent() != this.parent) {
                SWT.error(32);
            }
        }
        if (this.control != null && !this.control.isDisposed()) {
            this.control.setVisible(false);
        }
        this.control = control;
        if (this.control != null) {
            int n2 = this.parent.indexOf(this);
            if (n2 == this.parent.getSelectionIndex()) {
                this.control.setBounds(this.parent.getClientArea());
                this.control.setVisible(true);
            } else {
                this.control.setVisible(false);
            }
        }
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error(5);
        }
        this.disabledImage = image;
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (font == null && this.font == null) {
            return;
        }
        if (font != null && font.equals(this.font)) {
            return;
        }
        this.font = font;
        if (!this.parent.updateTabHeight(false)) {
            this.parent.updateItems();
            this.parent.redrawTabs();
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error(5);
        }
        Image image2 = this.getImage();
        if (image == null && image2 == null) {
            return;
        }
        if (image != null && image.equals(image2)) {
            return;
        }
        super.setImage(image);
        if (!this.parent.updateTabHeight(false)) {
            if (image2 != null && image != null) {
                Rectangle rectangle = image2.getBounds();
                Rectangle rectangle2 = image.getBounds();
                if (rectangle2.width == rectangle.width && rectangle2.height == rectangle.height) {
                    if (this.showing) {
                        this.parent.redraw(this.x, this.y, this.width, this.height, false);
                    }
                    return;
                }
            }
            this.parent.updateItems();
            this.parent.redrawTabs();
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        if (string.equals(this.getText())) {
            return;
        }
        super.setText(string);
        this.shortenedText = null;
        this.shortenedTextWidth = 0;
        if (!this.parent.updateTabHeight(false)) {
            this.parent.updateItems();
            this.parent.redrawTabs();
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }
}

