/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public class ControlEditor {
    public int horizontalAlignment = 0x1000000;
    public boolean grabHorizontal = false;
    public int minimumWidth = 0;
    public int verticalAlignment = 0x1000000;
    public boolean grabVertical = false;
    public int minimumHeight = 0;
    Composite parent;
    Control editor;
    private boolean hadFocus;
    private Listener tableListener;
    private Listener scrollbarListener;

    public ControlEditor(Composite composite) {
        ScrollBar scrollBar;
        this.parent = composite;
        this.tableListener = new Listener(){

            public void handleEvent(Event e2) {
                ControlEditor.this._resize();
            }
        };
        composite.addListener(11, this.tableListener);
        this.scrollbarListener = new Listener(){

            public void handleEvent(Event e2) {
                ControlEditor.this.scroll(e2);
            }
        };
        ScrollBar scrollBar2 = composite.getHorizontalBar();
        if (scrollBar2 != null) {
            scrollBar2.addListener(13, this.scrollbarListener);
        }
        if ((scrollBar = composite.getVerticalBar()) != null) {
            scrollBar.addListener(13, this.scrollbarListener);
        }
    }

    Rectangle computeBounds() {
        Rectangle rectangle = this.parent.getClientArea();
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, this.minimumWidth, this.minimumHeight);
        if (this.grabHorizontal) {
            rectangle2.width = Math.max(rectangle.width, this.minimumWidth);
        }
        if (this.grabVertical) {
            rectangle2.height = Math.max(rectangle.height, this.minimumHeight);
        }
        switch (this.horizontalAlignment) {
            case 131072: {
                rectangle2.x += rectangle.width - rectangle2.width;
                break;
            }
            case 16384: {
                break;
            }
            default: {
                rectangle2.x += (rectangle.width - rectangle2.width) / 2;
            }
        }
        switch (this.verticalAlignment) {
            case 1024: {
                rectangle2.y += rectangle.height - rectangle2.height;
                break;
            }
            case 128: {
                break;
            }
            default: {
                rectangle2.y += (rectangle.height - rectangle2.height) / 2;
            }
        }
        return rectangle2;
    }

    public void dispose() {
        if (!this.parent.isDisposed()) {
            ScrollBar scrollBar;
            this.parent.removeListener(11, this.tableListener);
            ScrollBar scrollBar2 = this.parent.getHorizontalBar();
            if (scrollBar2 != null) {
                scrollBar2.removeListener(13, this.scrollbarListener);
            }
            if ((scrollBar = this.parent.getVerticalBar()) != null) {
                scrollBar.removeListener(13, this.scrollbarListener);
            }
        }
        this.parent = null;
        this.editor = null;
        this.hadFocus = false;
        this.tableListener = null;
        this.scrollbarListener = null;
    }

    public Control getEditor() {
        return this.editor;
    }

    public void layout() {
        this._resize();
    }

    void _resize() {
        if (this.editor == null || this.editor.isDisposed()) {
            return;
        }
        if (this.editor.getVisible()) {
            this.hadFocus = this.editor.isFocusControl();
        }
        this.editor.setBounds(this.computeBounds());
        if (this.hadFocus) {
            if (this.editor == null || this.editor.isDisposed()) {
                return;
            }
            this.editor.setFocus();
        }
    }

    void scroll(Event event) {
        if (this.editor == null || this.editor.isDisposed()) {
            return;
        }
        this.editor.setBounds(this.computeBounds());
    }

    public void setEditor(Control control) {
        if (control == null) {
            this.editor = null;
            return;
        }
        this.editor = control;
        this._resize();
        if (this.editor == null || this.editor.isDisposed()) {
            return;
        }
        control.setVisible(true);
    }
}

