/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TableEditor
extends ControlEditor {
    Table table;
    TableItem item;
    int column = -1;
    ControlListener columnListener;

    public TableEditor(Table table) {
        super(table);
        this.table = table;
        this.columnListener = new ControlListener(){

            public void controlMoved(ControlEvent e2) {
                TableEditor.this._resize();
            }

            public void controlResized(ControlEvent e2) {
                TableEditor.this._resize();
            }
        };
        this.grabVertical = true;
    }

    Rectangle computeBounds() {
        if (this.item == null || this.column == -1 || this.item.isDisposed()) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle rectangle = this.item.getBounds(this.column);
        Rectangle rectangle2 = this.item.getImageBounds(this.column);
        rectangle.x = rectangle2.x + rectangle2.width;
        rectangle.width -= rectangle2.width;
        Rectangle rectangle3 = this.table.getClientArea();
        if (rectangle.x < rectangle3.x + rectangle3.width && rectangle.x + rectangle.width > rectangle3.x + rectangle3.width) {
            rectangle.width = rectangle3.x + rectangle3.width - rectangle.x;
        }
        Rectangle rectangle4 = new Rectangle(rectangle.x, rectangle.y, this.minimumWidth, this.minimumHeight);
        if (this.grabHorizontal) {
            rectangle4.width = Math.max(rectangle.width, this.minimumWidth);
        }
        if (this.grabVertical) {
            rectangle4.height = Math.max(rectangle.height, this.minimumHeight);
        }
        if (this.horizontalAlignment == 131072) {
            rectangle4.x += rectangle.width - rectangle4.width;
        } else if (this.horizontalAlignment != 16384) {
            rectangle4.x += (rectangle.width - rectangle4.width) / 2;
        }
        if (this.verticalAlignment == 1024) {
            rectangle4.y += rectangle.height - rectangle4.height;
        } else if (this.verticalAlignment != 128) {
            rectangle4.y += (rectangle.height - rectangle4.height) / 2;
        }
        return rectangle4;
    }

    public void dispose() {
        if (this.column > -1 && this.column < this.table.getColumnCount()) {
            TableColumn tableColumn = this.table.getColumn(this.column);
            tableColumn.removeControlListener(this.columnListener);
        }
        this.columnListener = null;
        this.table = null;
        this.item = null;
        this.column = -1;
        super.dispose();
    }

    public int getColumn() {
        return this.column;
    }

    public TableItem getItem() {
        return this.item;
    }

    public void setColumn(int n2) {
        TableColumn tableColumn;
        int n3 = this.table.getColumnCount();
        if (n3 == 0) {
            this.column = n2 == 0 ? 0 : -1;
            this._resize();
            return;
        }
        if (this.column > -1 && this.column < n3) {
            tableColumn = this.table.getColumn(this.column);
            tableColumn.removeControlListener(this.columnListener);
            this.column = -1;
        }
        if (n2 < 0 || n2 >= this.table.getColumnCount()) {
            return;
        }
        this.column = n2;
        tableColumn = this.table.getColumn(this.column);
        tableColumn.addControlListener(this.columnListener);
        this._resize();
    }

    public void setItem(TableItem tableItem) {
        this.item = tableItem;
        this._resize();
    }

    public void setEditor(Control control, TableItem tableItem, int n2) {
        this.setItem(tableItem);
        this.setColumn(n2);
        this.setEditor(control);
    }

    void _resize() {
        if (this.table.isDisposed()) {
            return;
        }
        if (this.item == null || this.item.isDisposed()) {
            return;
        }
        int n2 = this.table.getColumnCount();
        if (n2 == 0 && this.column != 0) {
            return;
        }
        if (n2 > 0 && (this.column < 0 || this.column >= n2)) {
            return;
        }
        super._resize();
    }
}

