/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.io.Reader;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public class HTMLTransfer
extends Transfer {
    private static HTMLTransfer _instance = new HTMLTransfer();
    static DataFlavor HTML_FLAVOR_1 = new DataFlavor("text/html; class=java.lang.String", "HTML Text");

    private HTMLTransfer() {
    }

    public static HTMLTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkHTML(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        transferData.transferable = new StringSelection((String)object);
    }

    public Object nativeToJava(TransferData transferData) {
        Object object = super.nativeToJava(transferData);
        if (object instanceof Reader) {
            StringBuilder stringBuilder = new StringBuilder();
            Reader reader = (Reader)object;
            char[] cArray = new char[128];
            try {
                int n2;
                while ((n2 = reader.read(cArray)) != -1) {
                    stringBuilder.append(cArray, 0, n2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return stringBuilder.toString();
        }
        return object;
    }

    boolean checkHTML(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkHTML(object);
    }

    public TransferData[] getSupportedTypes() {
        TransferData transferData = new TransferData();
        transferData.dataFlavor = HTML_FLAVOR_1;
        return new TransferData[]{transferData};
    }

    protected DataFlavor getDataFlavor() {
        return HTML_FLAVOR_1;
    }
}

