/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DragAndDropEffect;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LVHITTESTINFO;
import org.eclipse.swt.internal.win32.LVITEM;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

class TableDragAndDropEffect
extends DragAndDropEffect {
    Table table;
    int scrollIndex;
    long scrollBeginTime;
    TableItem dropHighlight;
    static final int SCROLL_HYSTERESIS = 200;

    TableDragAndDropEffect(Table table) {
        this.table = table;
    }

    int checkEffect(int n2) {
        if ((n2 & 1) != 0) {
            n2 = n2 & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((n2 & 2) != 0) {
            n2 &= 0xFFFFFFFB;
        }
        return n2;
    }

    Widget getItem(int n2, int n3) {
        Rectangle rectangle;
        Point point = new Point(n2, n3);
        TableItem tableItem = this.table.getItem(point = this.table.toControl(point));
        if (tableItem == null && (rectangle = this.table.getClientArea()).contains(point)) {
            Point point2;
            for (int i2 = rectangle.x; i2 < rectangle.x + rectangle.width && (tableItem = this.table.getItem(point2 = new Point(i2, point.y))) == null; ++i2) {
            }
        }
        return tableItem;
    }

    ImageData getDragSourceImage(int n2, int n3) {
        TableItem[] tableItemArray = this.table.getSelection();
        if (tableItemArray.length == 0) {
            return null;
        }
        int n4 = OS.SendMessage((int)this.table.handle, (int)4098, (int)1, (int)0);
        if (n4 != 0) {
            Object object;
            Object object2;
            int n5;
            int n6 = Math.min(tableItemArray.length, 10);
            Rectangle rectangle = tableItemArray[0].getBounds(0);
            for (n5 = 1; n5 < n6; ++n5) {
                rectangle = rectangle.union(tableItemArray[n5].getBounds(0));
            }
            n5 = OS.GetDC((int)0);
            int n7 = OS.CreateCompatibleDC((int)n5);
            int n8 = OS.CreateCompatibleBitmap((int)n5, (int)rectangle.width, (int)rectangle.height);
            int n9 = OS.SelectObject((int)n7, (int)n8);
            RECT rECT = new RECT();
            rECT.right = rectangle.width;
            rECT.bottom = rectangle.height;
            int n10 = OS.GetStockObject((int)0);
            OS.FillRect((int)n7, (RECT)rECT, (int)n10);
            for (int i2 = 0; i2 < n6; ++i2) {
                object2 = tableItemArray[i2];
                object = ((TableItem)object2).getBounds(0);
                POINT pOINT = new POINT();
                int n11 = OS.SendMessage((int)this.table.handle, (int)4129, (int)this.table.indexOf((TableItem)object2), (POINT)pOINT);
                OS.ImageList_Draw((int)n11, (int)0, (int)n7, (int)(((Rectangle)object).x - rectangle.x), (int)(((Rectangle)object).y - rectangle.y), (int)4);
                OS.ImageList_Destroy((int)n11);
            }
            OS.SelectObject((int)n7, (int)n9);
            OS.DeleteDC((int)n7);
            OS.ReleaseDC((int)0, (int)n5);
            Display display = this.table.getDisplay();
            object2 = Image.win32_new((Device)display, (int)0, (int)n8);
            object = ((Image)object2).getImageData();
            ((Image)object2).dispose();
            return object;
        }
        return null;
    }

    void showDropTargetEffect(int n2, int n3, int n4) {
        n2 = this.checkEffect(n2);
        int n5 = this.table.handle;
        Point point = new Point(n3, n4);
        point = this.table.toControl(point);
        LVHITTESTINFO lVHITTESTINFO = new LVHITTESTINFO();
        lVHITTESTINFO.x = point.x;
        lVHITTESTINFO.y = point.y;
        OS.SendMessage((int)n5, (int)4114, (int)0, (LVHITTESTINFO)lVHITTESTINFO);
        if ((n2 & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollIndex = -1;
        } else if (lVHITTESTINFO.iItem != -1 && this.scrollIndex == lVHITTESTINFO.iItem && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                int n6 = Math.max(0, OS.SendMessage((int)n5, (int)4135, (int)0, (int)0));
                int n7 = OS.SendMessage((int)n5, (int)4100, (int)0, (int)0);
                int n8 = this.scrollIndex - 1 < n6 ? Math.max(0, this.scrollIndex - 1) : Math.min(n7 - 1, this.scrollIndex + 1);
                boolean bl = true;
                if (lVHITTESTINFO.iItem == n6) {
                    bl = lVHITTESTINFO.iItem != n8;
                } else {
                    RECT rECT = new RECT();
                    rECT.left = 0;
                    if (OS.SendMessage((int)n5, (int)4110, (int)lVHITTESTINFO.iItem, (RECT)rECT) != 0) {
                        RECT rECT2 = new RECT();
                        OS.GetClientRect((int)n5, (RECT)rECT2);
                        POINT pOINT = new POINT();
                        pOINT.x = rECT.left;
                        pOINT.y = rECT.top;
                        if (OS.PtInRect((RECT)rECT2, (POINT)pOINT)) {
                            pOINT.y = rECT.bottom;
                            if (OS.PtInRect((RECT)rECT2, (POINT)pOINT)) {
                                bl = false;
                            }
                        }
                    }
                }
                if (bl) {
                    OS.SendMessage((int)n5, (int)4115, (int)n8, (int)0);
                    this.table.redraw();
                }
                this.scrollBeginTime = 0L;
                this.scrollIndex = -1;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 200L;
            this.scrollIndex = lVHITTESTINFO.iItem;
        }
        if (lVHITTESTINFO.iItem != -1 && (n2 & 1) != 0) {
            TableItem tableItem = this.table.getItem(lVHITTESTINFO.iItem);
            if (this.dropHighlight != tableItem) {
                LVITEM lVITEM = new LVITEM();
                lVITEM.stateMask = 8;
                OS.SendMessage((int)n5, (int)4139, (int)-1, (LVITEM)lVITEM);
                lVITEM.state = 8;
                OS.SendMessage((int)n5, (int)4139, (int)lVHITTESTINFO.iItem, (LVITEM)lVITEM);
                this.dropHighlight = tableItem;
            }
        } else if (this.dropHighlight != null) {
            LVITEM lVITEM = new LVITEM();
            lVITEM.stateMask = 8;
            OS.SendMessage((int)n5, (int)4139, (int)-1, (LVITEM)lVITEM);
            this.dropHighlight = null;
        }
    }
}

