/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.eclipse.swt.dnd.TransferData;

public abstract class Transfer {
    protected abstract DataFlavor getDataFlavor();

    public abstract TransferData[] getSupportedTypes();

    public boolean isSupportedType(TransferData transferData) {
        TransferData[] transferDataArray = this.getSupportedTypes();
        for (int i2 = 0; i2 < transferDataArray.length; ++i2) {
            if (!transferDataArray[i2].dataFlavor.equals(transferData.dataFlavor)) continue;
            return true;
        }
        return false;
    }

    protected int[] getTypeIds() {
        TransferData[] transferDataArray = this.getSupportedTypes();
        int[] nArray = new int[transferDataArray.length];
        for (int i2 = 0; i2 < transferDataArray.length; ++i2) {
            nArray[i2] = Transfer.getTypeID(transferDataArray[i2].dataFlavor.getHumanPresentableName());
        }
        return nArray;
    }

    protected String[] getTypeNames() {
        TransferData[] transferDataArray = this.getSupportedTypes();
        String[] stringArray = new String[transferDataArray.length];
        for (int i2 = 0; i2 < transferDataArray.length; ++i2) {
            stringArray[i2] = transferDataArray[i2].dataFlavor.getHumanPresentableName();
        }
        return stringArray;
    }

    protected abstract void javaToNative(Object var1, TransferData var2);

    protected Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.transferable == null) {
            return null;
        }
        try {
            return transferData.transferable.getTransferData(this.getDataFlavor());
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static int registerType(String string) {
        return Transfer.getTypeID(string);
    }

    static int getTypeID(String string) {
        int n2 = string.length();
        if (n2 > 4) {
            return string.hashCode();
        }
        int n3 = 0;
        if (n2 > 0) {
            n3 |= (string.charAt(0) & 0xFF) << 24;
        }
        if (n2 > 1) {
            n3 |= (string.charAt(1) & 0xFF) << 16;
        }
        if (n2 > 2) {
            n3 |= (string.charAt(2) & 0xFF) << 8;
        }
        if (n2 > 3) {
            n3 |= string.charAt(3) & 0xFF;
        }
        return n3;
    }

    protected boolean validate(Object object) {
        return true;
    }
}

