/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public class URLTransfer
extends Transfer {
    private static URLTransfer _instance = new URLTransfer();
    static DataFlavor URL_FLAVOR = new DataFlavor("text/uri-list; class=java.lang.String", "URI list");

    private URLTransfer() {
    }

    public static URLTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        String string;
        if (!this.checkURL(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        if (!(string = ((String[])object)[0]).endsWith("\r\n")) {
            if (string.endsWith("\n")) {
                string = string.substring(0, string.length() - 1) + "\r\n";
            } else if (string.endsWith("\r")) {
                string = string + "\n";
            }
        }
        transferData.transferable = new StringSelection(string);
    }

    public Object nativeToJava(TransferData transferData) {
        String string = (String)super.nativeToJava(transferData);
        if (string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.endsWith("\r")) {
            string = string.substring(0, string.length() - 1);
        }
        return new String[]{string, null};
    }

    boolean checkURL(Object object) {
        if (object == null || !(object instanceof String[]) || ((String[])object).length == 0) {
            return false;
        }
        String[] stringArray = (String[])object;
        if (stringArray[0] == null || stringArray[0].length() == 0) {
            return false;
        }
        try {
            new URL(stringArray[0]);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return true;
    }

    protected boolean validate(Object object) {
        return this.checkURL(object);
    }

    public TransferData[] getSupportedTypes() {
        TransferData transferData = new TransferData();
        transferData.dataFlavor = URL_FLAVOR;
        return new TransferData[]{transferData};
    }

    protected DataFlavor getDataFlavor() {
        return URL_FLAVOR;
    }
}

