/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.swing.CGC;
import org.eclipse.swt.internal.swing.LookAndFeelUtils;

public abstract class Device
implements Drawable {
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    boolean disposed;
    static final Object CREATE_LOCK;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;

    static synchronized Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device(DeviceData deviceData) {
        Object object = CREATE_LOCK;
        synchronized (object) {
            if (deviceData != null) {
                this.debug = deviceData.debug;
                this.tracking = deviceData.tracking;
            }
            this.create(deviceData);
            this.init();
            if (this.tracking) {
                this.errors = new Error[128];
                this.objects = new Object[128];
            }
        }
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    protected void create(DeviceData deviceData) {
    }

    protected void destroy() {
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.checkDevice();
        this.release();
        this.destroy();
        this.disposed = true;
        if (this.tracking) {
            this.objects = null;
            this.errors = null;
        }
    }

    void dispose_Object(Object object) {
        for (int i2 = 0; i2 < this.objects.length; ++i2) {
            if (this.objects[i2] != object) continue;
            this.objects[i2] = null;
            this.errors[i2] = null;
            return;
        }
    }

    public Rectangle getBounds() {
        this.checkDevice();
        throw new IllegalStateException("Not implemented!");
    }

    public DeviceData getDeviceData() {
        int n2;
        this.checkDevice();
        DeviceData deviceData = new DeviceData();
        deviceData.debug = this.debug;
        deviceData.tracking = this.tracking;
        int n3 = 0;
        int n4 = 0;
        if (this.tracking) {
            n4 = this.objects.length;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            if (this.objects[n2] == null) continue;
            ++n3;
        }
        n2 = 0;
        deviceData.objects = new Object[n3];
        deviceData.errors = new Error[n3];
        for (int i2 = 0; i2 < n4; ++i2) {
            if (this.objects[i2] == null) continue;
            deviceData.objects[n2] = this.objects[i2];
            deviceData.errors[n2] = this.errors[i2];
            ++n2;
        }
        return deviceData;
    }

    public Rectangle getClientArea() {
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        DisplayMode displayMode = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode();
        if (displayMode == null) {
            return 32;
        }
        int n2 = displayMode.getBitDepth();
        return n2 == -1 ? 32 : n2;
    }

    public Point getDPI() {
        this.checkDevice();
        return this.getDPI_();
    }

    protected Point getDPI_() {
        int n2 = Toolkit.getDefaultToolkit().getScreenResolution();
        return new Point(n2, n2);
    }

    public FontData[] getFontList(String string, boolean bl) {
        java.awt.Font[] fontArray;
        FontData[] fontDataArray;
        this.checkDevice();
        if (!bl) {
            return new FontData[0];
        }
        if (string != null) {
            fontDataArray = new java.awt.Font(string, 0, 1);
            fontArray = !"Dialog".equals(string) && "Dialog".equals(fontDataArray.getFamily()) ? new java.awt.Font[]{} : new java.awt.Font[]{fontDataArray};
        } else {
            fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        }
        fontDataArray = new FontData[fontArray.length];
        for (int i2 = 0; i2 < fontArray.length; ++i2) {
            java.awt.Font font = fontArray[i2];
            fontDataArray[i2] = new FontData(font.getFamily(), 12, 0 | (font.isBold() ? 1 : 0) | (font.isItalic() ? 2 : 0));
        }
        return fontDataArray;
    }

    public Color getSystemColor(int n2) {
        this.checkDevice();
        java.awt.Color color = java.awt.Color.BLACK;
        switch (n2) {
            case 1: {
                color = java.awt.Color.WHITE;
                break;
            }
            case 2: {
                color = java.awt.Color.BLACK;
                break;
            }
            case 3: {
                color = java.awt.Color.RED;
                break;
            }
            case 4: {
                color = java.awt.Color.RED.darker();
                break;
            }
            case 5: {
                color = java.awt.Color.GREEN;
                break;
            }
            case 6: {
                color = java.awt.Color.GREEN.darker();
                break;
            }
            case 7: {
                color = java.awt.Color.YELLOW;
                break;
            }
            case 8: {
                color = java.awt.Color.YELLOW.darker();
                break;
            }
            case 9: {
                color = java.awt.Color.BLUE;
                break;
            }
            case 10: {
                color = java.awt.Color.BLUE.darker();
                break;
            }
            case 11: {
                color = java.awt.Color.MAGENTA;
                break;
            }
            case 12: {
                color = java.awt.Color.MAGENTA.darker();
                break;
            }
            case 13: {
                color = java.awt.Color.CYAN;
                break;
            }
            case 14: {
                color = java.awt.Color.CYAN.darker();
                break;
            }
            case 15: {
                color = java.awt.Color.GRAY;
                break;
            }
            case 16: {
                color = java.awt.Color.GRAY.darker();
            }
        }
        return Color.swing_new(this, color);
    }

    public Font getSystemFont() {
        this.checkDevice();
        return Font.swing_new(this, LookAndFeelUtils.getSystemFont());
    }

    public boolean getWarnings() {
        this.checkDevice();
        return false;
    }

    protected void init() {
    }

    public abstract CGC internal_new_GC(GCData var1);

    public abstract void internal_dispose_GC(CGC var1, GCData var2);

    public boolean isDisposed() {
        return this.disposed;
    }

    void new_Object(Object object) {
        for (int i2 = 0; i2 < this.objects.length; ++i2) {
            if (this.objects[i2] != null) continue;
            this.objects[i2] = object;
            this.errors[i2] = new Error();
            return;
        }
        Object[] objectArray = new Object[this.objects.length + 128];
        System.arraycopy(this.objects, 0, objectArray, 0, this.objects.length);
        objectArray[this.objects.length] = object;
        this.objects = objectArray;
        Error[] errorArray = new Error[this.errors.length + 128];
        System.arraycopy(this.errors, 0, errorArray, 0, this.errors.length);
        errorArray[this.errors.length] = new Error();
        this.errors = errorArray;
    }

    protected void release() {
    }

    public void setWarnings(boolean bl) {
        this.checkDevice();
    }

    static {
        CREATE_LOCK = new Object();
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

