/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.awt.font.TextAttribute;
import java.util.HashMap;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Resource;

public final class Font
extends Resource {
    public java.awt.Font handle;
    FontData fontData;

    Font() {
    }

    public Font(Device device, FontData fontData) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, fontData);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Font(Device device, FontData[] fontDataArray) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (fontDataArray == null) {
            SWT.error(4);
        }
        if (fontDataArray.length == 0) {
            SWT.error(5);
        }
        for (int i2 = 0; i2 < fontDataArray.length; ++i2) {
            if (fontDataArray[i2] != null) continue;
            SWT.error(5);
        }
        this.init(device, fontDataArray[0]);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Font(Device device, String string, int n2, int n3) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (string == null) {
            SWT.error(4);
        }
        this.init(device, new FontData(string, n2, n3));
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void dispose() {
        if (this.handle == null) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        this.handle = null;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Font)) {
            return false;
        }
        Font font = (Font)object;
        return this.device == font.device && this.handle == font.handle;
    }

    public FontData[] getFontData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new FontData[]{new FontData(this.fontData)};
    }

    public int hashCode() {
        return this.handle == null ? 0 : this.handle.hashCode();
    }

    void init(Device device, FontData fontData) {
        if (fontData == null) {
            SWT.error(4);
        }
        this.device = device;
        this.fontData = new FontData(fontData);
        int n2 = fontData.getStyle();
        int n3 = Math.round((float)(fontData.getHeight() * device.getDPI().x) / 72.0f);
        if (this.fontData.data != null) {
            HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>(this.fontData.data);
            hashMap.put(TextAttribute.FAMILY, fontData.getName());
            hashMap.put(TextAttribute.POSTURE, (n2 & 2) != 0 ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
            hashMap.put(TextAttribute.WEIGHT, (n2 & 1) != 0 ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
            this.handle = new java.awt.Font(hashMap);
        } else {
            this.handle = new java.awt.Font(fontData.getName(), 0 | ((n2 & 2) != 0 ? 2 : 0) | ((n2 & 1) != 0 ? 1 : 0), n3);
        }
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Font {*DISPOSED*}";
        }
        return "Font {" + this.handle + "}";
    }

    public static Font swing_new(Device device, java.awt.Font font) {
        if (device == null) {
            device = Device.getDevice();
        }
        Font font2 = new Font();
        font2.handle = font;
        font2.device = device;
        int n2 = font.getStyle();
        int n3 = Math.round((float)font.getSize() * 72.0f / (float)device.getDPI_().x);
        font2.fontData = new FontData(font.getName(), n3, 0 | ((n2 & 2) != 0 ? 2 : 0) | ((n2 & 1) != 0 ? 1 : 0));
        return font2;
    }
}

