/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.SerializableCompatibility;

public final class Rectangle
implements SerializableCompatibility {
    public int x;
    public int y;
    public int width;
    public int height;
    static final long serialVersionUID = 3256439218279428914L;

    public Rectangle(int n2, int n3, int n4, int n5) {
        this.x = n2;
        this.y = n3;
        this.width = n4;
        this.height = n5;
    }

    public void add(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        int n2 = this.x < rectangle.x ? this.x : rectangle.x;
        int n3 = this.y < rectangle.y ? this.y : rectangle.y;
        int n4 = this.x + this.width;
        int n5 = rectangle.x + rectangle.width;
        int n6 = n4 > n5 ? n4 : n5;
        n4 = this.y + this.height;
        n5 = rectangle.y + rectangle.height;
        int n7 = n4 > n5 ? n4 : n5;
        this.x = n2;
        this.y = n3;
        this.width = n6 - n2;
        this.height = n7 - n3;
    }

    public boolean contains(int n2, int n3) {
        return n2 >= this.x && n3 >= this.y && n2 - this.x < this.width && n3 - this.y < this.height;
    }

    public boolean contains(Point point) {
        if (point == null) {
            SWT.error(4);
        }
        return this.contains(point.x, point.y);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Rectangle)) {
            return false;
        }
        Rectangle rectangle = (Rectangle)object;
        return rectangle.x == this.x && rectangle.y == this.y && rectangle.width == this.width && rectangle.height == this.height;
    }

    public int hashCode() {
        return this.x ^ this.y ^ this.width ^ this.height;
    }

    public void intersect(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        if (this == rectangle) {
            return;
        }
        int n2 = this.x > rectangle.x ? this.x : rectangle.x;
        int n3 = this.y > rectangle.y ? this.y : rectangle.y;
        int n4 = this.x + this.width;
        int n5 = rectangle.x + rectangle.width;
        int n6 = n4 < n5 ? n4 : n5;
        n4 = this.y + this.height;
        n5 = rectangle.y + rectangle.height;
        int n7 = n4 < n5 ? n4 : n5;
        this.x = n6 < n2 ? 0 : n2;
        this.y = n7 < n3 ? 0 : n3;
        this.width = n6 < n2 ? 0 : n6 - n2;
        this.height = n7 < n3 ? 0 : n7 - n3;
    }

    public Rectangle intersection(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        if (this == rectangle) {
            return new Rectangle(this.x, this.y, this.width, this.height);
        }
        int n2 = this.x > rectangle.x ? this.x : rectangle.x;
        int n3 = this.y > rectangle.y ? this.y : rectangle.y;
        int n4 = this.x + this.width;
        int n5 = rectangle.x + rectangle.width;
        int n6 = n4 < n5 ? n4 : n5;
        n4 = this.y + this.height;
        n5 = rectangle.y + rectangle.height;
        int n7 = n4 < n5 ? n4 : n5;
        return new Rectangle(n6 < n2 ? 0 : n2, n7 < n3 ? 0 : n3, n6 < n2 ? 0 : n6 - n2, n7 < n3 ? 0 : n7 - n3);
    }

    public boolean intersects(int n2, int n3, int n4, int n5) {
        return n2 < this.x + this.width && n3 < this.y + this.height && n2 + n4 > this.x && n3 + n5 > this.y;
    }

    public boolean intersects(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        return rectangle == this || this.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public String toString() {
        return "Rectangle {" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + "}";
    }

    public Rectangle union(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        int n2 = this.x < rectangle.x ? this.x : rectangle.x;
        int n3 = this.y < rectangle.y ? this.y : rectangle.y;
        int n4 = this.x + this.width;
        int n5 = rectangle.x + rectangle.width;
        int n6 = n4 > n5 ? n4 : n5;
        n4 = this.y + this.height;
        n5 = rectangle.y + rectangle.height;
        int n7 = n4 > n5 ? n4 : n5;
        return new Rectangle(n2, n3, n6 - n2, n7 - n3);
    }
}

