/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Resource;

public class Transform
extends Resource {
    public AffineTransform handle;

    public Transform(Device device) {
        this(device, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    }

    public Transform(Device device, float[] fArray) {
        this(device, Transform.checkTransform(fArray)[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
    }

    public Transform(Device device, float f2, float f3, float f4, float f5, float f6, float f7) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.handle = new AffineTransform(f2, f3, f4, f5, f6, f7);
        if (this.handle == null) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    static float[] checkTransform(float[] fArray) {
        if (fArray == null) {
            SWT.error(4);
        }
        if (fArray.length < 6) {
            SWT.error(5);
        }
        return fArray;
    }

    public void dispose() {
        if (this.handle == null) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        this.handle = null;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public void getElements(float[] fArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (fArray == null) {
            SWT.error(4);
        }
        if (fArray.length < 6) {
            SWT.error(5);
        }
        double[] dArray = new double[6];
        this.handle.getMatrix(dArray);
        for (int i2 = 0; i2 < 6; ++i2) {
            fArray[i2] = (float)dArray[i2];
        }
    }

    public void invert() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        try {
            this.handle = this.handle.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            SWT.error(10);
        }
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public boolean isIdentity() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle.isIdentity();
    }

    public void multiply(Transform transform) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        this.handle.concatenate(transform.handle);
    }

    public void rotate(float f2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.handle.rotate((double)f2 * Math.PI / 180.0);
    }

    public void scale(float f2, float f3) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.handle.scale(f2, f3);
    }

    public void setElements(float f2, float f3, float f4, float f5, float f6, float f7) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.handle.setTransform(f2, f3, f4, f5, f6, f7);
    }

    public void transform(float[] fArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (fArray == null) {
            SWT.error(4);
        }
        this.handle.transform(fArray, 0, fArray, 0, fArray.length);
    }

    public void translate(float f2, float f3) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.handle.translate(f2, f3);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Transform {*DISPOSED*}";
        }
        float[] fArray = new float[6];
        this.getElements(fArray);
        return "Transform {" + fArray[0] + "," + fArray[1] + "," + fArray[2] + "," + fArray[3] + "," + fArray[4] + "," + fArray[5] + "}";
    }
}

