/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import org.eclipse.swt.internal.swing.CCombo;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;

class CComboImplementation
extends JComboBox
implements CCombo {
    protected Combo handle;
    protected CControl.UserAttributeHandler userAttributeHandler;
    protected boolean isDefaultButtonHackActive;
    protected int textLimit = Combo.LIMIT;

    public Container getSwingComponent() {
        return this;
    }

    public Control getSWTHandle() {
        return this.handle;
    }

    public CControl.UserAttributeHandler getUserAttributeHandler() {
        return this.userAttributeHandler;
    }

    public CComboImplementation(Combo combo, int n2) {
        this.handle = combo;
        this.userAttributeHandler = new CControl.UserAttributeHandler(this);
        this.setLightWeightPopupEnabled(Utils.isLightweightPopups());
        this.init(n2);
    }

    public boolean isPopupVisible() {
        boolean bl = super.isPopupVisible();
        if (!bl) {
            return this.isDefaultButtonHackActive;
        }
        return bl;
    }

    protected void init(int n2) {
        int n3;
        this.setEditable((n2 & 8) == 0);
        Utils.installMouseListener(this, this.handle);
        Utils.installKeyListener(this, this.handle);
        Utils.installFocusListener(this, this.handle);
        Utils.installComponentListener(this, this.handle);
        JTextField jTextField = (JTextField)this.getEditor().getEditorComponent();
        ActionListener[] actionListenerArray = jTextField.getActionListeners();
        for (n3 = actionListenerArray.length - 1; n3 >= 0; --n3) {
            jTextField.removeActionListener(actionListenerArray[n3]);
        }
        jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                CComboImplementation.this.isDefaultButtonHackActive = false;
            }
        });
        for (n3 = 0; n3 < actionListenerArray.length; ++n3) {
            jTextField.addActionListener(actionListenerArray[n3]);
        }
        jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                CComboImplementation.this.isDefaultButtonHackActive = true;
                CComboImplementation.this.handle.processEvent(e2);
            }
        });
        ((AbstractDocument)((JTextComponent)this.getEditor().getEditorComponent()).getDocument()).setDocumentFilter(new DocumentFilter(){

            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                if (CComboImplementation.this.getEditorText().length() - length + text.length() > CComboImplementation.this.getEditorTextLimit()) {
                    return;
                }
                super.replace(fb, offset, length, text, attrs);
            }
        });
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e2) {
                CComboImplementation.this.handle.processEvent(e2);
            }
        });
    }

    public JScrollBar getHorizontalScrollBar() {
        return null;
    }

    public JScrollBar getVerticalScrollBar() {
        return null;
    }

    public Container getClientArea() {
        return this;
    }

    public void insertElementAt(Object object, int n2) {
        ((DefaultComboBoxModel)this.getModel()).insertElementAt(object, n2);
    }

    public String getEditorText() {
        Object object = this.getSelectedItem();
        return object == null ? "" : String.valueOf(object);
    }

    public void setEditorText(String string) {
        this.setSelectedItem(string);
    }

    public void copyEditor() {
        ((JTextComponent)this.getEditor().getEditorComponent()).copy();
    }

    public void cutEditor() {
        ((JTextComponent)this.getEditor().getEditorComponent()).cut();
    }

    public void pasteEditor() {
        ((JTextComponent)this.getEditor().getEditorComponent()).paste();
    }

    public void setEditorCaretPosition(int n2) {
        ((JTextComponent)this.getEditor().getEditorComponent()).setCaretPosition(n2);
    }

    public int getEditorSelectionStart() {
        return ((JTextComponent)this.getEditor().getEditorComponent()).getSelectionStart();
    }

    public void setEditorSelectionStart(int n2) {
        ((JTextComponent)this.getEditor().getEditorComponent()).setSelectionStart(n2);
    }

    public int getEditorSelectionEnd() {
        return ((JTextComponent)this.getEditor().getEditorComponent()).getSelectionEnd();
    }

    public void setEditorSelectionEnd(int n2) {
        ((JTextComponent)this.getEditor().getEditorComponent()).setSelectionEnd(n2);
    }

    public void clearEditorSelection() {
        JTextComponent jTextComponent = (JTextComponent)this.getEditor().getEditorComponent();
        jTextComponent.setSelectionStart(jTextComponent.getSelectionEnd());
    }

    public void setEditorTextLimit(int n2) {
        this.textLimit = n2;
        String string = this.getEditorText();
        if (string.length() > n2) {
            this.setEditorText(string.substring(0, n2));
        }
    }

    public int getEditorTextLimit() {
        return this.textLimit;
    }

    public Dimension getEditorSize() {
        return ((JTextComponent)this.getEditor().getEditorComponent()).getSize();
    }

    public void reshape(int n2, int n3, int n4, int n5) {
        super.reshape(n2, n3, n4, this.getPreferredSize().height);
    }

    public Color getBackground() {
        return this.userAttributeHandler != null && this.userAttributeHandler.background != null ? this.userAttributeHandler.background : super.getBackground();
    }

    public Color getForeground() {
        return this.userAttributeHandler != null && this.userAttributeHandler.foreground != null ? this.userAttributeHandler.foreground : super.getForeground();
    }

    public Font getFont() {
        return this.userAttributeHandler != null && this.userAttributeHandler.font != null ? this.userAttributeHandler.font : super.getFont();
    }

    public Cursor getCursor() {
        if (Utils.globalCursor != null) {
            return Utils.globalCursor;
        }
        return this.userAttributeHandler != null && this.userAttributeHandler.cursor != null ? this.userAttributeHandler.cursor : super.getCursor();
    }

    public void setBackgroundImage(Image image) {
    }

    public void setBackgroundInheritance(int n2) {
        switch (n2) {
            case 0: 
            case 1: {
                this.setOpaque(true);
                ((JComponent)this.getEditor().getEditorComponent()).setOpaque(true);
                break;
            }
            case 2: {
                this.setOpaque(false);
                ((JComponent)this.getEditor().getEditorComponent()).setOpaque(false);
            }
        }
    }
}

